rule win_diztakun_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.diztakun."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.diztakun"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7f05 b8???????? e8???????? 8b4c2444 8b5c2428 8b6c2430 }
            // n = 6, score = 100
            //   7f05                 | jg                  7
            //   b8????????           |                     
            //   e8????????           |                     
            //   8b4c2444             | mov                 ecx, dword ptr [esp + 0x44]
            //   8b5c2428             | mov                 ebx, dword ptr [esp + 0x28]
            //   8b6c2430             | mov                 ebp, dword ptr [esp + 0x30]

        $sequence_1 = { 53 e8???????? cc 5a 58 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   e8????????           |                     
            //   cc                   | int3                
            //   5a                   | pop                 edx
            //   58                   | pop                 eax

        $sequence_2 = { 7d0c 57 8bcb e8???????? 8b542418 8b0b 3bf5 }
            // n = 7, score = 100
            //   7d0c                 | jge                 0xe
            //   57                   | push                edi
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   8b0b                 | mov                 ecx, dword ptr [ebx]
            //   3bf5                 | cmp                 esi, ebp

        $sequence_3 = { e9???????? 8b451c 83c0c7 56 83f80b 0f87c4000000 ff2485ffff4000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   83c0c7               | add                 eax, -0x39
            //   56                   | push                esi
            //   83f80b               | cmp                 eax, 0xb
            //   0f87c4000000         | ja                  0xca
            //   ff2485ffff4000       | jmp                 dword ptr [eax*4 + 0x40ffff]

        $sequence_4 = { 7574 8b4008 3bc6 746d 663930 7468 8b5808 }
            // n = 7, score = 100
            //   7574                 | jne                 0x76
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   3bc6                 | cmp                 eax, esi
            //   746d                 | je                  0x6f
            //   663930               | cmp                 word ptr [eax], si
            //   7468                 | je                  0x6a
            //   8b5808               | mov                 ebx, dword ptr [eax + 8]

        $sequence_5 = { 50 8d84241c020000 64a300000000 8b84242c020000 6a00 6a00 8d4c2420 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d84241c020000       | lea                 eax, [esp + 0x21c]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8b84242c020000       | mov                 eax, dword ptr [esp + 0x22c]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d4c2420             | lea                 ecx, [esp + 0x20]

        $sequence_6 = { ff15???????? 83c6f0 56 e8???????? 8b7c2418 83c010 8907 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   83c6f0               | add                 esi, -0x10
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b7c2418             | mov                 edi, dword ptr [esp + 0x18]
            //   83c010               | add                 eax, 0x10
            //   8907                 | mov                 dword ptr [edi], eax

        $sequence_7 = { 89642418 8bfc 50 e8???????? 83c010 83c404 8907 }
            // n = 7, score = 100
            //   89642418             | mov                 dword ptr [esp + 0x18], esp
            //   8bfc                 | mov                 edi, esp
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c010               | add                 eax, 0x10
            //   83c404               | add                 esp, 4
            //   8907                 | mov                 dword ptr [edi], eax

        $sequence_8 = { 8b8254010000 83c404 8bcb ffd0 }
            // n = 4, score = 100
            //   8b8254010000         | mov                 eax, dword ptr [edx + 0x154]
            //   83c404               | add                 esp, 4
            //   8bcb                 | mov                 ecx, ebx
            //   ffd0                 | call                eax

        $sequence_9 = { 8bd9 895c2414 c744241000000000 e8???????? 33c9 85c0 0f95c1 }
            // n = 7, score = 100
            //   8bd9                 | mov                 ebx, ecx
            //   895c2414             | mov                 dword ptr [esp + 0x14], ebx
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   85c0                 | test                eax, eax
            //   0f95c1               | setne               cl

    condition:
        7 of them and filesize < 688128
}