rule win_dmsniff_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dmsniff."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dmsniff"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7316 8bbdfcfeffff 89fe 46 89b5fcfeffff 899cbd00ffffff 8d85f0feffff }
            // n = 7, score = 500
            //   7316                 | jae                 0x18
            //   8bbdfcfeffff         | mov                 edi, dword ptr [ebp - 0x104]
            //   89fe                 | mov                 esi, edi
            //   46                   | inc                 esi
            //   89b5fcfeffff         | mov                 dword ptr [ebp - 0x104], esi
            //   899cbd00ffffff       | mov                 dword ptr [ebp + edi*4 - 0x100], ebx
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]

        $sequence_1 = { d92c24 83c404 6a00 6a00 68???????? 68???????? }
            // n = 6, score = 500
            //   d92c24               | fldcw               word ptr [esp]
            //   83c404               | add                 esp, 4
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     
            //   68????????           |                     

        $sequence_2 = { 50 8b10 ff5220 89c7 09ff 0f8563010000 6a00 }
            // n = 7, score = 500
            //   50                   | push                eax
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   ff5220               | call                dword ptr [edx + 0x20]
            //   89c7                 | mov                 edi, eax
            //   09ff                 | or                  edi, edi
            //   0f8563010000         | jne                 0x169
            //   6a00                 | push                0

        $sequence_3 = { 50 8b10 ff5250 89c7 }
            // n = 4, score = 500
            //   50                   | push                eax
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   ff5250               | call                dword ptr [edx + 0x50]
            //   89c7                 | mov                 edi, eax

        $sequence_4 = { 47 39f7 72d3 ff45fc 8b45f4 3945fc 72c2 }
            // n = 7, score = 500
            //   47                   | inc                 edi
            //   39f7                 | cmp                 edi, esi
            //   72d3                 | jb                  0xffffffd5
            //   ff45fc               | inc                 dword ptr [ebp - 4]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   3945fc               | cmp                 dword ptr [ebp - 4], eax
            //   72c2                 | jb                  0xffffffc4

        $sequence_5 = { f7e7 8945ec 50 e8???????? 89c3 }
            // n = 5, score = 500
            //   f7e7                 | mul                 edi
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   50                   | push                eax
            //   e8????????           |                     
            //   89c3                 | mov                 ebx, eax

        $sequence_6 = { 59 be0f000000 39c6 761a 68???????? e8???????? }
            // n = 6, score = 500
            //   59                   | pop                 ecx
            //   be0f000000           | mov                 esi, 0xf
            //   39c6                 | cmp                 esi, eax
            //   761a                 | jbe                 0x1c
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_7 = { 50 ff7508 e8???????? 68???????? e8???????? 50 ff7508 }
            // n = 7, score = 500
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_8 = { e8???????? 68???????? e8???????? 89c2 6a00 }
            // n = 5, score = 500
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   89c2                 | mov                 edx, eax
            //   6a00                 | push                0

        $sequence_9 = { 89c3 81e3ff000000 89de 83c661 89f3 881d???????? b803000000 }
            // n = 7, score = 500
            //   89c3                 | mov                 ebx, eax
            //   81e3ff000000         | and                 ebx, 0xff
            //   89de                 | mov                 esi, ebx
            //   83c661               | add                 esi, 0x61
            //   89f3                 | mov                 ebx, esi
            //   881d????????         |                     
            //   b803000000           | mov                 eax, 3

    condition:
        7 of them and filesize < 131072
}