rule win_dnespy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dnespy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dnespy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b54240c a1???????? 89542414 81faff0f0000 762d 0f1f00 ff774c }
            // n = 7, score = 200
            //   8b54240c             | mov                 edx, dword ptr [esp + 0xc]
            //   a1????????           |                     
            //   89542414             | mov                 dword ptr [esp + 0x14], edx
            //   81faff0f0000         | cmp                 edx, 0xfff
            //   762d                 | jbe                 0x2f
            //   0f1f00               | nop                 dword ptr [eax]
            //   ff774c               | push                dword ptr [edi + 0x4c]

        $sequence_1 = { 83f80a 0f85e6080000 834608fc 8b55dc 85d2 791b 8bc2 }
            // n = 7, score = 200
            //   83f80a               | cmp                 eax, 0xa
            //   0f85e6080000         | jne                 0x8ec
            //   834608fc             | add                 dword ptr [esi + 8], -4
            //   8b55dc               | mov                 edx, dword ptr [ebp - 0x24]
            //   85d2                 | test                edx, edx
            //   791b                 | jns                 0x1d
            //   8bc2                 | mov                 eax, edx

        $sequence_2 = { 894618 837e0cff 7403 ff4e24 8bce e8???????? 8b4e0c }
            // n = 7, score = 200
            //   894618               | mov                 dword ptr [esi + 0x18], eax
            //   837e0cff             | cmp                 dword ptr [esi + 0xc], -1
            //   7403                 | je                  5
            //   ff4e24               | dec                 dword ptr [esi + 0x24]
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b4e0c               | mov                 ecx, dword ptr [esi + 0xc]

        $sequence_3 = { 83f9ff 7245 880a 0facc108 c1e808 884a01 0facc108 }
            // n = 7, score = 200
            //   83f9ff               | cmp                 ecx, -1
            //   7245                 | jb                  0x47
            //   880a                 | mov                 byte ptr [edx], cl
            //   0facc108             | shrd                ecx, eax, 8
            //   c1e808               | shr                 eax, 8
            //   884a01               | mov                 byte ptr [edx + 1], cl
            //   0facc108             | shrd                ecx, eax, 8

        $sequence_4 = { 8975b4 c745b80f000000 c645a400 8d8de8feffff e8???????? 8b531c 83fa10 }
            // n = 7, score = 200
            //   8975b4               | mov                 dword ptr [ebp - 0x4c], esi
            //   c745b80f000000       | mov                 dword ptr [ebp - 0x48], 0xf
            //   c645a400             | mov                 byte ptr [ebp - 0x5c], 0
            //   8d8de8feffff         | lea                 ecx, [ebp - 0x118]
            //   e8????????           |                     
            //   8b531c               | mov                 edx, dword ptr [ebx + 0x1c]
            //   83fa10               | cmp                 edx, 0x10

        $sequence_5 = { 33c9 c645fc02 8b45e4 85c0 0f95c1 8d0c8d04000000 034d10 }
            // n = 7, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   85c0                 | test                eax, eax
            //   0f95c1               | setne               cl
            //   8d0c8d04000000       | lea                 ecx, [ecx*4 + 4]
            //   034d10               | add                 ecx, dword ptr [ebp + 0x10]

        $sequence_6 = { e9???????? 6a00 57 53 ff762c 56 e8???????? }
            // n = 7, score = 200
            //   e9????????           |                     
            //   6a00                 | push                0
            //   57                   | push                edi
            //   53                   | push                ebx
            //   ff762c               | push                dword ptr [esi + 0x2c]
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_7 = { 3bc3 7304 8bc3 eb0b 3dffffff3f 0f87ca000000 }
            // n = 6, score = 200
            //   3bc3                 | cmp                 eax, ebx
            //   7304                 | jae                 6
            //   8bc3                 | mov                 eax, ebx
            //   eb0b                 | jmp                 0xd
            //   3dffffff3f           | cmp                 eax, 0x3fffffff
            //   0f87ca000000         | ja                  0xd0

        $sequence_8 = { 8be8 8bc2 eb16 8b4618 53 ff761c }
            // n = 6, score = 200
            //   8be8                 | mov                 ebp, eax
            //   8bc2                 | mov                 eax, edx
            //   eb16                 | jmp                 0x18
            //   8b4618               | mov                 eax, dword ptr [esi + 0x18]
            //   53                   | push                ebx
            //   ff761c               | push                dword ptr [esi + 0x1c]

        $sequence_9 = { 6a20 c745e400000000 e8???????? 0f104588 8bc8 c745e400000000 8b45b0 }
            // n = 7, score = 200
            //   6a20                 | push                0x20
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   e8????????           |                     
            //   0f104588             | movups              xmm0, xmmword ptr [ebp - 0x78]
            //   8bc8                 | mov                 ecx, eax
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   8b45b0               | mov                 eax, dword ptr [ebp - 0x50]

    condition:
        7 of them and filesize < 794624
}