rule win_dnschanger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dnschanger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dnschanger"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c418 8d542410 8d442414 52 6806000200 6a00 50 }
            // n = 7, score = 100
            //   83c418               | add                 esp, 0x18
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   52                   | push                edx
            //   6806000200           | push                0x20006
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_1 = { 8d442414 52 6806000200 6a00 50 }
            // n = 5, score = 100
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   52                   | push                edx
            //   6806000200           | push                0x20006
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_2 = { 6a08 32db ffd5 50 ff15???????? }
            // n = 5, score = 100
            //   6a08                 | push                8
            //   32db                 | xor                 bl, bl
            //   ffd5                 | call                ebp
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_3 = { 32c0 eb0b ff15???????? 85c0 }
            // n = 4, score = 100
            //   32c0                 | xor                 al, al
            //   eb0b                 | jmp                 0xd
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_4 = { 8d442410 8b8b9c010000 50 57 51 e8???????? 83f86f }
            // n = 7, score = 100
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   8b8b9c010000         | mov                 ecx, dword ptr [ebx + 0x19c]
            //   50                   | push                eax
            //   57                   | push                edi
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83f86f               | cmp                 eax, 0x6f

        $sequence_5 = { 57 e8???????? 8b2d???????? 6880020000 6a08 }
            // n = 5, score = 100
            //   57                   | push                edi
            //   e8????????           |                     
            //   8b2d????????         |                     
            //   6880020000           | push                0x280
            //   6a08                 | push                8

        $sequence_6 = { 2ad1 f6da 1bd2 f7d2 23c2 }
            // n = 5, score = 100
            //   2ad1                 | sub                 dl, cl
            //   f6da                 | neg                 dl
            //   1bd2                 | sbb                 edx, edx
            //   f7d2                 | not                 edx
            //   23c2                 | and                 eax, edx

        $sequence_7 = { 8bf0 8d45f8 50 ff75f8 56 6a03 ff75fc }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   56                   | push                esi
            //   6a03                 | push                3
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_8 = { 84d2 7407 8a11 8816 46 }
            // n = 5, score = 100
            //   84d2                 | test                dl, dl
            //   7407                 | je                  9
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   8816                 | mov                 byte ptr [esi], dl
            //   46                   | inc                 esi

        $sequence_9 = { 8b442410 85c0 742a 83f80a 7415 }
            // n = 5, score = 100
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   85c0                 | test                eax, eax
            //   742a                 | je                  0x2c
            //   83f80a               | cmp                 eax, 0xa
            //   7415                 | je                  0x17

    condition:
        7 of them and filesize < 49152
}