rule win_dnspionage_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dnspionage."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dnspionage"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 99 52 50 e8???????? 83c408 8bd0 b9???????? }
            // n = 7, score = 300
            //   99                   | cdq                 
            //   52                   | push                edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8bd0                 | mov                 edx, eax
            //   b9????????           |                     

        $sequence_1 = { 33f6 8b4608 034604 0306 50 }
            // n = 5, score = 300
            //   33f6                 | xor                 esi, esi
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   034604               | add                 eax, dword ptr [esi + 4]
            //   0306                 | add                 eax, dword ptr [esi]
            //   50                   | push                eax

        $sequence_2 = { 803d????????00 7517 c605????????01 33c0 c605????????01 5b }
            // n = 6, score = 300
            //   803d????????00       |                     
            //   7517                 | jne                 0x19
            //   c605????????01       |                     
            //   33c0                 | xor                 eax, eax
            //   c605????????01       |                     
            //   5b                   | pop                 ebx

        $sequence_3 = { ff15???????? 83c404 33c0 5f 5e 5b 8b4df8 }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

        $sequence_4 = { 56 8d8500feffff 8bf1 50 e8???????? 838d0cfeffff07 8b4624 }
            // n = 7, score = 300
            //   56                   | push                esi
            //   8d8500feffff         | lea                 eax, [ebp - 0x200]
            //   8bf1                 | mov                 esi, ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   838d0cfeffff07       | or                  dword ptr [ebp - 0x1f4], 7
            //   8b4624               | mov                 eax, dword ptr [esi + 0x24]

        $sequence_5 = { eb0a 8d0492 8d144509000000 8bcf 43 }
            // n = 5, score = 300
            //   eb0a                 | jmp                 0xc
            //   8d0492               | lea                 eax, [edx + edx*4]
            //   8d144509000000       | lea                 edx, [eax*2 + 9]
            //   8bcf                 | mov                 ecx, edi
            //   43                   | inc                 ebx

        $sequence_6 = { c7450c00000000 8d4d0c ba???????? 51 8d4df4 }
            // n = 5, score = 300
            //   c7450c00000000       | mov                 dword ptr [ebp + 0xc], 0
            //   8d4d0c               | lea                 ecx, [ebp + 0xc]
            //   ba????????           |                     
            //   51                   | push                ecx
            //   8d4df4               | lea                 ecx, [ebp - 0xc]

        $sequence_7 = { b9???????? e8???????? 6a00 6a01 e8???????? 8bd0 b9???????? }
            // n = 7, score = 300
            //   b9????????           |                     
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   b9????????           |                     

        $sequence_8 = { 83c404 8bf8 33f6 0f1f4000 e8???????? 33d2 }
            // n = 6, score = 300
            //   83c404               | add                 esp, 4
            //   8bf8                 | mov                 edi, eax
            //   33f6                 | xor                 esi, esi
            //   0f1f4000             | nop                 dword ptr [eax]
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx

        $sequence_9 = { ff15???????? 83bdf8feffff00 764a ff15???????? 85c0 7540 8b85f8feffff }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   83bdf8feffff00       | cmp                 dword ptr [ebp - 0x108], 0
            //   764a                 | jbe                 0x4c
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7540                 | jne                 0x42
            //   8b85f8feffff         | mov                 eax, dword ptr [ebp - 0x108]

    condition:
        7 of them and filesize < 786432
}