rule win_domino_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.domino."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.domino"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 41b800300000 488bd6 33c9 4c8bf6 ff15???????? }
            // n = 5, score = 200
            //   41b800300000         | mov                 ecx, edi
            //   488bd6               | test                eax, eax
            //   33c9                 | jle                 0x2eb
            //   4c8bf6               | mov                 edx, eax
            //   ff15????????         |                     

        $sequence_1 = { 488bd1 b940000000 ff15???????? 448b442438 }
            // n = 4, score = 200
            //   488bd1               | mov                 eax, 0x8664
            //   b940000000           | dec                 ebp
            //   ff15????????         |                     
            //   448b442438           | mov                 esp, eax

        $sequence_2 = { 7509 488b5b08 483b1f 75e9 }
            // n = 4, score = 200
            //   7509                 | inc                 ebp
            //   488b5b08             | xor                 ecx, ecx
            //   483b1f               | dec                 eax
            //   75e9                 | lea                 eax, [esp + 0x50]

        $sequence_3 = { 488b4de7 ff15???????? 488b4def 33d2 ff15???????? 4c8d9c24a0000000 8bc3 }
            // n = 7, score = 200
            //   488b4de7             | dec                 eax
            //   ff15????????         |                     
            //   488b4def             | lea                 eax, [esp + 0x22]
            //   33d2                 | dec                 eax
            //   ff15????????         |                     
            //   4c8d9c24a0000000     | sub                 ebx, eax
            //   8bc3                 | dec                 eax

        $sequence_4 = { 488d942450010000 b904010000 ff15???????? 4c8d4c2440 }
            // n = 4, score = 200
            //   488d942450010000     | dec                 eax
            //   b904010000           | mov                 ecx, eax
            //   ff15????????         |                     
            //   4c8d4c2440           | dec                 eax

        $sequence_5 = { 7518 66c7030206 ff15???????? 894302 b806000000 e9???????? }
            // n = 6, score = 200
            //   7518                 | mov                 ecx, ebp
            //   66c7030206           | inc                 ecx
            //   ff15????????         |                     
            //   894302               | add                 esi, esp
            //   b806000000           | dec                 esp
            //   e9????????           |                     

        $sequence_6 = { 750f 66c7030101 b802000000 e9???????? 488d942450010000 b904010000 ff15???????? }
            // n = 7, score = 200
            //   750f                 | mov                 byte ptr [eax], 0
            //   66c7030101           | dec                 eax
            //   b802000000           | inc                 eax
            //   e9????????           |                     
            //   488d942450010000     | je                  0x186e
            //   b904010000           | dec                 eax
            //   ff15????????         |                     

        $sequence_7 = { ff15???????? 85c0 7434 488b4d7f }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   85c0                 | mov                 eax, 6
            //   7434                 | mov                 word ptr [ebx], 0x702
            //   488b4d7f             | jmp                 0x19e

        $sequence_8 = { ff15???????? 488bf0 4885c0 7513 66c7030203 ff15???????? }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   488bf0               | dec                 esp
            //   4885c0               | lea                 edx, [esp + 0x20]
            //   7513                 | inc                 esp
            //   66c7030203           | mov                 byte ptr [esp + eax + 0x20], al
            //   ff15????????         |                     

        $sequence_9 = { ff15???????? 488bcf 894302 ff15???????? }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   488bcf               | cmp                 word ptr [edi + 4], ax
            //   894302               | jne                 0x12c
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 50176
}