rule win_doppeldridex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.doppeldridex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.doppeldridex"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf0 33c0 48 8bfe 8bda 2bf8 2bd8 }
            // n = 7, score = 1200
            //   8bf0                 | mov                 esi, eax
            //   33c0                 | xor                 eax, eax
            //   48                   | dec                 eax
            //   8bfe                 | mov                 edi, esi
            //   8bda                 | mov                 ebx, edx
            //   2bf8                 | sub                 edi, eax
            //   2bd8                 | sub                 ebx, eax

        $sequence_1 = { e8???????? e9???????? 55 83ec68 33d2 42 }
            // n = 6, score = 1200
            //   e8????????           |                     
            //   e9????????           |                     
            //   55                   | push                ebp
            //   83ec68               | sub                 esp, 0x68
            //   33d2                 | xor                 edx, edx
            //   42                   | inc                 edx

        $sequence_2 = { 8b74243c 6a30 8b2f 56 8d4c2408 c6450000 e8???????? }
            // n = 7, score = 1200
            //   8b74243c             | mov                 esi, dword ptr [esp + 0x3c]
            //   6a30                 | push                0x30
            //   8b2f                 | mov                 ebp, dword ptr [edi]
            //   56                   | push                esi
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   c6450000             | mov                 byte ptr [ebp], 0
            //   e8????????           |                     

        $sequence_3 = { 6880000000 ffb4249c010000 ffb424b4010000 ffb42498000000 56 8d4c2428 8d91e0000000 }
            // n = 7, score = 1200
            //   6880000000           | push                0x80
            //   ffb4249c010000       | push                dword ptr [esp + 0x19c]
            //   ffb424b4010000       | push                dword ptr [esp + 0x1b4]
            //   ffb42498000000       | push                dword ptr [esp + 0x98]
            //   56                   | push                esi
            //   8d4c2428             | lea                 ecx, [esp + 0x28]
            //   8d91e0000000         | lea                 edx, [ecx + 0xe0]

        $sequence_4 = { 33c0 48 2bc8 2bd0 0bca 0f84b1000000 8d9424a4010000 }
            // n = 7, score = 1200
            //   33c0                 | xor                 eax, eax
            //   48                   | dec                 eax
            //   2bc8                 | sub                 ecx, eax
            //   2bd0                 | sub                 edx, eax
            //   0bca                 | or                  ecx, edx
            //   0f84b1000000         | je                  0xb7
            //   8d9424a4010000       | lea                 edx, [esp + 0x1a4]

        $sequence_5 = { 8b02 40 8902 83f80a 0f85fefdffff e9???????? c784249000000000000000 }
            // n = 7, score = 1200
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   40                   | inc                 eax
            //   8902                 | mov                 dword ptr [edx], eax
            //   83f80a               | cmp                 eax, 0xa
            //   0f85fefdffff         | jne                 0xfffffe04
            //   e9????????           |                     
            //   c784249000000000000000     | mov    dword ptr [esp + 0x90], 0

        $sequence_6 = { ff742410 50 6a00 52 ff742428 }
            // n = 5, score = 1200
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   52                   | push                edx
            //   ff742428             | push                dword ptr [esp + 0x28]

        $sequence_7 = { 2bf8 2bd8 0bfb 0f8443030000 8d942490000000 8b02 }
            // n = 6, score = 1200
            //   2bf8                 | sub                 edi, eax
            //   2bd8                 | sub                 ebx, eax
            //   0bfb                 | or                  edi, ebx
            //   0f8443030000         | je                  0x349
            //   8d942490000000       | lea                 edx, [esp + 0x90]
            //   8b02                 | mov                 eax, dword ptr [edx]

        $sequence_8 = { eb2b 31c0 8b4d88 83c104 }
            // n = 4, score = 100
            //   eb2b                 | jmp                 0x2d
            //   31c0                 | xor                 eax, eax
            //   8b4d88               | mov                 ecx, dword ptr [ebp - 0x78]
            //   83c104               | add                 ecx, 4

        $sequence_9 = { 0f92c4 8a6db3 20cd 20e5 f6c501 8955b4 7518 }
            // n = 7, score = 100
            //   0f92c4               | setb                ah
            //   8a6db3               | mov                 ch, byte ptr [ebp - 0x4d]
            //   20cd                 | and                 ch, cl
            //   20e5                 | and                 ch, ah
            //   f6c501               | test                ch, 1
            //   8955b4               | mov                 dword ptr [ebp - 0x4c], edx
            //   7518                 | jne                 0x1a

        $sequence_10 = { 8b458c 8944240c 8b55a4 ffd2 83ec10 }
            // n = 5, score = 100
            //   8b458c               | mov                 eax, dword ptr [ebp - 0x74]
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   8b55a4               | mov                 edx, dword ptr [ebp - 0x5c]
            //   ffd2                 | call                edx
            //   83ec10               | sub                 esp, 0x10

        $sequence_11 = { 894de4 e8???????? 83f800 8945e0 74c2 }
            // n = 5, score = 100
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   e8????????           |                     
            //   83f800               | cmp                 eax, 0
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   74c2                 | je                  0xffffffc4

        $sequence_12 = { e8???????? 31c0 8945e8 eb51 31c0 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   31c0                 | xor                 eax, eax
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   eb51                 | jmp                 0x53
            //   31c0                 | xor                 eax, eax

        $sequence_13 = { 01de 8b06 8bb550ffffff 8b5e08 8b4da8 01f9 890c24 }
            // n = 7, score = 100
            //   01de                 | add                 esi, ebx
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8bb550ffffff         | mov                 esi, dword ptr [ebp - 0xb0]
            //   8b5e08               | mov                 ebx, dword ptr [esi + 8]
            //   8b4da8               | mov                 ecx, dword ptr [ebp - 0x58]
            //   01f9                 | add                 ecx, edi
            //   890c24               | mov                 dword ptr [esp], ecx

        $sequence_14 = { 6683ff00 89d3 8945b8 8955d0 8975d4 895ddc }
            // n = 6, score = 100
            //   6683ff00             | cmp                 di, 0
            //   89d3                 | mov                 ebx, edx
            //   8945b8               | mov                 dword ptr [ebp - 0x48], eax
            //   8955d0               | mov                 dword ptr [ebp - 0x30], edx
            //   8975d4               | mov                 dword ptr [ebp - 0x2c], esi
            //   895ddc               | mov                 dword ptr [ebp - 0x24], ebx

        $sequence_15 = { 8b4df0 39c8 8945dc 72d2 ebb6 55 89e5 }
            // n = 7, score = 100
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   39c8                 | cmp                 eax, ecx
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   72d2                 | jb                  0xffffffd4
            //   ebb6                 | jmp                 0xffffffb8
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp

    condition:
        7 of them and filesize < 360448
}