rule win_doppelpaymer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.doppelpaymer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.doppelpaymer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7523 80790264 751d 80790561 }
            // n = 4, score = 700
            //   7523                 | jne                 0x25
            //   80790264             | cmp                 byte ptr [ecx + 2], 0x64
            //   751d                 | jne                 0x1f
            //   80790561             | cmp                 byte ptr [ecx + 5], 0x61

        $sequence_1 = { 751d 80790561 7517 80790361 7511 80790474 }
            // n = 6, score = 700
            //   751d                 | jne                 0x1f
            //   80790561             | cmp                 byte ptr [ecx + 5], 0x61
            //   7517                 | jne                 0x19
            //   80790361             | cmp                 byte ptr [ecx + 3], 0x61
            //   7511                 | jne                 0x13
            //   80790474             | cmp                 byte ptr [ecx + 4], 0x74

        $sequence_2 = { e8???????? 8b08 e8???????? 3db6389096 }
            // n = 4, score = 700
            //   e8????????           |                     
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   e8????????           |                     
            //   3db6389096           | cmp                 eax, 0x969038b6

        $sequence_3 = { 80790361 7511 80790474 750b 80790173 7505 80392e }
            // n = 7, score = 700
            //   80790361             | cmp                 byte ptr [ecx + 3], 0x61
            //   7511                 | jne                 0x13
            //   80790474             | cmp                 byte ptr [ecx + 4], 0x74
            //   750b                 | jne                 0xd
            //   80790173             | cmp                 byte ptr [ecx + 1], 0x73
            //   7505                 | jne                 7
            //   80392e               | cmp                 byte ptr [ecx], 0x2e

        $sequence_4 = { baffffff7f 43 e8???????? 3bd8 }
            // n = 4, score = 700
            //   baffffff7f           | mov                 edx, 0x7fffffff
            //   43                   | inc                 ebx
            //   e8????????           |                     
            //   3bd8                 | cmp                 ebx, eax

        $sequence_5 = { 83ec28 6800002002 6a00 6a01 }
            // n = 4, score = 700
            //   83ec28               | sub                 esp, 0x28
            //   6800002002           | push                0x2200000
            //   6a00                 | push                0
            //   6a01                 | push                1

        $sequence_6 = { 8d8c2478010000 e8???????? 8d8c246c010000 e8???????? 8d8c24dc010000 e8???????? 8d8c24cc010000 }
            // n = 7, score = 600
            //   8d8c2478010000       | lea                 ecx, [esp + 0x178]
            //   e8????????           |                     
            //   8d8c246c010000       | lea                 ecx, [esp + 0x16c]
            //   e8????????           |                     
            //   8d8c24dc010000       | lea                 ecx, [esp + 0x1dc]
            //   e8????????           |                     
            //   8d8c24cc010000       | lea                 ecx, [esp + 0x1cc]

        $sequence_7 = { e8???????? 85c0 740d 6a00 ff742440 ffd0 85c0 }
            // n = 7, score = 600
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   740d                 | je                  0xf
            //   6a00                 | push                0
            //   ff742440             | push                dword ptr [esp + 0x40]
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax

        $sequence_8 = { c20800 897de0 897de4 897de8 8d4900 }
            // n = 5, score = 100
            //   c20800               | ret                 8
            //   897de0               | mov                 dword ptr [ebp - 0x20], edi
            //   897de4               | mov                 dword ptr [ebp - 0x1c], edi
            //   897de8               | mov                 dword ptr [ebp - 0x18], edi
            //   8d4900               | lea                 ecx, [ecx]

        $sequence_9 = { 895ddc 0f84f0000000 e9???????? b801000000 b925155e0b }
            // n = 5, score = 100
            //   895ddc               | mov                 dword ptr [ebp - 0x24], ebx
            //   0f84f0000000         | je                  0xf6
            //   e9????????           |                     
            //   b801000000           | mov                 eax, 1
            //   b925155e0b           | mov                 ecx, 0xb5e1525

        $sequence_10 = { c20800 8b31 8955f8 8955fc }
            // n = 4, score = 100
            //   c20800               | ret                 8
            //   8b31                 | mov                 esi, dword ptr [ecx]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8955fc               | mov                 dword ptr [ebp - 4], edx

        $sequence_11 = { 8b4d0c 8b5508 83f800 8945f4 894df0 8955ec 7528 }
            // n = 7, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   83f800               | cmp                 eax, 0
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   7528                 | jne                 0x2a

        $sequence_12 = { 894de4 8955e0 897ddc 8975d8 }
            // n = 4, score = 100
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   8955e0               | mov                 dword ptr [ebp - 0x20], edx
            //   897ddc               | mov                 dword ptr [ebp - 0x24], edi
            //   8975d8               | mov                 dword ptr [ebp - 0x28], esi

        $sequence_13 = { 8945e8 eb0c a1???????? ffd0 8945e4 ebc9 8b45e8 }
            // n = 7, score = 100
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   eb0c                 | jmp                 0xe
            //   a1????????           |                     
            //   ffd0                 | call                eax
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   ebc9                 | jmp                 0xffffffcb
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

        $sequence_14 = { 8945e4 ebe3 b8c6ea1451 2b45ec 8b4dd8 81c1ffff0000 }
            // n = 6, score = 100
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   ebe3                 | jmp                 0xffffffe5
            //   b8c6ea1451           | mov                 eax, 0x5114eac6
            //   2b45ec               | sub                 eax, dword ptr [ebp - 0x14]
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]
            //   81c1ffff0000         | add                 ecx, 0xffff

        $sequence_15 = { 8b7e38 897dc8 8955cc 893424 c744240400000000 c744240858000000 }
            // n = 6, score = 100
            //   8b7e38               | mov                 edi, dword ptr [esi + 0x38]
            //   897dc8               | mov                 dword ptr [ebp - 0x38], edi
            //   8955cc               | mov                 dword ptr [ebp - 0x34], edx
            //   893424               | mov                 dword ptr [esp], esi
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   c744240858000000     | mov                 dword ptr [esp + 8], 0x58

        $sequence_16 = { 8b55d8 8bb2a0000000 8b7de4 01f7 89fb 83c304 8b55e4 }
            // n = 7, score = 100
            //   8b55d8               | mov                 edx, dword ptr [ebp - 0x28]
            //   8bb2a0000000         | mov                 esi, dword ptr [edx + 0xa0]
            //   8b7de4               | mov                 edi, dword ptr [ebp - 0x1c]
            //   01f7                 | add                 edi, esi
            //   89fb                 | mov                 ebx, edi
            //   83c304               | add                 ebx, 4
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]

        $sequence_17 = { 8b8578ffffff b909fcb97e 2b4df0 8b55a4 39ca }
            // n = 5, score = 100
            //   8b8578ffffff         | mov                 eax, dword ptr [ebp - 0x88]
            //   b909fcb97e           | mov                 ecx, 0x7eb9fc09
            //   2b4df0               | sub                 ecx, dword ptr [ebp - 0x10]
            //   8b55a4               | mov                 edx, dword ptr [ebp - 0x5c]
            //   39ca                 | cmp                 edx, ecx

    condition:
        7 of them and filesize < 7266304
}