rule win_dorkbot_ngrbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dorkbot_ngrbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dorkbot_ngrbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 740c 8b8cb51cffffff 51 ffd0 eb0d 8b94b51cffffff }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   740c                 | je                  0xe
            //   8b8cb51cffffff       | mov                 ecx, dword ptr [ebp + esi*4 - 0xe4]
            //   51                   | push                ecx
            //   ffd0                 | call                eax
            //   eb0d                 | jmp                 0xf
            //   8b94b51cffffff       | mov                 edx, dword ptr [ebp + esi*4 - 0xe4]

        $sequence_1 = { 85f6 0f84a8020000 6a00 6800040000 8d9578fbffff }
            // n = 5, score = 200
            //   85f6                 | test                esi, esi
            //   0f84a8020000         | je                  0x2ae
            //   6a00                 | push                0
            //   6800040000           | push                0x400
            //   8d9578fbffff         | lea                 edx, [ebp - 0x488]

        $sequence_2 = { ff15???????? 85c0 0f8c9f000000 8b4508 85c0 0f8494000000 8b4dfc }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8c9f000000         | jl                  0xa5
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   85c0                 | test                eax, eax
            //   0f8494000000         | je                  0x9a
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_3 = { e8???????? 8bf0 83c408 85f6 0f84dc000000 6a06 68???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c408               | add                 esp, 8
            //   85f6                 | test                esi, esi
            //   0f84dc000000         | je                  0xe2
            //   6a06                 | push                6
            //   68????????           |                     

        $sequence_4 = { 51 7416 68???????? 52 50 e8???????? 83c410 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   7416                 | je                  0x18
            //   68????????           |                     
            //   52                   | push                edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_5 = { 8b4d0c 51 50 6a00 ff15???????? 50 ff15???????? }
            // n = 7, score = 200
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_6 = { 8d85f1feffff 6a00 50 c685f0feffff00 e8???????? 8b4d14 83c40c }
            // n = 7, score = 200
            //   8d85f1feffff         | lea                 eax, [ebp - 0x10f]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   c685f0feffff00       | mov                 byte ptr [ebp - 0x110], 0
            //   e8????????           |                     
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]
            //   83c40c               | add                 esp, 0xc

        $sequence_7 = { 8d8500f8ffff 50 ff15???????? 8b550c 8b4508 8d8d00f8ffff 51 }
            // n = 7, score = 200
            //   8d8500f8ffff         | lea                 eax, [ebp - 0x800]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8d8d00f8ffff         | lea                 ecx, [ebp - 0x800]
            //   51                   | push                ecx

        $sequence_8 = { 8d55f0 52 68???????? e8???????? 83c40c 85c0 7530 }
            // n = 7, score = 200
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   52                   | push                edx
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   7530                 | jne                 0x32

        $sequence_9 = { b8???????? 5b 8be5 5d c3 ff15???????? 5e }
            // n = 7, score = 200
            //   b8????????           |                     
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   ff15????????         |                     
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 638976
}