rule win_doubleback_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.doubleback."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.doubleback"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b947060000 eb49 b9e7050000 eb42 b9e3050000 eb3b }
            // n = 6, score = 400
            //   b947060000           | dec                 eax
            //   eb49                 | mov                 dword ptr [eax + esi + 0x68], ecx
            //   b9e7050000           | dec                 eax
            //   eb42                 | shl                 eax, 5
            //   b9e3050000           | dec                 eax
            //   eb3b                 | mov                 dword ptr [eax + esi + 0x50], ecx

        $sequence_1 = { b947060000 eb49 b9e7050000 eb42 }
            // n = 4, score = 400
            //   b947060000           | add                 eax, 4
            //   eb49                 | dec                 eax
            //   b9e7050000           | add                 ecx, 4
            //   eb42                 | dec                 ebp

        $sequence_2 = { 3d00280000 7438 3d5a290000 742a 3d39380000 741c 3dd73a0000 }
            // n = 7, score = 400
            //   3d00280000           | push                0x128
            //   7438                 | lea                 eax, [esp + 0x1c]
            //   3d5a290000           | push                0x8000
            //   742a                 | push                0
            //   3d39380000           | push                edi
            //   741c                 | test                esi, esi
            //   3dd73a0000           | je                  0xa0f

        $sequence_3 = { b9d4070000 eb13 b975070000 eb0c b96f070000 eb05 }
            // n = 6, score = 400
            //   b9d4070000           | mov                 eax, edi
            //   eb13                 | and                 eax, 3
            //   b975070000           | mov                 dword ptr [ebx + 4], ecx
            //   eb0c                 | dec                 eax
            //   b96f070000           | shl                 edx, 3
            //   eb05                 | dec                 eax

        $sequence_4 = { e8???????? 85c0 7508 c60703 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   85c0                 | mov                 dword ptr [edx], eax
            //   7508                 | lea                 edx, [edx + 4]
            //   c60703               | sub                 ecx, 1

        $sequence_5 = { b9e3050000 eb3b b90b070000 eb34 2d63450000 7428 }
            // n = 6, score = 400
            //   b9e3050000           | shr                 edx, 3
            //   eb3b                 | test                edx, edx
            //   b90b070000           | je                  0x1f5e
            //   eb34                 | lea                 eax, [edi + 1]
            //   2d63450000           | mov                 ecx, edx
            //   7428                 | dec                 eax

        $sequence_6 = { eb49 b9e7050000 eb42 b9e3050000 eb3b b90b070000 eb34 }
            // n = 7, score = 400
            //   eb49                 | inc                 ecx
            //   b9e7050000           | mov                 eax, 0x8000
            //   eb42                 | dec                 eax
            //   b9e3050000           | mov                 ecx, esi
            //   eb3b                 | dec                 eax
            //   b90b070000           | mov                 ecx, dword ptr [ebx]
            //   eb34                 | inc                 ebp

        $sequence_7 = { b975070000 eb0c b96f070000 eb05 }
            // n = 4, score = 400
            //   b975070000           | cmp                 edx, 0x20
            //   eb0c                 | jl                  0xfa3
            //   b96f070000           | jmp                 0xfbe
            //   eb05                 | add                 eax, 8

        $sequence_8 = { b9d4070000 eb13 b975070000 eb0c b96f070000 }
            // n = 5, score = 400
            //   b9d4070000           | pop                 ecx
            //   eb13                 | mov                 word ptr [esi + 0xe], ax
            //   b975070000           | push                ebx
            //   eb0c                 | push                0x14
            //   b96f070000           | pop                 ecx

        $sequence_9 = { 751a b9d4070000 eb13 b975070000 }
            // n = 4, score = 400
            //   751a                 | movzx               eax, word ptr [ebx + 0x234]
            //   b9d4070000           | dec                 esp
            //   eb13                 | lea                 edx, [esi + 0x1f8]
            //   b975070000           | dec                 esp

    condition:
        7 of them and filesize < 106496
}