rule win_doublefinger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.doublefinger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.doublefinger"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c644247d64 c644247e79 c644247f97 488d942410030000 488d4c2478 e8???????? }
            // n = 6, score = 100
            //   c644247d64           | dec                 esp
            //   c644247e79           | lea                 ecx, [esp + 0x110]
            //   c644247f97           | inc                 ebp
            //   488d942410030000     | xor                 eax, eax
            //   488d4c2478           | dec                 eax
            //   e8????????           |                     

        $sequence_1 = { 8b442448 39442444 7d27 41b87a000000 ba61000000 488b8c2468010000 e8???????? }
            // n = 7, score = 100
            //   8b442448             | dec                 eax
            //   39442444             | cmp                 dword ptr [esp + 0x48], 0
            //   7d27                 | je                  0x1679
            //   41b87a000000         | dec                 eax
            //   ba61000000           | mov                 ecx, dword ptr [esp + 0x48]
            //   488b8c2468010000     | dec                 eax
            //   e8????????           |                     

        $sequence_2 = { 4533c0 8b942464010000 488b4c2450 e8???????? }
            // n = 4, score = 100
            //   4533c0               | inc                 ebp
            //   8b942464010000       | xor                 eax, eax
            //   488b4c2450           | dec                 eax
            //   e8????????           |                     

        $sequence_3 = { c6440478af ba0a020000 b940000000 488b842468010000 ff5038 }
            // n = 5, score = 100
            //   c6440478af           | test                eax, eax
            //   ba0a020000           | je                  0x1083
            //   b940000000           | dec                 eax
            //   488b842468010000     | lea                 eax, [ecx - 1]
            //   ff5038               | dec                 eax

        $sequence_4 = { e8???????? ba0a020000 488d8c2460010000 e8???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   ba0a020000           | dec                 eax
            //   488d8c2460010000     | mov                 eax, dword ptr [esp + 0x40]
            //   e8????????           |                     

        $sequence_5 = { 39442408 0f8394000000 c6042400 c744240400000000 eb0a 8b442404 }
            // n = 6, score = 100
            //   39442408             | jne                 0x152b
            //   0f8394000000         | jmp                 0x1582
            //   c6042400             | jne                 0x1530
            //   c744240400000000     | dec                 eax
            //   eb0a                 | lea                 ecx, [0x74e]
            //   8b442404             | xor                 eax, eax

        $sequence_6 = { 488bc1 eb7a 837c242000 7471 }
            // n = 4, score = 100
            //   488bc1               | mov                 dword ptr [esp + 0x1d0], eax
            //   eb7a                 | dec                 eax
            //   837c242000           | mov                 eax, dword ptr [esp + 0x1a8]
            //   7471                 | dec                 eax

        $sequence_7 = { ba0a020000 b940000000 488b442470 ff5038 }
            // n = 4, score = 100
            //   ba0a020000           | mov                 eax, dword ptr [esp + 0x70]
            //   b940000000           | dec                 eax
            //   488b442470           | mov                 edx, dword ptr [esp + 0x40]
            //   ff5038               | mov                 cx, 2

        $sequence_8 = { 3565708005 8984246c010000 8b84246c010000 8b4c2460 33c8 }
            // n = 5, score = 100
            //   3565708005           | mov                 eax, dword ptr [esp + 0x2c]
            //   8984246c010000       | mov                 dword ptr [esp + 0x24], eax
            //   8b84246c010000       | mov                 eax, dword ptr [esp + 0x24]
            //   8b4c2460             | dec                 eax
            //   33c8                 | mov                 ecx, dword ptr [esp + 0x60]

        $sequence_9 = { 66898424fc000000 33c0 66898424fe000000 ba64000000 }
            // n = 4, score = 100
            //   66898424fc000000     | mov                 eax, dword ptr [esp + 0x40]
            //   33c0                 | dec                 eax
            //   66898424fe000000     | shl                 eax, 1
            //   ba64000000           | dec                 eax

    condition:
        7 of them and filesize < 115712
}