rule win_doublepulsar_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.doublepulsar."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.doublepulsar"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 668b00 c3 81e2ffff0000 c1e202 01d1 8b09 01c8 }
            // n = 7, score = 100
            //   668b00               | mov                 ax, word ptr [eax]
            //   c3                   | ret                 
            //   81e2ffff0000         | and                 edx, 0xffff
            //   c1e202               | shl                 edx, 2
            //   01d1                 | add                 ecx, edx
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   01c8                 | add                 eax, ecx

        $sequence_1 = { 6852445000 ff75fc 6a01 ff13 }
            // n = 4, score = 100
            //   6852445000           | push                0x504452
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   6a01                 | push                1
            //   ff13                 | call                dword ptr [ebx]

        $sequence_2 = { 894530 8b4620 8b7d65 83c703 8907 8b4628 a902000000 }
            // n = 7, score = 100
            //   894530               | mov                 dword ptr [ebp + 0x30], eax
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   8b7d65               | mov                 edi, dword ptr [ebp + 0x65]
            //   83c703               | add                 edi, 3
            //   8907                 | mov                 dword ptr [edi], eax
            //   8b4628               | mov                 eax, dword ptr [esi + 0x28]
            //   a902000000           | test                eax, 2

        $sequence_3 = { ff500c 85c0 748c 33c0 5f 5e 5b }
            // n = 7, score = 100
            //   ff500c               | call                dword ptr [eax + 0xc]
            //   85c0                 | test                eax, eax
            //   748c                 | je                  0xffffff8e
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_4 = { 8b8c003cb54000 03c0 894e5c 8b9040b54000 895660 8b8844b54000 894e64 }
            // n = 7, score = 100
            //   8b8c003cb54000       | mov                 ecx, dword ptr [eax + eax + 0x40b53c]
            //   03c0                 | add                 eax, eax
            //   894e5c               | mov                 dword ptr [esi + 0x5c], ecx
            //   8b9040b54000         | mov                 edx, dword ptr [eax + 0x40b540]
            //   895660               | mov                 dword ptr [esi + 0x60], edx
            //   8b8844b54000         | mov                 ecx, dword ptr [eax + 0x40b544]
            //   894e64               | mov                 dword ptr [esi + 0x64], ecx

        $sequence_5 = { 85c0 7463 8b442444 6a0e 53 50 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7463                 | je                  0x65
            //   8b442444             | mov                 eax, dword ptr [esp + 0x44]
            //   6a0e                 | push                0xe
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_6 = { 88c8 c1e908 00c8 c1e908 00c8 c1e908 00c8 }
            // n = 7, score = 100
            //   88c8                 | mov                 al, cl
            //   c1e908               | shr                 ecx, 8
            //   00c8                 | add                 al, cl
            //   c1e908               | shr                 ecx, 8
            //   00c8                 | add                 al, cl
            //   c1e908               | shr                 ecx, 8
            //   00c8                 | add                 al, cl

        $sequence_7 = { 03d8 2be8 85ed 75ac }
            // n = 4, score = 100
            //   03d8                 | add                 ebx, eax
            //   2be8                 | sub                 ebp, eax
            //   85ed                 | test                ebp, ebp
            //   75ac                 | jne                 0xffffffae

        $sequence_8 = { e8???????? a1???????? 33c4 898424a0100000 55 56 8bb424b0100000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   898424a0100000       | mov                 dword ptr [esp + 0x10a0], eax
            //   55                   | push                ebp
            //   56                   | push                esi
            //   8bb424b0100000       | mov                 esi, dword ptr [esp + 0x10b0]

        $sequence_9 = { 0f85f4000000 41 83f813 0f8287010000 8b4a0b 41 8bc0 }
            // n = 7, score = 100
            //   0f85f4000000         | jne                 0xfa
            //   41                   | inc                 ecx
            //   83f813               | cmp                 eax, 0x13
            //   0f8287010000         | jb                  0x18d
            //   8b4a0b               | mov                 ecx, dword ptr [edx + 0xb]
            //   41                   | inc                 ecx
            //   8bc0                 | mov                 eax, eax

    condition:
        7 of them and filesize < 122880
}