rule win_downdelph_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.downdelph."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.downdelph"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b0d???????? ba???????? e8???????? 8b55d4 8d45d8 }
            // n = 5, score = 100
            //   8b0d????????         |                     
            //   ba????????           |                     
            //   e8????????           |                     
            //   8b55d4               | mov                 edx, dword ptr [ebp - 0x2c]
            //   8d45d8               | lea                 eax, [ebp - 0x28]

        $sequence_1 = { 8d45f0 e8???????? 8d45e4 33c9 ba08000000 e8???????? 8b45f4 }
            // n = 7, score = 100
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   e8????????           |                     
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   33c9                 | xor                 ecx, ecx
            //   ba08000000           | mov                 edx, 8
            //   e8????????           |                     
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_2 = { 8d45f4 ba02000000 e8???????? 8d45fc 8b15???????? }
            // n = 5, score = 100
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   ba02000000           | mov                 edx, 2
            //   e8????????           |                     
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   8b15????????         |                     

        $sequence_3 = { 7c66 46 33db 8d45c0 }
            // n = 4, score = 100
            //   7c66                 | jl                  0x68
            //   46                   | inc                 esi
            //   33db                 | xor                 ebx, ebx
            //   8d45c0               | lea                 eax, [ebp - 0x40]

        $sequence_4 = { 8b14b0 8d45e0 b9???????? e8???????? 8b55e0 8d45e4 e8???????? }
            // n = 7, score = 100
            //   8b14b0               | mov                 edx, dword ptr [eax + esi*4]
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   b9????????           |                     
            //   e8????????           |                     
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   e8????????           |                     

        $sequence_5 = { 8d45f8 e8???????? 8b55f8 8d45fc 8b4dfc e8???????? 8bc3 }
            // n = 7, score = 100
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   e8????????           |                     
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8bc3                 | mov                 eax, ebx

        $sequence_6 = { 7409 8b12 50 e8???????? 58 83e808 e8???????? }
            // n = 7, score = 100
            //   7409                 | je                  0xb
            //   8b12                 | mov                 edx, dword ptr [edx]
            //   50                   | push                eax
            //   e8????????           |                     
            //   58                   | pop                 eax
            //   83e808               | sub                 eax, 8
            //   e8????????           |                     

        $sequence_7 = { 33c9 ba04010000 e8???????? 8d45f8 }
            // n = 4, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   ba04010000           | mov                 edx, 0x104
            //   e8????????           |                     
            //   8d45f8               | lea                 eax, [ebp - 8]

        $sequence_8 = { 81ce00ffffff 46 0fb68c35bcfeffff 884df7 889435bcfeffff }
            // n = 5, score = 100
            //   81ce00ffffff         | or                  esi, 0xffffff00
            //   46                   | inc                 esi
            //   0fb68c35bcfeffff     | movzx               ecx, byte ptr [ebp + esi - 0x144]
            //   884df7               | mov                 byte ptr [ebp - 9], cl
            //   889435bcfeffff       | mov                 byte ptr [ebp + esi - 0x144], dl

        $sequence_9 = { 8d45e4 ba03000000 e8???????? 8b55e4 8d45fc }
            // n = 5, score = 100
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   ba03000000           | mov                 edx, 3
            //   e8????????           |                     
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   8d45fc               | lea                 eax, [ebp - 4]

    condition:
        7 of them and filesize < 172032
}