rule win_downeks_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.downeks."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.downeks"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bec 817d08c8000000 53 56 8bf0 8b9e38040000 57 }
            // n = 7, score = 200
            //   8bec                 | mov                 ebp, esp
            //   817d08c8000000       | cmp                 dword ptr [ebp + 8], 0xc8
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8bf0                 | mov                 esi, eax
            //   8b9e38040000         | mov                 ebx, dword ptr [esi + 0x438]
            //   57                   | push                edi

        $sequence_1 = { c3 b8042c0804 5d c3 b8ec250804 5d c3 }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   b8042c0804           | mov                 eax, 0x4082c04
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   b8ec250804           | mov                 eax, 0x40825ec
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_2 = { c20c00 8bc1 ddd8 894dd8 81e1ffffff7f 8955cc 894dd0 }
            // n = 7, score = 200
            //   c20c00               | ret                 0xc
            //   8bc1                 | mov                 eax, ecx
            //   ddd8                 | fstp                st(0)
            //   894dd8               | mov                 dword ptr [ebp - 0x28], ecx
            //   81e1ffffff7f         | and                 ecx, 0x7fffffff
            //   8955cc               | mov                 dword ptr [ebp - 0x34], edx
            //   894dd0               | mov                 dword ptr [ebp - 0x30], ecx

        $sequence_3 = { 8b7d08 8bc7 c1f805 8bf7 83e61f c1e606 033485e0ffb405 }
            // n = 7, score = 200
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8bc7                 | mov                 eax, edi
            //   c1f805               | sar                 eax, 5
            //   8bf7                 | mov                 esi, edi
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   033485e0ffb405       | add                 esi, dword ptr [eax*4 + 0x5b4ffe0]

        $sequence_4 = { 8bbd48ffffff 039d68ffffff c1ef03 33f7 03f3 03b544ffffff 897584 }
            // n = 7, score = 200
            //   8bbd48ffffff         | mov                 edi, dword ptr [ebp - 0xb8]
            //   039d68ffffff         | add                 ebx, dword ptr [ebp - 0x98]
            //   c1ef03               | shr                 edi, 3
            //   33f7                 | xor                 esi, edi
            //   03f3                 | add                 esi, ebx
            //   03b544ffffff         | add                 esi, dword ptr [ebp - 0xbc]
            //   897584               | mov                 dword ptr [ebp - 0x7c], esi

        $sequence_5 = { b820000000 8bce e8???????? 33c0 5f 5e 5b }
            // n = 7, score = 200
            //   b820000000           | mov                 eax, 0x20
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_6 = { 8d5df0 8b5508 893a 393b 0f8598000000 56 e8???????? }
            // n = 7, score = 200
            //   8d5df0               | lea                 ebx, [ebp - 0x10]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   893a                 | mov                 dword ptr [edx], edi
            //   393b                 | cmp                 dword ptr [ebx], edi
            //   0f8598000000         | jne                 0x9e
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_7 = { c746140f000000 c7461000000000 6839ac0804 8bce c60600 e8???????? eb7a }
            // n = 7, score = 200
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   6839ac0804           | push                0x408ac39
            //   8bce                 | mov                 ecx, esi
            //   c60600               | mov                 byte ptr [esi], 0
            //   e8????????           |                     
            //   eb7a                 | jmp                 0x7c

        $sequence_8 = { c78550ffffff01000000 89b7a0040000 394d98 7c12 7f08 8b5594 3b558c }
            // n = 7, score = 200
            //   c78550ffffff01000000     | mov    dword ptr [ebp - 0xb0], 1
            //   89b7a0040000         | mov                 dword ptr [edi + 0x4a0], esi
            //   394d98               | cmp                 dword ptr [ebp - 0x68], ecx
            //   7c12                 | jl                  0x14
            //   7f08                 | jg                  0xa
            //   8b5594               | mov                 edx, dword ptr [ebp - 0x6c]
            //   3b558c               | cmp                 edx, dword ptr [ebp - 0x74]

        $sequence_9 = { 6a3f 85c0 7403 40 eb09 8b55e8 8b8298000000 }
            // n = 7, score = 200
            //   6a3f                 | push                0x3f
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   40                   | inc                 eax
            //   eb09                 | jmp                 0xb
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   8b8298000000         | mov                 eax, dword ptr [edx + 0x98]

    condition:
        7 of them and filesize < 1318912
}