rule win_dreambot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dreambot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dreambot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4f30 83e140 0b4b18 83671800 }
            // n = 4, score = 700
            //   8b4f30               | mov                 ecx, dword ptr [edi + 0x30]
            //   83e140               | and                 ecx, 0x40
            //   0b4b18               | or                  ecx, dword ptr [ebx + 0x18]
            //   83671800             | and                 dword ptr [edi + 0x18], 0

        $sequence_1 = { 85c0 751f ff15???????? 8bf8 81ffe5030000 751a }
            // n = 6, score = 700
            //   85c0                 | test                eax, eax
            //   751f                 | jne                 0x21
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   81ffe5030000         | cmp                 edi, 0x3e5
            //   751a                 | jne                 0x1c

        $sequence_2 = { ff7320 ff15???????? 50 ff7320 56 ff5710 }
            // n = 6, score = 700
            //   ff7320               | push                dword ptr [ebx + 0x20]
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff7320               | push                dword ptr [ebx + 0x20]
            //   56                   | push                esi
            //   ff5710               | call                dword ptr [edi + 0x10]

        $sequence_3 = { ff15???????? 85c0 7410 ff742410 33ff e8???????? 8b7d0c }
            // n = 7, score = 700
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7410                 | je                  0x12
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   33ff                 | xor                 edi, edi
            //   e8????????           |                     
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]

        $sequence_4 = { ffd6 8b44240c 894320 68???????? ff7320 ff15???????? }
            // n = 6, score = 700
            //   ffd6                 | call                esi
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   894320               | mov                 dword ptr [ebx + 0x20], eax
            //   68????????           |                     
            //   ff7320               | push                dword ptr [ebx + 0x20]
            //   ff15????????         |                     

        $sequence_5 = { 751a 395d10 7413 8b4618 e8???????? eb09 }
            // n = 6, score = 700
            //   751a                 | jne                 0x1c
            //   395d10               | cmp                 dword ptr [ebp + 0x10], ebx
            //   7413                 | je                  0x15
            //   8b4618               | mov                 eax, dword ptr [esi + 0x18]
            //   e8????????           |                     
            //   eb09                 | jmp                 0xb

        $sequence_6 = { 68???????? 68???????? ff7320 e8???????? 8bf8 }
            // n = 5, score = 700
            //   68????????           |                     
            //   68????????           |                     
            //   ff7320               | push                dword ptr [ebx + 0x20]
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_7 = { 0f84cd000000 8d442410 50 8d442410 }
            // n = 4, score = 700
            //   0f84cd000000         | je                  0xd3
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   50                   | push                eax
            //   8d442410             | lea                 eax, [esp + 0x10]

        $sequence_8 = { 3bf3 0f8481000000 395d0c 747c 6a03 ebcc 3bf3 }
            // n = 7, score = 600
            //   3bf3                 | mov                 edi, dword ptr [ebp + 8]
            //   0f8481000000         | jmp                 0x29
            //   395d0c               | test                eax, eax
            //   747c                 | jne                 0x24
            //   6a03                 | cmp                 esi, ebx
            //   ebcc                 | je                  0x20
            //   3bf3                 | cmp                 dword ptr [ebp + 0xc], 4

        $sequence_9 = { 3bc2 480f45ca 488bc1 4883c438 c3 488bc4 }
            // n = 6, score = 600
            //   3bc2                 | dec                 eax
            //   480f45ca             | add                 esp, 0x38
            //   488bc1               | ret                 
            //   4883c438             | dec                 eax
            //   c3                   | mov                 eax, esp
            //   488bc4               | dec                 eax

        $sequence_10 = { 395d0c 0f848d000000 6a07 ebdd 3bf3 0f8481000000 }
            // n = 6, score = 600
            //   395d0c               | dec                 ecx
            //   0f848d000000         | cmp                 edi, ebp
            //   6a07                 | je                  0xbb
            //   ebdd                 | inc                 ecx
            //   3bf3                 | cmp                 esi, ebp
            //   0f8481000000         | je                  0xbb

        $sequence_11 = { a1???????? 85c0 7520 3bf3 741c 837d0c04 }
            // n = 6, score = 600
            //   a1????????           |                     
            //   85c0                 | je                  0x7e
            //   7520                 | inc                 ecx
            //   3bf3                 | mov                 eax, 0xd
            //   741c                 | jmp                 0xffffffaf
            //   837d0c04             | xor                 edx, edx

        $sequence_12 = { 837d0c04 7516 ff7510 ff36 68???????? e8???????? 8bf8 }
            // n = 7, score = 600
            //   837d0c04             | mov                 ebp, esp
            //   7516                 | sub                 esp, 0x14
            //   ff7510               | mov                 eax, dword ptr [esi + 0x18]
            //   ff36                 | push                ebx
            //   68????????           |                     
            //   e8????????           |                     
            //   8bf8                 | xor                 ebx, ebx

        $sequence_13 = { ebcc 3bf3 7474 395d0c 746f 6a0d ebbf }
            // n = 7, score = 600
            //   ebcc                 | push                0xd
            //   3bf3                 | jmp                 0xffffffc1
            //   7474                 | push                dword ptr [ebp + 0x10]
            //   395d0c               | push                ebx
            //   746f                 | jmp                 0x5c
            //   6a0d                 | push                esi
            //   ebbf                 | mov                 dword ptr [ebp + 8], eax

        $sequence_14 = { 746f 6a0d ebbf ff7510 53 68???????? eb54 }
            // n = 7, score = 600
            //   746f                 | je                  0x1c
            //   6a0d                 | jmp                 0x2e
            //   ebbf                 | inc                 ecx
            //   ff7510               | cmp                 eax, ebp
            //   53                   | dec                 ecx
            //   68????????           |                     
            //   eb54                 | cmp                 edi, ebp

        $sequence_15 = { 8b7d08 eb24 a1???????? 85c0 }
            // n = 4, score = 600
            //   8b7d08               | dec                 ecx
            //   eb24                 | cmp                 edi, ebp
            //   a1????????           |                     
            //   85c0                 | je                  0xbb

        $sequence_16 = { 56 68???????? e8???????? 894508 8b7d08 eb24 }
            // n = 6, score = 600
            //   56                   | je                  0xbb
            //   68????????           |                     
            //   e8????????           |                     
            //   894508               | inc                 ecx
            //   8b7d08               | cmp                 esi, ebp
            //   eb24                 | je                  0xbb

        $sequence_17 = { 413bc5 7528 493bfd 7423 41b904000000 }
            // n = 5, score = 500
            //   413bc5               | add                 esp, 0x38
            //   7528                 | ret                 
            //   493bfd               | dec                 eax
            //   7423                 | mov                 eax, esp
            //   41b904000000         | dec                 eax

        $sequence_18 = { c3 4053 4883ec20 4c8b4108 488bd9 }
            // n = 5, score = 500
            //   c3                   | push                0
            //   4053                 | pop                 ebx
            //   4883ec20             | mov                 esp, ebp
            //   4c8b4108             | pop                 ebp
            //   488bd9               | ret                 4

        $sequence_19 = { e8???????? e9???????? 493bfd 0f84b5000000 413bf5 0f84ac000000 }
            // n = 6, score = 500
            //   e8????????           |                     
            //   e9????????           |                     
            //   493bfd               | add                 esp, 0x38
            //   0f84b5000000         | ret                 
            //   413bf5               | dec                 eax
            //   0f84ac000000         | mov                 eax, esp

        $sequence_20 = { 4c8bc5 e8???????? 8bd8 83fbff 7508 }
            // n = 5, score = 500
            //   4c8bc5               | cmp                 dword ptr [ebp + 0xc], 4
            //   e8????????           |                     
            //   8bd8                 | jne                 0x1c
            //   83fbff               | push                dword ptr [ebp + 0x10]
            //   7508                 | push                dword ptr [esi]

        $sequence_21 = { bb57000000 e8???????? 413bc5 7446 }
            // n = 4, score = 500
            //   bb57000000           | mov                 dword ptr [eax + 8], ebx
            //   e8????????           |                     
            //   413bc5               | xor                 edx, edx
            //   7446                 | cmp                 eax, edx

        $sequence_22 = { 7464 413bf5 745f 8bd6 488bcf bb57000000 }
            // n = 6, score = 500
            //   7464                 | dec                 eax
            //   413bf5               | cmovne              ecx, edx
            //   745f                 | dec                 eax
            //   8bd6                 | mov                 eax, ecx
            //   488bcf               | dec                 eax
            //   bb57000000           | add                 esp, 0x38

        $sequence_23 = { 33d2 ff15???????? 4c8d5c2470 8bc7 }
            // n = 4, score = 500
            //   33d2                 | mov                 dword ptr [ebp - 8], eax
            //   ff15????????         |                     
            //   4c8d5c2470           | xor                 edi, edi
            //   8bc7                 | push                dword ptr [ebp - 8]

        $sequence_24 = { 747c 41b80d000000 eba7 33d2 }
            // n = 4, score = 500
            //   747c                 | dec                 eax
            //   41b80d000000         | mov                 dword ptr [eax + 8], ebx
            //   eba7                 | inc                 ecx
            //   33d2                 | cmp                 eax, ebp

        $sequence_25 = { e8???????? eb2c 8b05???????? 413bc5 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   eb2c                 | mov                 eax, ecx
            //   8b05????????         |                     
            //   413bc5               | dec                 eax

        $sequence_26 = { e9???????? 8bd6 488bcf e8???????? e9???????? 4c392d???????? 740c }
            // n = 7, score = 500
            //   e9????????           |                     
            //   8bd6                 | dec                 eax
            //   488bcf               | cmovne              ecx, edx
            //   e8????????           |                     
            //   e9????????           |                     
            //   4c392d????????       |                     
            //   740c                 | dec                 eax

        $sequence_27 = { 46 8945f8 85c0 7551 }
            // n = 4, score = 400
            //   46                   | jmp                 0x18
            //   8945f8               | test                eax, eax
            //   85c0                 | je                  0x41
            //   7551                 | mov                 dx, 0x2e

        $sequence_28 = { 8b450c 33db 895dfc e8???????? 8945f8 33ff }
            // n = 6, score = 400
            //   8b450c               | dec                 eax
            //   33db                 | mov                 dword ptr [eax + 8], ebx
            //   895dfc               | dec                 eax
            //   e8????????           |                     
            //   8945f8               | mov                 eax, ecx
            //   33ff                 | dec                 eax

        $sequence_29 = { 817424105085b8ed 33ff 47 57 be???????? 56 8d542418 }
            // n = 7, score = 400
            //   817424105085b8ed     | dec                 eax
            //   33ff                 | mov                 eax, ecx
            //   47                   | dec                 eax
            //   57                   | add                 esp, 0x38
            //   be????????           |                     
            //   56                   | ret                 
            //   8d542418             | dec                 eax

        $sequence_30 = { e8???????? 4885db 7417 488b0d???????? 4c8bc3 33d2 }
            // n = 6, score = 400
            //   e8????????           |                     
            //   4885db               | lea                 eax, [ebp - 0xc]
            //   7417                 | push                eax
            //   488b0d????????       |                     
            //   4c8bc3               | mov                 eax, dword ptr [ebp + 0xc]
            //   33d2                 | mov                 esp, ebp

        $sequence_31 = { ff7310 ff15???????? 33d2 89b7184a0000 }
            // n = 4, score = 400
            //   ff7310               | add                 edi, 0x120
            //   ff15????????         |                     
            //   33d2                 | inc                 ecx
            //   89b7184a0000         | add                 ebp, 1

        $sequence_32 = { 488bcb e8???????? f7d0 eb07 8b8424c8000000 3dcad2b74e }
            // n = 6, score = 400
            //   488bcb               | imul                esi, esi, 0x19660d
            //   e8????????           |                     
            //   f7d0                 | shl                 eax, 0x10
            //   eb07                 | push                esi
            //   8b8424c8000000       | lea                 esi, [eax + ecx - 0x124676d0]
            //   3dcad2b74e           | push                edi

        $sequence_33 = { 8db4083089b9ed 57 8d45f4 50 8b450c 33db 895dfc }
            // n = 7, score = 400
            //   8db4083089b9ed       | cmovne              ecx, edx
            //   57                   | dec                 eax
            //   8d45f4               | mov                 eax, ecx
            //   50                   | dec                 eax
            //   8b450c               | add                 esp, 0x38
            //   33db                 | ret                 
            //   895dfc               | dec                 eax

        $sequence_34 = { 8945f8 33ff eb03 8b750c ff75f8 69f60d661900 }
            // n = 6, score = 400
            //   8945f8               | je                  0xdf
            //   33ff                 | inc                 ecx
            //   eb03                 | cmp                 esi, ebp
            //   8b750c               | xor                 edx, edx
            //   ff75f8               | cmp                 eax, edx
            //   69f60d661900         | dec                 eax

        $sequence_35 = { 85c0 7551 ff33 50 }
            // n = 4, score = 400
            //   85c0                 | dec                 eax
            //   7551                 | test                eax, eax
            //   ff33                 | test                eax, eax
            //   50                   | je                  0x41

        $sequence_36 = { 7427 488b5308 488bc8 ff15???????? 4c8b472c 488b0d???????? }
            // n = 6, score = 400
            //   7427                 | ret                 4
            //   488b5308             | pop                 ebp
            //   488bc8               | ret                 4
            //   ff15????????         |                     
            //   4c8b472c             | push                0
            //   488b0d????????       |                     

        $sequence_37 = { 8b463c 488b1e 2b471c 4489742478 448974247c 488b542478 }
            // n = 6, score = 400
            //   8b463c               | dec                 eax
            //   488b1e               | mov                 eax, ecx
            //   2b471c               | dec                 eax
            //   4489742478           | add                 esp, 0x38
            //   448974247c           | ret                 
            //   488b542478           | dec                 eax

        $sequence_38 = { 8b87184a0000 56 33f6 46 8945f8 }
            // n = 5, score = 400
            //   8b87184a0000         | cmp                 ebp, dword ptr [esi]
            //   56                   | jae                 0xf
            //   33f6                 | jmp                 0xffffffb0
            //   46                   | test                eax, eax
            //   8945f8               | je                  0x14

        $sequence_39 = { 8b424c a801 0f840f010000 8b424c a806 740e e8???????? }
            // n = 7, score = 400
            //   8b424c               | mov                 esp, ebp
            //   a801                 | pop                 ebp
            //   0f840f010000         | ret                 4
            //   8b424c               | push                0
            //   a806                 | mov                 esp, ebp
            //   740e                 | pop                 ebp
            //   e8????????           |                     

        $sequence_40 = { 8a07 2c41 3c05 8a07 7704 2c37 eb0a }
            // n = 7, score = 400
            //   8a07                 | mov                 eax, dword ptr [eax + 4]
            //   2c41                 | test                eax, eax
            //   3c05                 | je                  0xb
            //   8a07                 | jne                 0xf
            //   7704                 | cmp                 eax, edx
            //   2c37                 | dec                 eax
            //   eb0a                 | cmovne              ecx, edx

        $sequence_41 = { 89442440 488bf9 e8???????? 488d542438 33c9 ff15???????? 448b5c2438 }
            // n = 7, score = 400
            //   89442440             | push                dword ptr [esp + 0x10]
            //   488bf9               | mov                 esp, ebp
            //   e8????????           |                     
            //   488d542438           | pop                 ebp
            //   33c9                 | ret                 4
            //   ff15????????         |                     
            //   448b5c2438           | push                0

        $sequence_42 = { 488bf0 0f84a3000000 8b942490000000 4c8b442440 }
            // n = 4, score = 400
            //   488bf0               | xor                 edi, edi
            //   0f84a3000000         | jmp                 5
            //   8b942490000000       | mov                 esi, dword ptr [ebp + 0xc]
            //   4c8b442440           | push                dword ptr [ebp - 8]

        $sequence_43 = { 33d2 ff15???????? 8bc6 488b9c24c0000000 }
            // n = 4, score = 400
            //   33d2                 | lea                 eax, [ebp - 0xc]
            //   ff15????????         |                     
            //   8bc6                 | push                eax
            //   488b9c24c0000000     | push                dword ptr [ebp - 8]

        $sequence_44 = { ff15???????? 8945fc 85c0 741a 6804010000 8d4f10 51 }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   8945fc               | jmp                 0xffffffad
            //   85c0                 | inc                 ebp
            //   741a                 | xor                 esi, esi
            //   6804010000           | jmp                 0x11
            //   8d4f10               | dec                 ecx
            //   51                   | mov                 ecx, edi

        $sequence_45 = { 89750c 8d750c e8???????? 8bf0 }
            // n = 4, score = 400
            //   89750c               | mov                 eax, esp
            //   8d750c               | dec                 eax
            //   e8????????           |                     
            //   8bf0                 | mov                 eax, ecx

        $sequence_46 = { ff15???????? 4883f8ff 488bf8 7445 488d842488000000 }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   4883f8ff             | imul                esi, esi, 0x19660d
            //   488bf8               | push                dword ptr [ebp - 0xc]
            //   7445                 | add                 esi, 0x3c6ef35f
            //   488d842488000000     | mov                 dword ptr [ebp + 0xc], esi

        $sequence_47 = { 69f60d661900 ff75f4 81c65ff36e3c 89750c 8d750c }
            // n = 5, score = 400
            //   69f60d661900         | add                 esp, 0x38
            //   ff75f4               | ret                 
            //   81c65ff36e3c         | dec                 eax
            //   89750c               | mov                 eax, esp
            //   8d750c               | cmp                 eax, edx

        $sequence_48 = { c3 6a00 6800004000 6a00 ff15???????? a3???????? }
            // n = 6, score = 400
            //   c3                   | je                  0xb2
            //   6a00                 | inc                 ecx
            //   6800004000           | mov                 eax, 7
            //   6a00                 | jmp                 0xffffffdf
            //   ff15????????         |                     
            //   a3????????           |                     

        $sequence_49 = { 3decc7eea6 0f84e8000000 3d0470a8c4 0f8486000000 }
            // n = 4, score = 400
            //   3decc7eea6           | mov                 dword ptr [ebp + 0xc], esi
            //   0f84e8000000         | lea                 esi, [ebp + 0xc]
            //   3d0470a8c4           | mov                 esi, eax
            //   0f8486000000         | cmp                 esi, ebx

        $sequence_50 = { 7551 ff33 50 6810040000 ff15???????? 8945fc 85c0 }
            // n = 7, score = 400
            //   7551                 | add                 edi, 0x120
            //   ff33                 | inc                 ecx
            //   50                   | add                 ebp, 1
            //   6810040000           | inc                 esp
            //   ff15????????         |                     
            //   8945fc               | cmp                 ebp, dword ptr [esi]
            //   85c0                 | jae                 0x1a

        $sequence_51 = { 48895f2c 8b464c a802 7410 8b464c }
            // n = 5, score = 400
            //   48895f2c             | mov                 eax, esp
            //   8b464c               | dec                 eax
            //   a802                 | cmovne              ecx, edx
            //   7410                 | dec                 eax
            //   8b464c               | mov                 eax, ecx

        $sequence_52 = { 488d4c2440 ff15???????? 0fb74c2442 b856555555 }
            // n = 4, score = 400
            //   488d4c2440           | pop                 ebp
            //   ff15????????         |                     
            //   0fb74c2442           | ret                 4
            //   b856555555           | push                0

        $sequence_53 = { 4c8bc3 33d2 ff15???????? 4c8b442478 488b0d???????? 33d2 }
            // n = 6, score = 400
            //   4c8bc3               | mov                 ebx, dword ptr [esp + 0xc0]
            //   33d2                 | mov                 eax, esi
            //   ff15????????         |                     
            //   4c8b442478           | dec                 eax
            //   488b0d????????       |                     
            //   33d2                 | mov                 ebx, dword ptr [esp + 0xc0]

        $sequence_54 = { ff75fc e8???????? 8b45f0 40 c745e801000000 }
            // n = 5, score = 300
            //   ff75fc               | mov                 eax, dword ptr [esp + 0x78]
            //   e8????????           |                     
            //   8b45f0               | xor                 edx, edx
            //   40                   | dec                 esp
            //   c745e801000000       | mov                 eax, ebx

        $sequence_55 = { ff742404 a3???????? e8???????? 85c0 7551 ff742404 e8???????? }
            // n = 7, score = 300
            //   ff742404             | dec                 esp
            //   a3????????           |                     
            //   e8????????           |                     
            //   85c0                 | mov                 eax, ebx
            //   7551                 | xor                 edx, edx
            //   ff742404             | dec                 esp
            //   e8????????           |                     

        $sequence_56 = { ff35???????? ff15???????? eb22 ff7518 }
            // n = 4, score = 300
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   eb22                 | jne                 0x23
            //   ff7518               | mov                 edi, eax

        $sequence_57 = { e8???????? 85c0 0f849b000000 8d45f4 50 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   85c0                 | lea                 ebx, [esp + 0x70]
            //   0f849b000000         | mov                 eax, edi
            //   8d45f4               | xor                 edx, edx
            //   50                   | xor                 ecx, ecx

        $sequence_58 = { 3bc6 7551 a1???????? 8b4014 85c0 }
            // n = 5, score = 300
            //   3bc6                 | je                  0xac
            //   7551                 | push                ebx
            //   a1????????           |                     
            //   8b4014               | push                dword ptr [esi + 0x14]
            //   85c0                 | test                eax, eax

        $sequence_59 = { 493bce 753a 8b05???????? 488b0d???????? }
            // n = 4, score = 300
            //   493bce               | dec                 eax
            //   753a                 | mov                 esi, eax
            //   8b05????????         |                     
            //   488b0d????????       |                     

        $sequence_60 = { e8???????? e9???????? 3bf3 0f8435010000 395d10 0f842c010000 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   e9????????           |                     
            //   3bf3                 | dec                 eax
            //   0f8435010000         | test                eax, eax
            //   395d10               | dec                 esp
            //   0f842c010000         | mov                 esp, eax

        $sequence_61 = { 8be5 5d c20400 8325????????00 6a00 68???????? 6a01 }
            // n = 7, score = 300
            //   8be5                 | mov                 dword ptr [ebp - 8], eax
            //   5d                   | xor                 edi, edi
            //   c20400               | jmp                 7
            //   8325????????00       |                     
            //   6a00                 | mov                 dword ptr [ebp - 8], eax
            //   68????????           |                     
            //   6a01                 | xor                 edi, edi

        $sequence_62 = { e8???????? 8bf8 3bfb 0f857c040000 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8bf8                 | pop                 edi
            //   3bfb                 | pop                 esi
            //   0f857c040000         | pop                 ebx

        $sequence_63 = { 83ffff 0f843b010000 81ff02010000 0f8499000000 }
            // n = 4, score = 200
            //   83ffff               | mov                 ebx, dword ptr [esi]
            //   0f843b010000         | sub                 eax, dword ptr [edi + 0x1c]
            //   81ff02010000         | inc                 esp
            //   0f8499000000         | mov                 dword ptr [esp + 0x78], esi

        $sequence_64 = { 4183c501 443b2e 730a eba9 4533f6 eb08 }
            // n = 6, score = 200
            //   4183c501             | jne                 0xc1
            //   443b2e               | cmp                 edi, -1
            //   730a                 | je                  0x144
            //   eba9                 | cmp                 edi, 0x102
            //   4533f6               | je                  0xa5
            //   eb08                 | cmp                 edi, 0x102

        $sequence_65 = { ff15???????? 85c0 7412 4881c720010000 4183c501 443b2e 730a }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   85c0                 | dec                 eax
            //   7412                 | mov                 eax, dword ptr [ebp + 0x30]
            //   4881c720010000       | dec                 ecx
            //   4183c501             | mov                 dword ptr [esi - 8], eax
            //   443b2e               | mov                 eax, dword ptr [edi]
            //   730a                 | movzx               ecx, word ptr [edi + 0x10]

        $sequence_66 = { 81ff02010000 0f8499000000 f605????????08 6aff 68806967ff 56 7408 }
            // n = 7, score = 200
            //   81ff02010000         | mov                 eax, ecx
            //   0f8499000000         | dec                 eax
            //   f605????????08       |                     
            //   6aff                 | add                 esp, 0x38
            //   68806967ff           | ret                 
            //   56                   | dec                 eax
            //   7408                 | mov                 eax, esp

        $sequence_67 = { 5b c9 c20800 55 8bec 81ec1c010000 8d4807 }
            // n = 7, score = 200
            //   5b                   | test                edi, edi
            //   c9                   | jne                 0xffffffd1
            //   c20800               | not                 eax
            //   55                   | mov                 dword ptr [ebx + 0x3be701c], esi
            //   8bec                 | je                  0xc
            //   81ec1c010000         | add                 ebx, 4
            //   8d4807               | cmp                 ebx, 0x14

        $sequence_68 = { 83cfff 443bd3 7349 448bdf 452bda }
            // n = 5, score = 200
            //   83cfff               | je                  0x115
            //   443bd3               | mov                 eax, dword ptr [edx + 0x4c]
            //   7349                 | test                al, 6
            //   448bdf               | je                  0x1b
            //   452bda               | je                  0x29

        $sequence_69 = { 498d5c2478 e8???????? 4e8b4cb61e 4e8b44b616 33c9 }
            // n = 5, score = 200
            //   498d5c2478           | sub                 esp, 0x20
            //   e8????????           |                     
            //   4e8b4cb61e           | dec                 esp
            //   4e8b44b616           | mov                 eax, dword ptr [ecx + 8]
            //   33c9                 | dec                 eax

        $sequence_70 = { 81ff02010000 0f8495000000 8b3d???????? 6aff 68806967ff }
            // n = 5, score = 200
            //   81ff02010000         | inc                 esp
            //   0f8495000000         | mov                 dword ptr [esp + 0x7c], esi
            //   8b3d????????         |                     
            //   6aff                 | dec                 eax
            //   68806967ff           | mov                 edx, dword ptr [esp + 0x78]

        $sequence_71 = { ffb72c080000 e8???????? 5e 5d 5b c3 eb10 }
            // n = 7, score = 200
            //   ffb72c080000         | dec                 eax
            //   e8????????           |                     
            //   5e                   | mov                 dword ptr [eax + 8], ebx
            //   5d                   | dec                 eax
            //   5b                   | mov                 dword ptr [eax + 0x10], ebp
            //   c3                   | dec                 eax
            //   eb10                 | mov                 eax, ecx

        $sequence_72 = { 493bed 75a1 488bb42480000000 4c8b742470 }
            // n = 4, score = 200
            //   493bed               | inc                 esp
            //   75a1                 | mov                 ebx, dword ptr [esp + 0x38]
            //   488bb42480000000     | mov                 eax, dword ptr [edx + 0x4c]
            //   4c8b742470           | test                al, 1

        $sequence_73 = { 83c40c 83c01e 50 ffd7 ff35???????? }
            // n = 5, score = 200
            //   83c40c               | cmp                 cx, 2
            //   83c01e               | pop                 ebx
            //   50                   | ret                 8
            //   ffd7                 | push                ecx
            //   ff35????????         |                     

        $sequence_74 = { 41 f00fc108 a1???????? 83c01e 50 ff15???????? }
            // n = 6, score = 200
            //   41                   | mov                 esp, ebp
            //   f00fc108             | pop                 ebp
            //   a1????????           |                     
            //   83c01e               | ret                 
            //   50                   | movzx               ecx, word ptr [eax]
            //   ff15????????         |                     

        $sequence_75 = { 5b 8be5 5d c3 0fb708 6683f902 }
            // n = 6, score = 200
            //   5b                   | push                dword ptr [ebx]
            //   8be5                 | push                eax
            //   5d                   | push                0x410
            //   c3                   | mov                 dword ptr [ebp - 4], eax
            //   0fb708               | inc                 esi
            //   6683f902             | xor                 eax, dword ptr [ecx*4 + 0x3be6210]

        $sequence_76 = { 85c0 0f85b7000000 56 ff742428 ffd7 8bf8 }
            // n = 6, score = 200
            //   85c0                 | dec                 esp
            //   0f85b7000000         | mov                 eax, dword ptr [edi + 0x2c]
            //   56                   | mov                 al, byte ptr [edi]
            //   ff742428             | sub                 al, 0x41
            //   ffd7                 | cmp                 al, 5
            //   8bf8                 | mov                 al, byte ptr [edi]

        $sequence_77 = { ff15???????? 8bc3 e9???????? 48895c2408 4889742410 57 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   8bc3                 | je                  0xa9
            //   e9????????           |                     
            //   48895c2408           | mov                 ecx, dword ptr [edi + 0x30]
            //   4889742410           | test                cl, 0x40
            //   57                   | jne                 0x20

        $sequence_78 = { 488b15???????? 4c8d442468 48c7c101000080 ff15???????? }
            // n = 4, score = 200
            //   488b15????????       |                     
            //   4c8d442468           | mov                 eax, dword ptr [ecx + 8]
            //   48c7c101000080       | dec                 eax
            //   ff15????????         |                     

        $sequence_79 = { 83a78c00000000 33c0 c3 51 e8???????? 0558020000 }
            // n = 6, score = 200
            //   83a78c00000000       | test                eax, eax
            //   33c0                 | je                  0x1a5
            //   c3                   | cmp                 dword ptr [esp + 0x4c], ebx
            //   51                   | je                  0xd
            //   e8????????           |                     
            //   0558020000           | rep stosd           dword ptr es:[edi], eax

        $sequence_80 = { 50 ff742428 89542464 ffd3 56 57 }
            // n = 6, score = 200
            //   50                   | dec                 eax
            //   ff742428             | add                 esp, 0x38
            //   89542464             | ret                 
            //   ffd3                 | dec                 eax
            //   56                   | mov                 eax, esp
            //   57                   | dec                 eax

        $sequence_81 = { 56 ff742468 ffd7 85c0 0f85b7000000 }
            // n = 5, score = 200
            //   56                   | ja                  0xa
            //   ff742468             | sub                 al, 0x37
            //   ffd7                 | jmp                 0x14
            //   85c0                 | mov                 eax, dword ptr [esi + 0x3c]
            //   0f85b7000000         | dec                 eax

        $sequence_82 = { 56 0f84e9000000 ff74241c ffd7 }
            // n = 4, score = 200
            //   56                   | mov                 eax, dword ptr [esi + 0x4c]
            //   0f84e9000000         | dec                 eax
            //   ff74241c             | mov                 dword ptr [edi + 0x2c], ebx
            //   ffd7                 | dec                 eax

        $sequence_83 = { ff15???????? 85c0 743f 66ba2e00 498bcf ff15???????? 4885c0 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   85c0                 | movdqu              xmm0, xmmword ptr [ebp + 0x10]
            //   743f                 | inc                 ecx
            //   66ba2e00             | add                 edi, 0x24
            //   498bcf               | inc                 ecx
            //   ff15????????         |                     
            //   4885c0               | movq                qword ptr [esi - 0x18], mm0

        $sequence_84 = { 5b c20800 51 53 57 }
            // n = 5, score = 200
            //   5b                   | test                edi, edi
            //   c20800               | jne                 0xffffffd3
            //   51                   | not                 eax
            //   53                   | jmp                 0xa
            //   57                   | xor                 eax, eax

        $sequence_85 = { ff742414 e8???????? 813d????????58876837 7525 6a01 e8???????? 6a01 }
            // n = 7, score = 200
            //   ff742414             | mov                 eax, ecx
            //   e8????????           |                     
            //   813d????????58876837     |     
            //   7525                 | dec                 eax
            //   6a01                 | add                 esp, 0x38
            //   e8????????           |                     
            //   6a01                 | ret                 

        $sequence_86 = { 8bfb 8898d8fdffff e8???????? 448bac2400030000 440fb7db 4183fd25 }
            // n = 6, score = 200
            //   8bfb                 | dec                 eax
            //   8898d8fdffff         | sub                 esp, 0x20
            //   e8????????           |                     
            //   448bac2400030000     | dec                 esp
            //   440fb7db             | mov                 eax, dword ptr [ecx + 8]
            //   4183fd25             | dec                 eax

        $sequence_87 = { a3???????? bf???????? 33f6 8b8618c60310 e8???????? 8947fc }
            // n = 6, score = 100
            //   a3????????           |                     
            //   bf????????           |                     
            //   33f6                 | dec                 eax
            //   8b8618c60310         | mov                 dword ptr [eax + 8], ebx
            //   e8????????           |                     
            //   8947fc               | dec                 eax

        $sequence_88 = { 8b483c 66f74401160020 7408 c744244c8e85be03 e8???????? }
            // n = 5, score = 100
            //   8b483c               | mov                 dword ptr [esp + 8], ebx
            //   66f74401160020       | dec                 eax
            //   7408                 | mov                 dword ptr [esp + 0x10], esi
            //   c744244c8e85be03     | push                edi
            //   e8????????           |                     

        $sequence_89 = { 89b31c70be03 740a 83c304 83fb14 72c9 eb12 }
            // n = 6, score = 100
            //   89b31c70be03         | test                eax, eax
            //   740a                 | jne                 8
            //   83c304               | mov                 eax, ebx
            //   83fb14               | dec                 eax
            //   72c9                 | mov                 dword ptr [esp + 8], ebx
            //   eb12                 | dec                 eax

        $sequence_90 = { 85c0 0f849d010000 395c244c 7407 68???????? }
            // n = 5, score = 100
            //   85c0                 | xor                 edx, edx
            //   0f849d010000         | dec                 esp
            //   395c244c             | mov                 eax, dword ptr [esp + 0x78]
            //   7407                 | dec                 esp
            //   68????????           |                     

        $sequence_91 = { 894df8 894dec c745e0e724be03 8945d8 751b f605????????01 7412 }
            // n = 7, score = 100
            //   894df8               | mov                 dword ptr [esp + 8], ebx
            //   894dec               | dec                 eax
            //   c745e0e724be03       | mov                 dword ptr [esp + 0x10], esi
            //   8945d8               | push                edi
            //   751b                 | mov                 eax, ebx
            //   f605????????01       |                     
            //   7412                 | dec                 eax

        $sequence_92 = { e42c d08b19ec3bc2 14e1 32ec }
            // n = 4, score = 100
            //   e42c                 | cmp                 ecx, esi
            //   d08b19ec3bc2         | jne                 0x3f
            //   14e1                 | mov                 eax, ebx
            //   32ec                 | dec                 eax

        $sequence_93 = { f3ab e8???????? 8bf0 3bf3 0f85d4020000 }
            // n = 5, score = 100
            //   f3ab                 | mov                 eax, ebx
            //   e8????????           |                     
            //   8bf0                 | xor                 edx, edx
            //   3bf3                 | dec                 esp
            //   0f85d4020000         | mov                 eax, dword ptr [esp + 0x78]

        $sequence_94 = { 8bd8 83fbff 0f843d010000 81fb02010000 0f8496000000 }
            // n = 5, score = 100
            //   8bd8                 | dec                 eax
            //   83fbff               | add                 esp, 0x38
            //   0f843d010000         | ret                 
            //   81fb02010000         | dec                 eax
            //   0f8496000000         | mov                 eax, esp

        $sequence_95 = { 46 33048d1062be03 85ff 75cf f7d0 eb02 33c0 }
            // n = 7, score = 100
            //   46                   | dec                 esp
            //   33048d1062be03       | mov                 eax, ebx
            //   85ff                 | xor                 edx, edx
            //   75cf                 | dec                 esp
            //   f7d0                 | mov                 eax, dword ptr [esp + 0x78]
            //   eb02                 | dec                 esp
            //   33c0                 | mov                 eax, ebx

        $sequence_96 = { 0fb6b120d00310 0fb6b9a0d00310 0fb68c0632900000 0fb7b470928a0000 894df4 8b4844 d3e6 }
            // n = 7, score = 100
            //   0fb6b120d00310       | mov                 dword ptr [eax + 0x10], ebp
            //   0fb6b9a0d00310       | test                eax, eax
            //   0fb68c0632900000     | je                  0x43
            //   0fb7b470928a0000     | mov                 dx, 0x2e
            //   894df4               | dec                 ecx
            //   8b4844               | mov                 ecx, edi
            //   d3e6                 | dec                 eax

        $sequence_97 = { ffd6 ff742414 ff742414 57 e8???????? }
            // n = 5, score = 100
            //   ffd6                 | dec                 esp
            //   ff742414             | mov                 eax, ebx
            //   ff742414             | xor                 edx, edx
            //   57                   | dec                 esp
            //   e8????????           |                     

    condition:
        7 of them and filesize < 778240
}