rule win_dtrack_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dtrack."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dtrack"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 8b4508 50 e8???????? 83c414 8b4d10 51 }
            // n = 7, score = 400
            //   52                   | push                edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   51                   | push                ecx

        $sequence_1 = { 50 8d8dccfdffff 51 6a00 8d95b0faffff 52 }
            // n = 6, score = 300
            //   50                   | push                eax
            //   8d8dccfdffff         | lea                 ecx, [ebp - 0x234]
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   8d95b0faffff         | lea                 edx, [ebp - 0x550]
            //   52                   | push                edx

        $sequence_2 = { 8b4df8 c1e902 334df8 8b55f8 c1ea03 33ca }
            // n = 6, score = 300
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   c1e902               | shr                 ecx, 2
            //   334df8               | xor                 ecx, dword ptr [ebp - 8]
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   c1ea03               | shr                 edx, 3
            //   33ca                 | xor                 ecx, edx

        $sequence_3 = { 33ca 8b55f8 c1ea07 33ca c1e118 }
            // n = 5, score = 300
            //   33ca                 | xor                 ecx, edx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   c1ea07               | shr                 edx, 7
            //   33ca                 | xor                 ecx, edx
            //   c1e118               | shl                 ecx, 0x18

        $sequence_4 = { 50 e8???????? 83c40c c685b8fbffff00 }
            // n = 4, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c685b8fbffff00       | mov                 byte ptr [ebp - 0x448], 0

        $sequence_5 = { 8b88fc180000 8b5508 8b4508 8b8008100000 89848a04100000 8b4d0c }
            // n = 6, score = 300
            //   8b88fc180000         | mov                 ecx, dword ptr [eax + 0x18fc]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b8008100000         | mov                 eax, dword ptr [eax + 0x1008]
            //   89848a04100000       | mov                 dword ptr [edx + ecx*4 + 0x1004], eax
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]

        $sequence_6 = { 8d959efaffff 52 e8???????? 83c410 8d85d4faffff 898528f6ffff }
            // n = 6, score = 300
            //   8d959efaffff         | lea                 edx, [ebp - 0x562]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8d85d4faffff         | lea                 eax, [ebp - 0x52c]
            //   898528f6ffff         | mov                 dword ptr [ebp - 0x9d8], eax

        $sequence_7 = { e8???????? 83c410 c68587f6ffff00 8b15???????? 52 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   c68587f6ffff00       | mov                 byte ptr [ebp - 0x979], 0
            //   8b15????????         |                     
            //   52                   | push                edx

        $sequence_8 = { eb64 8b4d10 51 6a00 }
            // n = 4, score = 200
            //   eb64                 | jmp                 0x66
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   51                   | push                ecx
            //   6a00                 | push                0

        $sequence_9 = { 8b08 894dfc 8b550c 8b4204 8945f8 68efcdab89 }
            // n = 6, score = 200
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   68efcdab89           | push                0x89abcdef

        $sequence_10 = { c1e217 0bca 894d14 8b45f8 }
            // n = 4, score = 200
            //   c1e217               | shl                 edx, 0x17
            //   0bca                 | or                  ecx, edx
            //   894d14               | mov                 dword ptr [ebp + 0x14], ecx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_11 = { 6a00 8b55f4 52 e8???????? 83c40c 8b450c 8b08 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_12 = { 0bc1 894518 8b5514 8955f8 }
            // n = 4, score = 200
            //   0bc1                 | or                  eax, ecx
            //   894518               | mov                 dword ptr [ebp + 0x18], eax
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx

        $sequence_13 = { 8b4df8 c1e908 234df8 8b45f8 c1e810 23c8 }
            // n = 6, score = 200
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   c1e908               | shr                 ecx, 8
            //   234df8               | and                 ecx, dword ptr [ebp - 8]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   c1e810               | shr                 eax, 0x10
            //   23c8                 | and                 ecx, eax

        $sequence_14 = { 8b4df0 3b4d10 0f8d90000000 8b5508 }
            // n = 4, score = 200
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   3b4d10               | cmp                 ecx, dword ptr [ebp + 0x10]
            //   0f8d90000000         | jge                 0x96
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

    condition:
        7 of them and filesize < 1736704
}