rule win_dubrute_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dubrute."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dubrute"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8d85d0fcffff bfff000000 50 57 ff15???????? 8d85d0fcffff }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8d85d0fcffff         | lea                 eax, [ebp - 0x330]
            //   bfff000000           | mov                 edi, 0xff
            //   50                   | push                eax
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8d85d0fcffff         | lea                 eax, [ebp - 0x330]

        $sequence_1 = { ff7514 8b8674090000 ff7510 ff750c ff7008 e8???????? 83c410 }
            // n = 7, score = 100
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   8b8674090000         | mov                 eax, dword ptr [esi + 0x974]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7008               | push                dword ptr [eax + 8]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_2 = { 55 8bec 83ec24 56 57 6a0c 8d45f4 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec24               | sub                 esp, 0x24
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a0c                 | push                0xc
            //   8d45f4               | lea                 eax, [ebp - 0xc]

        $sequence_3 = { 395008 7510 8b4808 3bca 7c09 83f907 7f04 }
            // n = 7, score = 100
            //   395008               | cmp                 dword ptr [eax + 8], edx
            //   7510                 | jne                 0x12
            //   8b4808               | mov                 ecx, dword ptr [eax + 8]
            //   3bca                 | cmp                 ecx, edx
            //   7c09                 | jl                  0xb
            //   83f907               | cmp                 ecx, 7
            //   7f04                 | jg                  6

        $sequence_4 = { e9???????? 8d45fc 50 53 e8???????? 59 85c0 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_5 = { 8b8040000100 83b81804000000 741e 837df800 7418 83b80c04000008 7e0f }
            // n = 7, score = 100
            //   8b8040000100         | mov                 eax, dword ptr [eax + 0x10040]
            //   83b81804000000       | cmp                 dword ptr [eax + 0x418], 0
            //   741e                 | je                  0x20
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7418                 | je                  0x1a
            //   83b80c04000008       | cmp                 dword ptr [eax + 0x40c], 8
            //   7e0f                 | jle                 0x11

        $sequence_6 = { 894508 8d8564ffffff 6a01 50 8d4dc8 ff15???????? db4508 }
            // n = 7, score = 100
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   8d8564ffffff         | lea                 eax, [ebp - 0x9c]
            //   6a01                 | push                1
            //   50                   | push                eax
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   ff15????????         |                     
            //   db4508               | fild                dword ptr [ebp + 8]

        $sequence_7 = { ff7508 50 e8???????? 8bf0 8d7de8 }
            // n = 5, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   8d7de8               | lea                 edi, [ebp - 0x18]

        $sequence_8 = { 8bf0 8d7df0 a5 a5 a5 8b75f0 83c43c }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   8d7df0               | lea                 edi, [ebp - 0x10]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   8b75f0               | mov                 esi, dword ptr [ebp - 0x10]
            //   83c43c               | add                 esp, 0x3c

        $sequence_9 = { 0f8cce000000 83650800 837f0400 8b7510 bb???????? 7e70 8b07 }
            // n = 7, score = 100
            //   0f8cce000000         | jl                  0xd4
            //   83650800             | and                 dword ptr [ebp + 8], 0
            //   837f0400             | cmp                 dword ptr [edi + 4], 0
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   bb????????           |                     
            //   7e70                 | jle                 0x72
            //   8b07                 | mov                 eax, dword ptr [edi]

    condition:
        7 of them and filesize < 598016
}