rule win_dustman_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dustman."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dustman"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bd9 4c8d0dedb20000 b902000000 4c8d05d9b20000 }
            // n = 4, score = 100
            //   8bd9                 | dec                 eax
            //   4c8d0dedb20000       | shl                 eax, 0x20
            //   b902000000           | dec                 esp
            //   4c8d05d9b20000       | or                  edx, eax

        $sequence_1 = { 884810 488b4d88 0fb60c01 884811 488b4d90 0fb60c01 884812 }
            // n = 7, score = 100
            //   884810               | dec                 eax
            //   488b4d88             | mov                 eax, dword ptr [esp + 0x28]
            //   0fb60c01             | dec                 eax
            //   884811               | lea                 eax, [esp + 0x28]
            //   488b4d90             | add                 ebx, edi
            //   0fb60c01             | inc                 ebp
            //   884812               | xor                 ecx, ecx

        $sequence_2 = { c3 488d055d954101 c3 488d054d954101 c3 }
            // n = 5, score = 100
            //   c3                   | sub                 ecx, edx
            //   488d055d954101       | dec                 esp
            //   c3                   | lea                 ebx, [ebp + 0x1c8]
            //   488d054d954101       | dec                 ecx
            //   c3                   | add                 ecx, ebx

        $sequence_3 = { 4c8d9db1010000 4903cb 48894d88 488bca 492bca }
            // n = 5, score = 100
            //   4c8d9db1010000       | inc                 esp
            //   4903cb               | mov                 edi, ecx
            //   48894d88             | dec                 esp
            //   488bca               | lea                 esi, [0xffff9ce6]
            //   492bca               | dec                 ebp

        $sequence_4 = { 4d8be1 498be8 4c8bea 4b8b8cfe40c80100 4c8b15???????? 4883cfff }
            // n = 6, score = 100
            //   4d8be1               | lea                 eax, [ebx + 8]
            //   498be8               | dec                 ecx
            //   4c8bea               | mov                 dword ptr [ebx - 0x30], ecx
            //   4b8b8cfe40c80100     | dec                 ecx
            //   4c8b15????????       |                     
            //   4883cfff             | mov                 dword ptr [ebx - 0x38], eax

        $sequence_5 = { 492bca 4c8d9dc4010000 4903cb 48894d20 488bca 492bca 4c8d9dc5010000 }
            // n = 7, score = 100
            //   492bca               | lea                 ebx, [ebp + 0x1b7]
            //   4c8d9dc4010000       | dec                 ecx
            //   4903cb               | add                 ecx, ebx
            //   48894d20             | dec                 eax
            //   488bca               | mov                 dword ptr [ebp - 0x48], ecx
            //   492bca               | dec                 eax
            //   4c8d9dc5010000       | mov                 ecx, edx

        $sequence_6 = { c4c173590cc1 4c8d0d05750000 c5f359c1 c5fb101d???????? c5fb102d???????? c4e2f1a91d???????? c4e2f1a92d???????? }
            // n = 7, score = 100
            //   c4c173590cc1         | mov                 edx, edx
            //   4c8d0d05750000       | dec                 ebp
            //   c5f359c1             | mov                 ecx, dword ptr [edi + eax*8 + 0x1c960]
            //   c5fb101d????????     |                     
            //   c5fb102d????????     |                     
            //   c4e2f1a91d????????     |     
            //   c4e2f1a92d????????     |     

        $sequence_7 = { 0fb68525020000 48c1e028 4c0bd0 0fb68526020000 48c1e030 4c0bd0 0fb68527020000 }
            // n = 7, score = 100
            //   0fb68525020000       | dec                 esp
            //   48c1e028             | lea                 eax, [0xec7c]
            //   4c0bd0               | and                 edx, 0x3f
            //   0fb68526020000       | dec                 eax
            //   48c1e030             | lea                 edx, [edx + edx*8]
            //   4c0bd0               | dec                 ecx
            //   0fb68527020000       | mov                 eax, dword ptr [eax + eax*8]

        $sequence_8 = { e8???????? 4883f8ff 7524 ff15???????? 488d4c2420 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   4883f8ff             | dec                 ecx
            //   7524                 | sub                 ecx, edx
            //   ff15????????         |                     
            //   488d4c2420           | dec                 esp

        $sequence_9 = { e9???????? 4d8bb4f6d0320100 33d2 498bce 41b800080000 }
            // n = 5, score = 100
            //   e9????????           |                     
            //   4d8bb4f6d0320100     | sub                 esp, 0x20
            //   33d2                 | inc                 ecx
            //   498bce               | mov                 esi, eax
            //   41b800080000         | dec                 esp

    condition:
        7 of them and filesize < 368640
}