rule win_dustpan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dustpan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dustpan"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4533c0 4c891d???????? e8???????? 488d0d32010000 4883c420 5b e9???????? }
            // n = 7, score = 100
            //   4533c0               | dec                 eax
            //   4c891d????????       |                     
            //   e8????????           |                     
            //   488d0d32010000       | mov                 dword ptr [esp + 0x58], esi
            //   4883c420             | dec                 eax
            //   5b                   | mov                 ebx, ecx
            //   e9????????           |                     

        $sequence_1 = { b9ff000000 e8???????? 488bfb 4803ff 4c8d2d45eb0000 }
            // n = 5, score = 100
            //   b9ff000000           | lea                 eax, [0x11504]
            //   e8????????           |                     
            //   488bfb               | dec                 eax
            //   4803ff               | mov                 dword ptr [esp + 0x20], eax
            //   4c8d2d45eb0000       | dec                 eax

        $sequence_2 = { 488d0d19a80100 33d2 c744242800000008 895c2420 ffd0 488b4d00 4833cc }
            // n = 7, score = 100
            //   488d0d19a80100       | dec                 eax
            //   33d2                 | lea                 ecx, [ebp - 0x70]
            //   c744242800000008     | inc                 ebp
            //   895c2420             | xor                 eax, eax
            //   ffd0                 | dec                 eax
            //   488b4d00             | mov                 dword ptr [esp + 0x40], ecx
            //   4833cc               | dec                 eax

        $sequence_3 = { 4c8be7 4c8bf7 49c1fe05 4c8d3dffb60000 }
            // n = 4, score = 100
            //   4c8be7               | mov                 dword ptr [ecx + 0x10c], esi
            //   4c8bf7               | dec                 eax
            //   49c1fe05             | mov                 dword ptr [ecx + 0x150], eax
            //   4c8d3dffb60000       | xor                 eax, eax

        $sequence_4 = { 488d05fb0a0100 eb04 4883c014 8918 e8???????? 4c8d15e30a0100 4885c0 }
            // n = 7, score = 100
            //   488d05fb0a0100       | mov                 esi, ecx
            //   eb04                 | dec                 eax
            //   4883c014             | arpl                word ptr [ebp + 0x528], ax
            //   8918                 | dec                 eax
            //   e8????????           |                     
            //   4c8d15e30a0100       | lea                 ecx, [esp + 0x30]
            //   4885c0               | mov                 edx, 2

        $sequence_5 = { 7440 66448923 8a45d8 4b8b8cf8e0d00100 88443109 8a45d9 }
            // n = 6, score = 100
            //   7440                 | lea                 eax, [0x12400]
            //   66448923             | dec                 esp
            //   8a45d8               | lea                 ebx, [0x123e1]
            //   4b8b8cf8e0d00100     | dec                 esp
            //   88443109             | mov                 dword ptr [edi], ebx
            //   8a45d9               | movups              xmm0, xmmword ptr [ebx + 0x18]

        $sequence_6 = { e9???????? 488d0d45010000 e9???????? 4883ec28 488d0d12910000 e8???????? 488d0d39010000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d0d45010000       | lea                 ecx, [0x15aa6]
            //   e9????????           |                     
            //   4883ec28             | dec                 eax
            //   488d0d12910000       | mov                 edx, ecx
            //   e8????????           |                     
            //   488d0d39010000       | dec                 esp

        $sequence_7 = { 488bca 48c1f905 4c8d0533760100 83e21f }
            // n = 4, score = 100
            //   488bca               | dec                 eax
            //   48c1f905             | sub                 esp, 0x20
            //   4c8d0533760100       | dec                 eax
            //   83e21f               | mov                 ebx, ecx

        $sequence_8 = { 4889442420 e8???????? 488d8380000000 803800 741d 4c8d0df2bc0000 41b802000000 }
            // n = 7, score = 100
            //   4889442420           | cmp                 dword ptr [eax + 0x38], 0
            //   e8????????           |                     
            //   488d8380000000       | dec                 eax
            //   803800               | lea                 eax, [0x18b65]
            //   741d                 | ret                 
            //   4c8d0df2bc0000       | inc                 eax
            //   41b802000000         | push                ebx

        $sequence_9 = { 894704 e9???????? 488d0d351f0100 48394c2458 7427 }
            // n = 5, score = 100
            //   894704               | dec                 eax
            //   e9????????           |                     
            //   488d0d351f0100       | lea                 ecx, [esp + 0x30]
            //   48394c2458           | dec                 eax
            //   7427                 | mov                 dword ptr [edx + eax*8 + 0x1bf20], ebx

    condition:
        7 of them and filesize < 282624
}