rule win_dyepack_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dyepack."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dyepack"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb04 8b4c2410 2bcd 1bc7 7815 }
            // n = 5, score = 300
            //   eb04                 | jmp                 6
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   2bcd                 | sub                 ecx, ebp
            //   1bc7                 | sbb                 eax, edi
            //   7815                 | js                  0x17

        $sequence_1 = { b814100000 e8???????? 53 56 57 33db b9ff030000 }
            // n = 7, score = 300
            //   b814100000           | mov                 eax, 0x1014
            //   e8????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   b9ff030000           | mov                 ecx, 0x3ff

        $sequence_2 = { 3bcb 765a eb04 8b4c2410 2bcd }
            // n = 5, score = 300
            //   3bcb                 | cmp                 ecx, ebx
            //   765a                 | jbe                 0x5c
            //   eb04                 | jmp                 6
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   2bcd                 | sub                 ecx, ebp

        $sequence_3 = { 56 ff15???????? 8d442410 895c2410 50 56 }
            // n = 6, score = 300
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   895c2410             | mov                 dword ptr [esp + 0x10], ebx
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_4 = { ff15???????? 56 ff15???????? 8d442410 895c2410 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   895c2410             | mov                 dword ptr [esp + 0x10], ebx

        $sequence_5 = { 53 51 e8???????? 83c408 5d 5f }
            // n = 6, score = 300
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   5d                   | pop                 ebp
            //   5f                   | pop                 edi

        $sequence_6 = { 53 aa 8b842434100000 53 6800000040 50 ff15???????? }
            // n = 7, score = 300
            //   53                   | push                ebx
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8b842434100000       | mov                 eax, dword ptr [esp + 0x1034]
            //   53                   | push                ebx
            //   6800000040           | push                0x40000000
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_7 = { 13fb 3bf8 7cb2 7f08 8b4c2410 3be9 }
            // n = 6, score = 300
            //   13fb                 | adc                 edi, ebx
            //   3bf8                 | cmp                 edi, eax
            //   7cb2                 | jl                  0xffffffb4
            //   7f08                 | jg                  0xa
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   3be9                 | cmp                 ebp, ecx

        $sequence_8 = { 53 56 ffd7 8b442414 8b4c2410 33ed 33ff }
            // n = 7, score = 300
            //   53                   | push                ebx
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   33ed                 | xor                 ebp, ebp
            //   33ff                 | xor                 edi, edi

        $sequence_9 = { 7815 7f08 81f900100000 760b b900100000 895c2420 }
            // n = 6, score = 300
            //   7815                 | js                  0x17
            //   7f08                 | jg                  0xa
            //   81f900100000         | cmp                 ecx, 0x1000
            //   760b                 | jbe                 0xd
            //   b900100000           | mov                 ecx, 0x1000
            //   895c2420             | mov                 dword ptr [esp + 0x20], ebx

    condition:
        7 of them and filesize < 212992
}