rule win_dyre_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dyre."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dyre"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6800004000 6800000400 ff15???????? a3???????? 85c0 }
            // n = 5, score = 700
            //   6800004000           | push                0x400000
            //   6800000400           | push                0x40000
            //   ff15????????         |                     
            //   a3????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_1 = { 747c 8d4602 50 e8???????? 8bf8 }
            // n = 5, score = 600
            //   747c                 | je                  0x7e
            //   8d4602               | lea                 eax, [esi + 2]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_2 = { 33c8 894304 895308 894b10 c745ec10000000 837df400 0f84f7000000 }
            // n = 7, score = 600
            //   33c8                 | xor                 ecx, eax
            //   894304               | mov                 dword ptr [ebx + 4], eax
            //   895308               | mov                 dword ptr [ebx + 8], edx
            //   894b10               | mov                 dword ptr [ebx + 0x10], ecx
            //   c745ec10000000       | mov                 dword ptr [ebp - 0x14], 0x10
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0
            //   0f84f7000000         | je                  0xfd

        $sequence_3 = { 59 85c0 740d 8d4801 3b4d14 }
            // n = 5, score = 600
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   740d                 | je                  0xf
            //   8d4801               | lea                 ecx, [eax + 1]
            //   3b4d14               | cmp                 ecx, dword ptr [ebp + 0x14]

        $sequence_4 = { 742e 53 8bc7 e8???????? 8bd8 }
            // n = 5, score = 600
            //   742e                 | je                  0x30
            //   53                   | push                ebx
            //   8bc7                 | mov                 eax, edi
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_5 = { 81ec14010000 8364240400 53 56 57 }
            // n = 5, score = 600
            //   81ec14010000         | sub                 esp, 0x114
            //   8364240400           | and                 dword ptr [esp + 4], 0
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_6 = { 59 83f8ff 7549 33ff 83f8ff 7542 }
            // n = 6, score = 600
            //   59                   | pop                 ecx
            //   83f8ff               | cmp                 eax, -1
            //   7549                 | jne                 0x4b
            //   33ff                 | xor                 edi, edi
            //   83f8ff               | cmp                 eax, -1
            //   7542                 | jne                 0x44

        $sequence_7 = { 33d2 f7f3 3bd6 7409 }
            // n = 4, score = 600
            //   33d2                 | xor                 edx, edx
            //   f7f3                 | div                 ebx
            //   3bd6                 | cmp                 edx, esi
            //   7409                 | je                  0xb

        $sequence_8 = { 4883ec20 488bd9 b910270000 ff15???????? 488bcb }
            // n = 5, score = 500
            //   4883ec20             | dec                 eax
            //   488bd9               | mov                 dword ptr [esp + 0x20], edi
            //   b910270000           | test                eax, eax
            //   ff15????????         |                     
            //   488bcb               | dec                 eax

        $sequence_9 = { 488bcd ff15???????? 488b5c2460 8bc7 4883c440 }
            // n = 5, score = 500
            //   488bcd               | inc                 ebp
            //   ff15????????         |                     
            //   488b5c2460           | xor                 eax, eax
            //   8bc7                 | dec                 eax
            //   4883c440             | mov                 dword ptr [esp + 0x20], eax

        $sequence_10 = { 4883ec20 488b0d???????? 33d2 ff15???????? }
            // n = 4, score = 500
            //   4883ec20             | mov                 dword ptr [esp + 0x20], edi
            //   488b0d????????       |                     
            //   33d2                 | dec                 eax
            //   ff15????????         |                     

        $sequence_11 = { 488b4c2458 488d442450 8d5301 4533c9 4533c0 4889442420 895c2450 }
            // n = 7, score = 500
            //   488b4c2458           | dec                 eax
            //   488d442450           | mov                 ecx, dword ptr [esp + 0x58]
            //   8d5301               | dec                 eax
            //   4533c9               | lea                 eax, [esp + 0x50]
            //   4533c0               | lea                 edx, [ebx + 1]
            //   4889442420           | inc                 ebp
            //   895c2450             | xor                 ecx, ecx

        $sequence_12 = { 488bd9 83fa04 763b 0f1f00 0fb74b02 ff15???????? }
            // n = 6, score = 500
            //   488bd9               | dec                 eax
            //   83fa04               | mov                 ebx, ecx
            //   763b                 | mov                 ecx, 0x2710
            //   0f1f00               | dec                 eax
            //   0fb74b02             | sub                 esp, 0x20
            //   ff15????????         |                     

        $sequence_13 = { 4883ec20 448b4124 33ff 488bf2 428d04c500000000 488bd9 014120 }
            // n = 7, score = 500
            //   4883ec20             | mov                 ecx, ebx
            //   448b4124             | inc                 edi
            //   33ff                 | add                 eax, dword ptr [ebx + 0x10]
            //   488bf2               | lea                 esi, [esi + eax + 0x27]
            //   428d04c500000000     | inc                 ecx
            //   488bd9               | cmp                 edi, esp
            //   014120               | jl                  0xffffffed

        $sequence_14 = { 488bcb ff15???????? ffc7 034310 8d740627 413bfc 7cdf }
            // n = 7, score = 500
            //   488bcb               | dec                 eax
            //   ff15????????         |                     
            //   ffc7                 | mov                 ebx, dword ptr [esp + 0x60]
            //   034310               | mov                 eax, edi
            //   8d740627             | dec                 eax
            //   413bfc               | mov                 ecx, ebp
            //   7cdf                 | mov                 dword ptr [esp + 0x70], edi

        $sequence_15 = { 488bcd 897c2470 48897c2420 ff15???????? 85c0 }
            // n = 5, score = 500
            //   488bcd               | dec                 eax
            //   897c2470             | mov                 ebx, dword ptr [esp + 0x60]
            //   48897c2420           | mov                 eax, edi
            //   ff15????????         |                     
            //   85c0                 | dec                 eax

        $sequence_16 = { 668b1401 668910 83c002 4e 75f3 }
            // n = 5, score = 400
            //   668b1401             | mov                 dx, word ptr [ecx + eax]
            //   668910               | mov                 word ptr [eax], dx
            //   83c002               | add                 eax, 2
            //   4e                   | dec                 esi
            //   75f3                 | jne                 0xfffffff5

        $sequence_17 = { 85db 7416 57 8bfa 2bfe 90 }
            // n = 6, score = 200
            //   85db                 | test                ebx, ebx
            //   7416                 | je                  0x18
            //   57                   | push                edi
            //   8bfa                 | mov                 edi, edx
            //   2bfe                 | sub                 edi, esi
            //   90                   | nop                 

        $sequence_18 = { 8bd8 56 8bf1 85db 7416 }
            // n = 5, score = 200
            //   8bd8                 | mov                 ebx, eax
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   85db                 | test                ebx, ebx
            //   7416                 | je                  0x18

        $sequence_19 = { 50 a1???????? 6a08 50 ff15???????? 8bd8 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   a1????????           |                     
            //   6a08                 | push                8
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_20 = { ff15???????? 8bf0 8d85d4fdffff 50 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   8d85d4fdffff         | lea                 eax, [ebp - 0x22c]
            //   50                   | push                eax

        $sequence_21 = { 90 ff15???????? 8a0437 8806 46 4b }
            // n = 6, score = 200
            //   90                   | nop                 
            //   ff15????????         |                     
            //   8a0437               | mov                 al, byte ptr [edi + esi]
            //   8806                 | mov                 byte ptr [esi], al
            //   46                   | inc                 esi
            //   4b                   | dec                 ebx

        $sequence_22 = { 833d????????00 751b 6a00 6800004000 6800000400 }
            // n = 5, score = 200
            //   833d????????00       |                     
            //   751b                 | jne                 0x1d
            //   6a00                 | push                0
            //   6800004000           | push                0x400000
            //   6800000400           | push                0x40000

    condition:
        7 of them and filesize < 590848
}