rule win_echo_gather_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.echo_gather."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.echo_gather"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4989d9 4d89fc 488b5c2430 4c8b7c2438 4589f0 4183fe39 0f8451030000 }
            // n = 7, score = 100
            //   4989d9               | mov                 eax, dword ptr [esp + 0x5d8]
            //   4d89fc               | dec                 ebp
            //   488b5c2430           | mov                 ecx, eax
            //   4c8b7c2438           | dec                 ecx
            //   4589f0               | mov                 eax, ecx
            //   4183fe39             | dec                 ebp
            //   0f8451030000         | imul                eax, ecx

        $sequence_1 = { 488b45d8 4889c1 488b05???????? ffd0 e9???????? 8b45bc }
            // n = 6, score = 100
            //   488b45d8             | mov                 esi, esi
            //   4889c1               | inc                 ecx
            //   488b05????????       |                     
            //   ffd0                 | cmp                 ebp, 0x8007007a
            //   e9????????           |                     
            //   8b45bc               | jne                 0x1deb

        $sequence_2 = { 74c4 b920000000 e8???????? 8b4324 83c001 894324 4183ed01 }
            // n = 7, score = 100
            //   74c4                 | jne                 0x236
            //   b920000000           | dec                 ecx
            //   e8????????           |                     
            //   8b4324               | sub                 edx, eax
            //   83c001               | dec                 ebp
            //   894324               | mov                 ebx, ecx
            //   4183ed01             | dec                 esi

        $sequence_3 = { 48898424f8040000 488b842450040000 4889842400050000 66c78424e00400000000 e8???????? 4889c2 488b4d10 }
            // n = 7, score = 100
            //   48898424f8040000     | mov                 eax, eax
            //   488b842450040000     | dec                 eax
            //   4889842400050000     | mov                 eax, dword ptr [ebp + 0x18]
            //   66c78424e00400000000     | dec    eax
            //   e8????????           |                     
            //   4889c2               | mov                 eax, dword ptr [eax]
            //   488b4d10             | dec                 eax

        $sequence_4 = { 743f 48c1ea20 7539 4883eb01 4889da e8???????? 85c0 }
            // n = 7, score = 100
            //   743f                 | jne                 0x1f23
            //   48c1ea20             | dec                 ecx
            //   7539                 | mov                 esi, ebx
            //   4883eb01             | jne                 0x1fda
            //   4889da               | dec                 eax
            //   e8????????           |                     
            //   85c0                 | mov                 eax, dword ptr [esp + 0x20]

        $sequence_5 = { 7561 4181fd7a000780 7409 4181fd26000780 75b4 }
            // n = 5, score = 100
            //   7561                 | dec                 eax
            //   4181fd7a000780       | test                eax, eax
            //   7409                 | je                  0xcf1
            //   4181fd26000780       | dec                 eax
            //   75b4                 | add                 edx, eax

        $sequence_6 = { 0f94c0 84c0 744a 8b45ec 89c0 4889c2 b940000000 }
            // n = 7, score = 100
            //   0f94c0               | test                ebx, ebx
            //   84c0                 | mov                 dword ptr [esp + 0x28], ebp
            //   744a                 | dec                 ecx
            //   8b45ec               | mov                 eax, edi
            //   89c0                 | dec                 eax
            //   4889c2               | lea                 edx, [0x8ddb]
            //   b940000000           | mov                 dword ptr [esp + 0x20], eax

        $sequence_7 = { 48c78424a800000011000000 c78424bc00000000000000 eb31 8b8424bc000000 4898 488b54c420 488b4510 }
            // n = 7, score = 100
            //   48c78424a800000011000000     | mov    eax, ebx
            //   c78424bc00000000000000     | dec    esp
            //   eb31                 | mov                 edi, esp
            //   8b8424bc000000       | add                 eax, 1
            //   4898                 | dec                 eax
            //   488b54c420           | mov                 edx, dword ptr [esp + 0x38]
            //   488b4510             | dec                 eax

        $sequence_8 = { 488d8c2450010000 488d942450020000 488d842450030000 4989c8 4889c1 e8???????? }
            // n = 6, score = 100
            //   488d8c2450010000     | mov                 eax, dword ptr [ebp + 0x10]
            //   488d942450020000     | dec                 eax
            //   488d842450030000     | mov                 ecx, eax
            //   4989c8               | mov                 byte ptr [esi - 1], al
            //   4889c1               | dec                 eax
            //   e8????????           |                     

        $sequence_9 = { ba01000000 b9f1000000 e8???????? 488945f0 488b05???????? }
            // n = 5, score = 100
            //   ba01000000           | dec                 eax
            //   b9f1000000           | lea                 ecx, [esp + 0x42c]
            //   e8????????           |                     
            //   488945f0             | dec                 eax
            //   488b05????????       |                     

    condition:
        7 of them and filesize < 246784
}