rule win_edam_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.edam."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.edam"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c8ff eb1e 8b45fc 3bd6 8b0c8560b74500 0f95c0 02c0 }
            // n = 7, score = 100
            //   83c8ff               | or                  eax, 0xffffffff
            //   eb1e                 | jmp                 0x20
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   3bd6                 | cmp                 edx, esi
            //   8b0c8560b74500       | mov                 ecx, dword ptr [eax*4 + 0x45b760]
            //   0f95c0               | setne               al
            //   02c0                 | add                 al, al

        $sequence_1 = { 50 8d45b0 8955d8 50 e8???????? 8d45b0 50 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d45b0               | lea                 eax, [ebp - 0x50]
            //   8955d8               | mov                 dword ptr [ebp - 0x28], edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d45b0               | lea                 eax, [ebp - 0x50]
            //   50                   | push                eax

        $sequence_2 = { 8bc1 83e13f c1f806 6bc930 8b048560b74500 f644082801 7406 }
            // n = 7, score = 100
            //   8bc1                 | mov                 eax, ecx
            //   83e13f               | and                 ecx, 0x3f
            //   c1f806               | sar                 eax, 6
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8b048560b74500       | mov                 eax, dword ptr [eax*4 + 0x45b760]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7406                 | je                  8

        $sequence_3 = { 40 c745ec603c4200 894df8 8945fc 64a100000000 8945e8 }
            // n = 6, score = 100
            //   40                   | inc                 eax
            //   c745ec603c4200       | mov                 dword ptr [ebp - 0x14], 0x423c60
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_4 = { 8bd1 8b42e8 8d72e8 8b4004 c74410e818654400 8b06 8b4804 }
            // n = 7, score = 100
            //   8bd1                 | mov                 edx, ecx
            //   8b42e8               | mov                 eax, dword ptr [edx - 0x18]
            //   8d72e8               | lea                 esi, [edx - 0x18]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   c74410e818654400     | mov                 dword ptr [eax + edx - 0x18], 0x446518
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]

        $sequence_5 = { 50 6a01 8d4dd4 e8???????? 68???????? 8d45d4 c745d4c0634400 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   6a01                 | push                1
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   e8????????           |                     
            //   68????????           |                     
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   c745d4c0634400       | mov                 dword ptr [ebp - 0x2c], 0x4463c0

        $sequence_6 = { 8b45f0 894df4 8b048560b74500 c644022a0a 0f8484000000 }
            // n = 5, score = 100
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   8b048560b74500       | mov                 eax, dword ptr [eax*4 + 0x45b760]
            //   c644022a0a           | mov                 byte ptr [edx + eax + 0x2a], 0xa
            //   0f8484000000         | je                  0x8a

        $sequence_7 = { 8d8d08fdffff c785b4fdffff0f000000 c785b0fdffff00000000 c685a0fdffff00 e8???????? 8b859cfdffff }
            // n = 6, score = 100
            //   8d8d08fdffff         | lea                 ecx, [ebp - 0x2f8]
            //   c785b4fdffff0f000000     | mov    dword ptr [ebp - 0x24c], 0xf
            //   c785b0fdffff00000000     | mov    dword ptr [ebp - 0x250], 0
            //   c685a0fdffff00       | mov                 byte ptr [ebp - 0x260], 0
            //   e8????????           |                     
            //   8b859cfdffff         | mov                 eax, dword ptr [ebp - 0x264]

        $sequence_8 = { 6a55 ff34f5788a4400 ff7508 e8???????? 83c40c 85c0 }
            // n = 6, score = 100
            //   6a55                 | push                0x55
            //   ff34f5788a4400       | push                dword ptr [esi*8 + 0x448a78]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax

        $sequence_9 = { 3bc6 7353 807d8600 8a88a87c4400 8b857cffffff 8808 }
            // n = 6, score = 100
            //   3bc6                 | cmp                 eax, esi
            //   7353                 | jae                 0x55
            //   807d8600             | cmp                 byte ptr [ebp - 0x7a], 0
            //   8a88a87c4400         | mov                 cl, byte ptr [eax + 0x447ca8]
            //   8b857cffffff         | mov                 eax, dword ptr [ebp - 0x84]
            //   8808                 | mov                 byte ptr [eax], cl

    condition:
        7 of them and filesize < 807936
}