rule win_electric_powder_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.electric_powder."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.electric_powder"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 0f84b6130000 8d8de0fbffff 8d5720 8d7102 668b01 83c102 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f84b6130000         | je                  0x13bc
            //   8d8de0fbffff         | lea                 ecx, [ebp - 0x420]
            //   8d5720               | lea                 edx, [edi + 0x20]
            //   8d7102               | lea                 esi, [ecx + 2]
            //   668b01               | mov                 ax, word ptr [ecx]
            //   83c102               | add                 ecx, 2

        $sequence_1 = { 8d8d68faffff e9???????? 8d8d5cf9ffff e9???????? 8d8df8faffff e9???????? 8b857cf9ffff }
            // n = 7, score = 100
            //   8d8d68faffff         | lea                 ecx, [ebp - 0x598]
            //   e9????????           |                     
            //   8d8d5cf9ffff         | lea                 ecx, [ebp - 0x6a4]
            //   e9????????           |                     
            //   8d8df8faffff         | lea                 ecx, [ebp - 0x508]
            //   e9????????           |                     
            //   8b857cf9ffff         | mov                 eax, dword ptr [ebp - 0x684]

        $sequence_2 = { 3bd8 0f42d8 8d4301 85c0 7504 33f6 eb34 }
            // n = 7, score = 100
            //   3bd8                 | cmp                 ebx, eax
            //   0f42d8               | cmovb               ebx, eax
            //   8d4301               | lea                 eax, [ebx + 1]
            //   85c0                 | test                eax, eax
            //   7504                 | jne                 6
            //   33f6                 | xor                 esi, esi
            //   eb34                 | jmp                 0x36

        $sequence_3 = { 8b35???????? 81c230750000 89b574f9ffff 52 ffd6 68???????? 6a01 }
            // n = 7, score = 100
            //   8b35????????         |                     
            //   81c230750000         | add                 edx, 0x7530
            //   89b574f9ffff         | mov                 dword ptr [ebp - 0x68c], esi
            //   52                   | push                edx
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   6a01                 | push                1

        $sequence_4 = { 3b4e08 0f838e010000 8b4604 c704c810000000 8b5608 83ea01 }
            // n = 6, score = 100
            //   3b4e08               | cmp                 ecx, dword ptr [esi + 8]
            //   0f838e010000         | jae                 0x194
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   c704c810000000       | mov                 dword ptr [eax + ecx*8], 0x10
            //   8b5608               | mov                 edx, dword ptr [esi + 8]
            //   83ea01               | sub                 edx, 1

        $sequence_5 = { 0f4dd0 7ce7 56 8d7207 83e6f8 3bd6 }
            // n = 6, score = 100
            //   0f4dd0               | cmovge              edx, eax
            //   7ce7                 | jl                  0xffffffe9
            //   56                   | push                esi
            //   8d7207               | lea                 esi, [edx + 7]
            //   83e6f8               | and                 esi, 0xfffffff8
            //   3bd6                 | cmp                 edx, esi

        $sequence_6 = { c645fc79 e8???????? c785e0fbffff00000000 81cf00010000 c785e4fbffff00000000 }
            // n = 5, score = 100
            //   c645fc79             | mov                 byte ptr [ebp - 4], 0x79
            //   e8????????           |                     
            //   c785e0fbffff00000000     | mov    dword ptr [ebp - 0x420], 0
            //   81cf00010000         | or                  edi, 0x100
            //   c785e4fbffff00000000     | mov    dword ptr [ebp - 0x41c], 0

        $sequence_7 = { c60600 8d8d30fcffff e8???????? 8d8520fdffff ba???????? 50 8d8da0fbffff }
            // n = 7, score = 100
            //   c60600               | mov                 byte ptr [esi], 0
            //   8d8d30fcffff         | lea                 ecx, [ebp - 0x3d0]
            //   e8????????           |                     
            //   8d8520fdffff         | lea                 eax, [ebp - 0x2e0]
            //   ba????????           |                     
            //   50                   | push                eax
            //   8d8da0fbffff         | lea                 ecx, [ebp - 0x460]

        $sequence_8 = { 8947fc eb0b 50 e8???????? 83c404 8bf8 8b4dfc }
            // n = 7, score = 100
            //   8947fc               | mov                 dword ptr [edi - 4], eax
            //   eb0b                 | jmp                 0xd
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8bf8                 | mov                 edi, eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_9 = { 8bf0 e9???????? 8b45f8 46 8b541004 8955ec 3bf2 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   e9????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   46                   | inc                 esi
            //   8b541004             | mov                 edx, dword ptr [eax + edx + 4]
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   3bf2                 | cmp                 esi, edx

    condition:
        7 of them and filesize < 565248
}