rule win_electricfish_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.electricfish."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.electricfish"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb08 56 57 53 ffd0 83c40c 3bc6 }
            // n = 7, score = 1200
            //   eb08                 | jmp                 0xa
            //   56                   | push                esi
            //   57                   | push                edi
            //   53                   | push                ebx
            //   ffd0                 | call                eax
            //   83c40c               | add                 esp, 0xc
            //   3bc6                 | cmp                 eax, esi

        $sequence_1 = { e8???????? 8bf8 85ff 75e0 6891010000 68???????? 6a41 }
            // n = 7, score = 1200
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   75e0                 | jne                 0xffffffe2
            //   6891010000           | push                0x191
            //   68????????           |                     
            //   6a41                 | push                0x41

        $sequence_2 = { eb3a 0fb67201 81e680000000 b901000000 3bc6 75c4 68ae000000 }
            // n = 7, score = 1200
            //   eb3a                 | jmp                 0x3c
            //   0fb67201             | movzx               esi, byte ptr [edx + 1]
            //   81e680000000         | and                 esi, 0x80
            //   b901000000           | mov                 ecx, 1
            //   3bc6                 | cmp                 eax, esi
            //   75c4                 | jne                 0xffffffc6
            //   68ae000000           | push                0xae

        $sequence_3 = { 39442458 7413 6852020000 68???????? 50 e8???????? 83c40c }
            // n = 7, score = 1200
            //   39442458             | cmp                 dword ptr [esp + 0x58], eax
            //   7413                 | je                  0x15
            //   6852020000           | push                0x252
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_4 = { c3 837f1006 7414 689a010000 68???????? 6892000000 e9???????? }
            // n = 7, score = 1200
            //   c3                   | ret                 
            //   837f1006             | cmp                 dword ptr [edi + 0x10], 6
            //   7414                 | je                  0x16
            //   689a010000           | push                0x19a
            //   68????????           |                     
            //   6892000000           | push                0x92
            //   e9????????           |                     

        $sequence_5 = { 33c0 c745fc02000000 8945e8 8945ec 8d45e8 6a08 50 }
            // n = 7, score = 1200
            //   33c0                 | xor                 eax, eax
            //   c745fc02000000       | mov                 dword ptr [ebp - 4], 2
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   6a08                 | push                8
            //   50                   | push                eax

        $sequence_6 = { f6423401 7508 c744241401000000 8b834c010000 85c0 0f8426010000 3bf8 }
            // n = 7, score = 1200
            //   f6423401             | test                byte ptr [edx + 0x34], 1
            //   7508                 | jne                 0xa
            //   c744241401000000     | mov                 dword ptr [esp + 0x14], 1
            //   8b834c010000         | mov                 eax, dword ptr [ebx + 0x14c]
            //   85c0                 | test                eax, eax
            //   0f8426010000         | je                  0x12c
            //   3bf8                 | cmp                 edi, eax

        $sequence_7 = { 85ed 7518 6874010000 68???????? 6a41 6a7d 6a0b }
            // n = 7, score = 1200
            //   85ed                 | test                ebp, ebp
            //   7518                 | jne                 0x1a
            //   6874010000           | push                0x174
            //   68????????           |                     
            //   6a41                 | push                0x41
            //   6a7d                 | push                0x7d
            //   6a0b                 | push                0xb

        $sequence_8 = { e8???????? 83c40c 85c0 0f84bb040000 6a01 53 c7430c00000000 }
            // n = 7, score = 1200
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   0f84bb040000         | je                  0x4c1
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   c7430c00000000       | mov                 dword ptr [ebx + 0xc], 0

        $sequence_9 = { 85ff 0f8522010000 e8???????? 5f 5e 5d }
            // n = 6, score = 1200
            //   85ff                 | test                edi, edi
            //   0f8522010000         | jne                 0x128
            //   e8????????           |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

    condition:
        7 of them and filesize < 3162112
}