rule win_elirks_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.elirks."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.elirks"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894608 5f 5e 81c40c020000 c3 }
            // n = 5, score = 100
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   81c40c020000         | add                 esp, 0x20c
            //   c3                   | ret                 

        $sequence_1 = { 0f848b010000 8b742414 8b15???????? 6a00 8d442440 50 }
            // n = 6, score = 100
            //   0f848b010000         | je                  0x191
            //   8b742414             | mov                 esi, dword ptr [esp + 0x14]
            //   8b15????????         |                     
            //   6a00                 | push                0
            //   8d442440             | lea                 eax, [esp + 0x40]
            //   50                   | push                eax

        $sequence_2 = { 56 8d7e08 57 8d442420 50 8d4c241c 51 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8d7e08               | lea                 edi, [esi + 8]
            //   57                   | push                edi
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   50                   | push                eax
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   51                   | push                ecx

        $sequence_3 = { 52 8d5104 83c0ff 52 }
            // n = 4, score = 100
            //   52                   | push                edx
            //   8d5104               | lea                 edx, [ecx + 4]
            //   83c0ff               | add                 eax, -1
            //   52                   | push                edx

        $sequence_4 = { 8d4c2414 51 8bd1 52 ff15???????? f605????????02 742c }
            // n = 7, score = 100
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   51                   | push                ecx
            //   8bd1                 | mov                 edx, ecx
            //   52                   | push                edx
            //   ff15????????         |                     
            //   f605????????02       |                     
            //   742c                 | je                  0x2e

        $sequence_5 = { 52 6a00 8bc3 e8???????? 85c0 7515 }
            // n = 6, score = 100
            //   52                   | push                edx
            //   6a00                 | push                0
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7515                 | jne                 0x17

        $sequence_6 = { 6a0c 50 b908000000 8bc7 e8???????? 8bf0 83c408 }
            // n = 7, score = 100
            //   6a0c                 | push                0xc
            //   50                   | push                eax
            //   b908000000           | mov                 ecx, 8
            //   8bc7                 | mov                 eax, edi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c408               | add                 esp, 8

        $sequence_7 = { 0f8592000000 f605????????08 a1???????? 53 8b1d???????? }
            // n = 5, score = 100
            //   0f8592000000         | jne                 0x98
            //   f605????????08       |                     
            //   a1????????           |                     
            //   53                   | push                ebx
            //   8b1d????????         |                     

        $sequence_8 = { 8b1d???????? 8b2d???????? 8b8120c20000 6aff 50 }
            // n = 5, score = 100
            //   8b1d????????         |                     
            //   8b2d????????         |                     
            //   8b8120c20000         | mov                 eax, dword ptr [ecx + 0xc220]
            //   6aff                 | push                -1
            //   50                   | push                eax

        $sequence_9 = { e8???????? 85c0 7414 8b44241c 8d542410 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7414                 | je                  0x16
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   8d542410             | lea                 edx, [esp + 0x10]

    condition:
        7 of them and filesize < 81920
}