rule win_elise_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.elise."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.elise"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 1bc0 83e0fe 83c00b 8945f8 8b45f4 40 50 }
            // n = 7, score = 400
            //   1bc0                 | sbb                 eax, eax
            //   83e0fe               | and                 eax, 0xfffffffe
            //   83c00b               | add                 eax, 0xb
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   40                   | inc                 eax
            //   50                   | push                eax

        $sequence_1 = { 4b 8d3470 75ed 5b }
            // n = 4, score = 400
            //   4b                   | dec                 ebx
            //   8d3470               | lea                 esi, [eax + esi*2]
            //   75ed                 | jne                 0xffffffef
            //   5b                   | pop                 ebx

        $sequence_2 = { ab 75d2 5f 5e 5b c3 }
            // n = 6, score = 400
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   75d2                 | jne                 0xffffffd4
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c3                   | ret                 

        $sequence_3 = { 7cf5 33c9 888f00010000 888f01010000 }
            // n = 4, score = 400
            //   7cf5                 | jl                  0xfffffff7
            //   33c9                 | xor                 ecx, ecx
            //   888f00010000         | mov                 byte ptr [edi + 0x100], cl
            //   888f01010000         | mov                 byte ptr [edi + 0x101], cl

        $sequence_4 = { 8b491c 83c60c 83c110 8945fc }
            // n = 4, score = 400
            //   8b491c               | mov                 ecx, dword ptr [ecx + 0x1c]
            //   83c60c               | add                 esi, 0xc
            //   83c110               | add                 ecx, 0x10
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_5 = { 8d1c58 d3e0 0945f4 ff45f8 }
            // n = 4, score = 400
            //   8d1c58               | lea                 ebx, [eax + ebx*2]
            //   d3e0                 | shl                 eax, cl
            //   0945f4               | or                  dword ptr [ebp - 0xc], eax
            //   ff45f8               | inc                 dword ptr [ebp - 8]

        $sequence_6 = { c3 55 8bec 51 51 53 8d5f10 }
            // n = 7, score = 400
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   8d5f10               | lea                 ebx, [edi + 0x10]

        $sequence_7 = { 888f00010000 888f01010000 8bf7 8945f8 }
            // n = 4, score = 400
            //   888f00010000         | mov                 byte ptr [edi + 0x100], cl
            //   888f01010000         | mov                 byte ptr [edi + 0x101], cl
            //   8bf7                 | mov                 esi, edi
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_8 = { 57 6a22 50 894608 ff15???????? }
            // n = 5, score = 400
            //   57                   | push                edi
            //   6a22                 | push                0x22
            //   50                   | push                eax
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   ff15????????         |                     

        $sequence_9 = { 034e3c b800030000 d3e0 33c9 6a02 }
            // n = 5, score = 400
            //   034e3c               | add                 ecx, dword ptr [esi + 0x3c]
            //   b800030000           | mov                 eax, 0x300
            //   d3e0                 | shl                 eax, cl
            //   33c9                 | xor                 ecx, ecx
            //   6a02                 | push                2

        $sequence_10 = { 56 57 b99a000000 8d7510 }
            // n = 4, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   b99a000000           | mov                 ecx, 0x9a
            //   8d7510               | lea                 esi, [ebp + 0x10]

        $sequence_11 = { e8???????? 83c40c 8d4580 50 8d4588 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d4580               | lea                 eax, [ebp - 0x80]
            //   50                   | push                eax
            //   8d4588               | lea                 eax, [ebp - 0x78]

        $sequence_12 = { 33c0 e9???????? 833d????????00 7405 e8???????? 83c8ff }
            // n = 6, score = 300
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   833d????????00       |                     
            //   7405                 | je                  7
            //   e8????????           |                     
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_13 = { ff75ec 0fb6843794010000 99 53 52 50 }
            // n = 6, score = 300
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   0fb6843794010000     | movzx               eax, byte ptr [edi + esi + 0x194]
            //   99                   | cdq                 
            //   53                   | push                ebx
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_14 = { 0145f0 6a00 6800010000 ff75ec 1155f4 53 }
            // n = 6, score = 300
            //   0145f0               | add                 dword ptr [ebp - 0x10], eax
            //   6a00                 | push                0
            //   6800010000           | push                0x100
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   1155f4               | adc                 dword ptr [ebp - 0xc], edx
            //   53                   | push                ebx

        $sequence_15 = { 5b 85ff 7415 0fb616 33d0 23d1 c1e808 }
            // n = 7, score = 300
            //   5b                   | pop                 ebx
            //   85ff                 | test                edi, edi
            //   7415                 | je                  0x17
            //   0fb616               | movzx               edx, byte ptr [esi]
            //   33d0                 | xor                 edx, eax
            //   23d1                 | and                 edx, ecx
            //   c1e808               | shr                 eax, 8

        $sequence_16 = { 50 ff7580 e8???????? 85c0 }
            // n = 4, score = 300
            //   50                   | push                eax
            //   ff7580               | push                dword ptr [ebp - 0x80]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_17 = { 6a20 e8???????? 59 8bd8 }
            // n = 4, score = 300
            //   6a20                 | push                0x20
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8bd8                 | mov                 ebx, eax

        $sequence_18 = { 59 59 33c0 e9???????? 8b35???????? 6a04 }
            // n = 6, score = 300
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   8b35????????         |                     
            //   6a04                 | push                4

        $sequence_19 = { 8bd7 c1ea03 53 0fb61e 33d8 23d9 c1e808 }
            // n = 7, score = 300
            //   8bd7                 | mov                 edx, edi
            //   c1ea03               | shr                 edx, 3
            //   53                   | push                ebx
            //   0fb61e               | movzx               ebx, byte ptr [esi]
            //   33d8                 | xor                 ebx, eax
            //   23d9                 | and                 ebx, ecx
            //   c1e808               | shr                 eax, 8

    condition:
        7 of them and filesize < 204800
}