rule win_emdivi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.emdivi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.emdivi"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1e304 83e203 3355f8 33fb }
            // n = 4, score = 300
            //   c1e304               | shl                 ebx, 4
            //   83e203               | and                 edx, 3
            //   3355f8               | xor                 edx, dword ptr [ebp - 8]
            //   33fb                 | xor                 edi, ebx

        $sequence_1 = { e8???????? ff75ec 8ad8 c0fb02 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   8ad8                 | mov                 bl, al
            //   c0fb02               | sar                 bl, 2

        $sequence_2 = { e8???????? c3 beff010000 56 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   c3                   | ret                 
            //   beff010000           | mov                 esi, 0x1ff
            //   56                   | push                esi

        $sequence_3 = { e8???????? 0ad8 59 881f }
            // n = 4, score = 300
            //   e8????????           |                     
            //   0ad8                 | or                  bl, al
            //   59                   | pop                 ecx
            //   881f                 | mov                 byte ptr [edi], bl

        $sequence_4 = { e8???????? 99 2bf7 f7fe 8bc2 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   99                   | cdq                 
            //   2bf7                 | sub                 esi, edi
            //   f7fe                 | idiv                esi
            //   8bc2                 | mov                 eax, edx

        $sequence_5 = { 0f8785000000 8a45ff c0fb04 c0e002 0ad8 881f }
            // n = 6, score = 300
            //   0f8785000000         | ja                  0x8b
            //   8a45ff               | mov                 al, byte ptr [ebp - 1]
            //   c0fb04               | sar                 bl, 4
            //   c0e002               | shl                 al, 2
            //   0ad8                 | or                  bl, al
            //   881f                 | mov                 byte ptr [edi], bl

        $sequence_6 = { f7fb 5b 6a07 03f8 8bc1 }
            // n = 5, score = 300
            //   f7fb                 | idiv                ebx
            //   5b                   | pop                 ebx
            //   6a07                 | push                7
            //   03f8                 | add                 edi, eax
            //   8bc1                 | mov                 eax, ecx

        $sequence_7 = { e8???????? 8bd8 8bc6 59 c6432000 8d7801 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   8bc6                 | mov                 eax, esi
            //   59                   | pop                 ecx
            //   c6432000             | mov                 byte ptr [ebx + 0x20], 0
            //   8d7801               | lea                 edi, [eax + 1]

        $sequence_8 = { 83ec10 8bfc 8db5f4f2ffff a5 a5 a5 }
            // n = 6, score = 300
            //   83ec10               | sub                 esp, 0x10
            //   8bfc                 | mov                 edi, esp
            //   8db5f4f2ffff         | lea                 esi, [ebp - 0xd0c]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]

        $sequence_9 = { 385d08 7513 53 53 6a01 53 53 }
            // n = 7, score = 300
            //   385d08               | cmp                 byte ptr [ebp + 8], bl
            //   7513                 | jne                 0x15
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 581632
}