rule win_emotet_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.emotet."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.emotet"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3c41 7c04 3c5a 7e03 c60158 }
            // n = 5, score = 2900
            //   3c41                 | cmp                 al, 0x41
            //   7c04                 | jl                  6
            //   3c5a                 | cmp                 al, 0x5a
            //   7e03                 | jle                 5
            //   c60158               | mov                 byte ptr [ecx], 0x58

        $sequence_1 = { 3c61 7c04 3c7a 7e0b 3c41 }
            // n = 5, score = 2900
            //   3c61                 | cmp                 al, 0x61
            //   7c04                 | jl                  6
            //   3c7a                 | cmp                 al, 0x7a
            //   7e0b                 | jle                 0xd
            //   3c41                 | cmp                 al, 0x41

        $sequence_2 = { 8a01 3c30 7c04 3c39 7e13 3c61 }
            // n = 6, score = 2900
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   3c30                 | cmp                 al, 0x30
            //   7c04                 | jl                  6
            //   3c39                 | cmp                 al, 0x39
            //   7e13                 | jle                 0x15
            //   3c61                 | cmp                 al, 0x61

        $sequence_3 = { 7e03 c60158 41 803900 }
            // n = 4, score = 2400
            //   7e03                 | jle                 5
            //   c60158               | mov                 byte ptr [ecx], 0x58
            //   41                   | inc                 ecx
            //   803900               | cmp                 byte ptr [ecx], 0

        $sequence_4 = { 3903 5f 5e 0f95c0 5b 8be5 }
            // n = 6, score = 2400
            //   3903                 | cmp                 dword ptr [ebx], eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   0f95c0               | setne               al
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp

        $sequence_5 = { 83c020 eb03 0fb7c0 69d23f000100 }
            // n = 4, score = 2300
            //   83c020               | add                 eax, 0x20
            //   eb03                 | jmp                 5
            //   0fb7c0               | movzx               eax, ax
            //   69d23f000100         | imul                edx, edx, 0x1003f

        $sequence_6 = { 880a 8bc1 c1e808 8d5204 }
            // n = 4, score = 2100
            //   880a                 | cmp                 al, 0x39
            //   8bc1                 | jle                 0x17
            //   c1e808               | cmp                 al, 0x61
            //   8d5204               | jl                  0xc

        $sequence_7 = { c1e910 8842fd 884afe c1e908 }
            // n = 4, score = 2100
            //   c1e910               | cmp                 al, 0x7a
            //   8842fd               | jle                 0xd
            //   884afe               | cmp                 al, 0x41
            //   c1e908               | jl                  6

        $sequence_8 = { 75f2 eb06 33c9 66894802 }
            // n = 4, score = 2100
            //   75f2                 | xor                 ecx, ecx
            //   eb06                 | mov                 word ptr [eax + 2], cx
            //   33c9                 | jl                  6
            //   66894802             | cmp                 al, 0x7a

        $sequence_9 = { c1e808 8d5204 c1e910 8842fd }
            // n = 4, score = 2100
            //   c1e808               | mov                 byte ptr [ecx], 0x58
            //   8d5204               | inc                 ecx
            //   c1e910               | cmp                 al, 0x30
            //   8842fd               | jl                  8

        $sequence_10 = { 8d5801 f6c30f 7406 83e3f0 }
            // n = 4, score = 2000
            //   8d5801               | lea                 ebx, [eax + 1]
            //   f6c30f               | test                bl, 0xf
            //   7406                 | je                  8
            //   83e3f0               | and                 ebx, 0xfffffff0

        $sequence_11 = { 8b16 8945fc 8d45f8 6a04 }
            // n = 4, score = 1900
            //   8b16                 | cmp                 eax, 0x7f
            //   8945fc               | push                eax
            //   8d45f8               | push                0
            //   6a04                 | push                1

        $sequence_12 = { 0faf4510 50 6a08 ff15???????? }
            // n = 4, score = 1900
            //   0faf4510             | push                0xf0000040
            //   50                   | push                0x18
            //   6a08                 | xor                 esi, esi
            //   ff15????????         |                     

        $sequence_13 = { 8901 8b477c 85c0 7448 }
            // n = 4, score = 1900
            //   8901                 | push                0
            //   8b477c               | push                0
            //   85c0                 | push                -1
            //   7448                 | push                eax

        $sequence_14 = { 8b4508 894dcc 8d4dc8 8945c8 8975d4 }
            // n = 5, score = 1900
            //   8b4508               | push                esi
            //   894dcc               | sub                 esp, 8
            //   8d4dc8               | push                esi
            //   8945c8               | push                0xf0000040
            //   8975d4               | push                0x18

        $sequence_15 = { 7448 8b00 2b878c000000 56 }
            // n = 4, score = 1900
            //   7448                 | je                  0x4a
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   2b878c000000         | sub                 eax, dword ptr [edi + 0x8c]
            //   56                   | push                esi

        $sequence_16 = { 894630 8b45f8 01460c 294610 }
            // n = 4, score = 1900
            //   894630               | cmp                 eax, 0x7f
            //   8b45f8               | jbe                 0xe
            //   01460c               | shr                 eax, 7
            //   294610               | inc                 ecx

        $sequence_17 = { 50 8d45f8 81ca00000020 50 52 }
            // n = 5, score = 1800
            //   50                   | jle                 7
            //   8d45f8               | mov                 byte ptr [ecx], 0x58
            //   81ca00000020         | inc                 ecx
            //   50                   | cmp                 al, 0x30
            //   52                   | jl                  8

        $sequence_18 = { 48894808 48895010 4c894018 4c894820 c3 }
            // n = 5, score = 1700
            //   48894808             | shr                 cx, 8
            //   48895010             | inc                 ecx
            //   4c894018             | mov                 byte ptr [eax - 1], cl
            //   4c894820             | dec                 ebp
            //   c3                   | cmp                 ebx, ecx

        $sequence_19 = { 488bd3 488bcf 488b5c2460 4883c450 }
            // n = 4, score = 1700
            //   488bd3               | cmp                 ebx, ecx
            //   488bcf               | dec                 ebp
            //   488b5c2460           | lea                 eax, [eax + 4]
            //   4883c450             | inc                 ecx

        $sequence_20 = { 0fb7c1 c1e910 66c1e808 4d8d4004 }
            // n = 4, score = 1700
            //   0fb7c1               | movzx               eax, cx
            //   c1e910               | shr                 ecx, 0x10
            //   66c1e808             | shr                 ax, 8
            //   4d8d4004             | dec                 ebp

        $sequence_21 = { 418bd0 d3e2 418bcb d3e0 03d0 }
            // n = 5, score = 1700
            //   418bd0               | dec                 eax
            //   d3e2                 | mov                 dword ptr [eax + 8], ecx
            //   418bcb               | dec                 eax
            //   d3e0                 | mov                 dword ptr [eax + 0x10], edx
            //   03d0                 | dec                 esp

        $sequence_22 = { d3e7 83f841 7208 83f85a }
            // n = 4, score = 1700
            //   d3e7                 | jl                  6
            //   83f841               | cmp                 al, 0x5a
            //   7208                 | jle                 9
            //   83f85a               | mov                 byte ptr [ecx], 0x58

        $sequence_23 = { 4803c8 eb08 803900 7408 }
            // n = 4, score = 1700
            //   4803c8               | inc                 ecx
            //   eb08                 | mov                 byte ptr [eax - 2], cl
            //   803900               | shr                 cx, 8
            //   7408                 | inc                 ecx

        $sequence_24 = { 2bca d1e9 03ca c1e906 894d18 }
            // n = 5, score = 1700
            //   2bca                 | lea                 eax, [eax + 4]
            //   d1e9                 | sub                 ecx, edx
            //   03ca                 | shr                 ecx, 1
            //   c1e906               | add                 ecx, edx
            //   894d18               | shr                 ecx, 6

        $sequence_25 = { 4d8d4004 418840fd 418848fe 66c1e908 418848ff 4d3bd9 72cf }
            // n = 7, score = 1700
            //   4d8d4004             | mov                 dword ptr [ebp + 0x18], ecx
            //   418840fd             | dec                 ebp
            //   418848fe             | lea                 eax, [eax + 4]
            //   66c1e908             | inc                 ecx
            //   418848ff             | mov                 byte ptr [eax - 3], al
            //   4d3bd9               | inc                 ecx
            //   72cf                 | mov                 byte ptr [eax - 2], cl

        $sequence_26 = { 483bd8 730b 488bcb e8???????? }
            // n = 4, score = 1700
            //   483bd8               | dec                 eax
            //   730b                 | dec                 ecx
            //   488bcb               | dec                 eax
            //   e8????????           |                     

        $sequence_27 = { c1e807 41 83f87f 77f7 }
            // n = 4, score = 1600
            //   c1e807               | movzx               ebx, al
            //   41                   | movzx               ebx, al
            //   83f87f               | movzx               eax, bl
            //   77f7                 | mov                 edi, eax

        $sequence_28 = { f7e1 b84fecc44e 2bca d1e9 }
            // n = 4, score = 1500
            //   f7e1                 | cmp                 al, 0x5a
            //   b84fecc44e           | cmp                 al, 0x7a
            //   2bca                 | jle                 0xf
            //   d1e9                 | cmp                 al, 0x41

        $sequence_29 = { 84c0 75f2 eb03 c60100 }
            // n = 4, score = 1500
            //   84c0                 | movzx               eax, bl
            //   75f2                 | cmp                 eax, 3
            //   eb03                 | je                  0xa
            //   c60100               | cmp                 eax, 2

        $sequence_30 = { 8bd3 8b0f e8???????? 85c0 }
            // n = 4, score = 1400
            //   8bd3                 | cmp                 al, 0x41
            //   8b0f                 | jl                  0xe
            //   e8????????           |                     
            //   85c0                 | cmp                 al, 0x5a

        $sequence_31 = { 83c104 894e04 8b00 85c0 }
            // n = 4, score = 1200
            //   83c104               | jle                 0x17
            //   894e04               | jl                  6
            //   8b00                 | cmp                 al, 0x39
            //   85c0                 | jle                 0x17

        $sequence_32 = { 7907 83c107 3bf7 72e8 }
            // n = 4, score = 1200
            //   7907                 | nop                 dword ptr [eax]
            //   83c107               | movzx               eax, byte ptr [esp + ecx + 0x130]
            //   3bf7                 | je                  0x40
            //   72e8                 | mov                 ebx, dword ptr [esp + 0x30]

        $sequence_33 = { 0fb6c0 668942fa c1e910 0fb6c1 }
            // n = 4, score = 1200
            //   0fb6c0               | jle                 0x17
            //   668942fa             | cmp                 al, 0x61
            //   c1e910               | jl                  0xc
            //   0fb6c1               | cmp                 al, 0x7a

        $sequence_34 = { 56 57 6a1e 8d45e0 }
            // n = 4, score = 1100
            //   56                   | push                0
            //   57                   | push                dword ptr [ebp - 4]
            //   6a1e                 | push                0x400
            //   8d45e0               | push                0

        $sequence_35 = { 52 52 52 52 68???????? 52 }
            // n = 6, score = 1100
            //   52                   | test                ebx, ebx
            //   52                   | je                  0x21
            //   52                   | mov                 ecx, esp
            //   52                   | mov                 edx, eax
            //   68????????           |                     
            //   52                   | mov                 dword ptr [esp + 0x20], ebx

        $sequence_36 = { 83ec48 53 56 57 6a44 }
            // n = 5, score = 1100
            //   83ec48               | xor                 eax, eax
            //   53                   | cmp                 dword ptr [ebx], eax
            //   56                   | pop                 edi
            //   57                   | pop                 esi
            //   6a44                 | setne               al

        $sequence_37 = { 83f87f 760d 8d642400 c1e807 }
            // n = 4, score = 1000
            //   83f87f               | ja                  0x48
            //   760d                 | movzx               esi, byte ptr [esi + 0x1e64320]
            //   8d642400             | jmp                 dword ptr [esi*4 + 0x1e64304]
            //   c1e807               | mov                 byte ptr [eax + 1], cl

        $sequence_38 = { 83f87f 7609 c1e807 41 }
            // n = 4, score = 900
            //   83f87f               | lea                 edx, [0x251f]
            //   7609                 | mov                 dword ptr [esp + 0x28], eax
            //   c1e807               | inc                 ecx
            //   41                   | mov                 ecx, 1

        $sequence_39 = { 50 6a00 6a01 6a00 ff15???????? a3???????? }
            // n = 6, score = 800
            //   50                   | xor                 ecx, ecx
            //   6a00                 | nop                 dword ptr [eax]
            //   6a01                 | movzx               eax, byte ptr [esp + ecx + 0x130]
            //   6a00                 | je                  0x4d
            //   ff15????????         |                     
            //   a3????????           |                     

        $sequence_40 = { 6a00 6aff 50 51 ff15???????? }
            // n = 5, score = 800
            //   6a00                 | dec                 eax
            //   6aff                 | lea                 edx, [0x3f58]
            //   50                   | dec                 eax
            //   51                   | mov                 ecx, eax
            //   ff15????????         |                     

        $sequence_41 = { 50 6a00 ff75fc 6800040000 }
            // n = 4, score = 600
            //   50                   | cmp                 dword ptr [ebx], eax
            //   6a00                 | pop                 edi
            //   ff75fc               | pop                 esi
            //   6800040000           | setne               al

        $sequence_42 = { 50 56 6800800000 6a6a }
            // n = 4, score = 600
            //   50                   | movzx               eax, ax
            //   56                   | add                 eax, 0x20
            //   6800800000           | jmp                 0xb
            //   6a6a                 | movzx               eax, ax

        $sequence_43 = { 53 56 8bf1 bb00c34c84 }
            // n = 4, score = 600
            //   53                   | pop                 ebx
            //   56                   | mov                 esp, ebp
            //   8bf1                 | cmp                 dword ptr [ebx], eax
            //   bb00c34c84           | pop                 edi

        $sequence_44 = { 83ec08 56 68400000f0 6a18 33f6 56 56 }
            // n = 7, score = 600
            //   83ec08               | pop                 ebx
            //   56                   | mov                 esp, ebp
            //   68400000f0           | xor                 eax, eax
            //   6a18                 | cmp                 dword ptr [ebx], eax
            //   33f6                 | pop                 edi
            //   56                   | pop                 esi
            //   56                   | setne               al

        $sequence_45 = { ff75fc 6800040000 6a00 6a00 6a00 }
            // n = 5, score = 600
            //   ff75fc               | mov                 dword ptr [esp + 0xc], edx
            //   6800040000           | lea                 ecx, [0xd83122]
            //   6a00                 | mov                 dword ptr [esp], eax
            //   6a00                 | mov                 dword ptr [esp + 4], ecx
            //   6a00                 | mov                 ecx, dword ptr [esp + 0x2c]

        $sequence_46 = { 8bec 83ec08 56 57 8bf1 33ff }
            // n = 6, score = 500
            //   8bec                 | movzx               eax, ax
            //   83ec08               | imul                edx, edx, 0x1003f
            //   56                   | movzx               eax, ax
            //   57                   | add                 eax, 0x20
            //   8bf1                 | jmp                 5
            //   33ff                 | movzx               eax, ax

        $sequence_47 = { 83ec10 53 6a00 8d45fc }
            // n = 4, score = 500
            //   83ec10               | movzx               eax, ax
            //   53                   | imul                edx, edx, 0x1003f
            //   6a00                 | mov                 dword ptr [ecx], eax
            //   8d45fc               | cmp                 edx, 0x7f

        $sequence_48 = { 8bf1 bb00c34c84 57 33ff }
            // n = 4, score = 500
            //   8bf1                 | mov                 ebx, eax
            //   bb00c34c84           | add                 ebx, 0x3c
            //   57                   | xor                 esi, esi
            //   33ff                 | mov                 dword ptr [edx + 0xc], esi

        $sequence_49 = { 8b7d08 83fe00 8945f0 894dec 8955e8 8975e4 }
            // n = 6, score = 500
            //   8b7d08               | jle                 0xf
            //   83fe00               | cmp                 al, 0x41
            //   8945f0               | jl                  0xc
            //   894dec               | cmp                 al, 0x5a
            //   8955e8               | cmp                 al, 0x7a
            //   8975e4               | jle                 0xd

        $sequence_50 = { 6a03 6a00 6a00 ff7508 53 50 }
            // n = 6, score = 500
            //   6a03                 | ja                  0xffffffed
            //   6a00                 | pop                 esi
            //   6a00                 | mov                 eax, dword ptr [ecx]
            //   ff7508               | and                 dl, 0x7f
            //   53                   | mov                 esi, dword ptr [eax + 0x20]
            //   50                   | mov                 edi, dword ptr [eax + 0x40]

        $sequence_51 = { 56 57 00b807000000 008b45fc33d2 00b871800780 00558b ec }
            // n = 7, score = 500
            //   56                   | jl                  8
            //   57                   | cmp                 al, 0x5a
            //   00b807000000         | jle                 0xb
            //   008b45fc33d2         | mov                 byte ptr [ecx], 0x58
            //   00b871800780         | inc                 ecx
            //   00558b               | jl                  6
            //   ec                   | cmp                 al, 0x7a

        $sequence_52 = { 8b55f4 01ca 89d6 83c60c 8b7df4 8b4c0f0c 83f900 }
            // n = 7, score = 500
            //   8b55f4               | jle                 0x11
            //   01ca                 | cmp                 al, 0x41
            //   89d6                 | cmp                 al, 0x7a
            //   83c60c               | jle                 0xd
            //   8b7df4               | cmp                 al, 0x41
            //   8b4c0f0c             | jl                  0xa
            //   83f900               | cmp                 al, 0x39

        $sequence_53 = { 56 8b4510 8b4d0c 8b5508 befbffffff c600e8 }
            // n = 6, score = 500
            //   56                   | sub                 esp, 0x44
            //   8b4510               | mov                 eax, dword ptr [esp + 0x54]
            //   8b4d0c               | lea                 ecx, [0xd83058]
            //   8b5508               | mov                 eax, dword ptr [esp + 0x8c]
            //   befbffffff           | movsd               xmm0, qword ptr [esp + 0x90]
            //   c600e8               | xor                 ecx, ecx

        $sequence_54 = { 51 8d4df8 51 ff75f8 50 6a03 }
            // n = 6, score = 500
            //   51                   | lea                 ebx, [eax + 1]
            //   8d4df8               | test                bl, 0xf
            //   51                   | je                  8
            //   ff75f8               | and                 ebx, 0xfffffff0
            //   50                   | add                 ebx, 0x10
            //   6a03                 | lea                 ebx, [eax + 1]

        $sequence_55 = { 39c7 0f97c7 08fb f6c301 89f0 8945a4 }
            // n = 6, score = 500
            //   39c7                 | cmp                 al, 0x41
            //   0f97c7               | jl                  0xa
            //   08fb                 | cmp                 al, 0x5a
            //   f6c301               | jl                  6
            //   89f0                 | cmp                 al, 0x7a
            //   8945a4               | jle                 0xf

        $sequence_56 = { 8b466c 5f 5e 5b 8be5 5d }
            // n = 6, score = 500
            //   8b466c               | pop                 esi
            //   5f                   | setne               al
            //   5e                   | pop                 ebx
            //   5b                   | mov                 esp, ebp
            //   8be5                 | add                 eax, 0x20
            //   5d                   | jmp                 8

        $sequence_57 = { 8b7020 8b7840 89c3 83c33c }
            // n = 4, score = 300
            //   8b7020               | inc                 ecx
            //   8b7840               | mov                 ecx, ebx
            //   89c3                 | shl                 eax, cl
            //   83c33c               | shr                 ax, 8

        $sequence_58 = { 31f6 89720c 897208 897204 }
            // n = 4, score = 200
            //   31f6                 | dec                 ebp
            //   89720c               | lea                 eax, [eax + 4]
            //   897208               | inc                 ecx
            //   897204               | mov                 byte ptr [eax - 3], al

        $sequence_59 = { 7519 33c9 0f1f4000 0fb6840c30010000 }
            // n = 4, score = 200
            //   7519                 | mov                 byte ptr [eax - 3], al
            //   33c9                 | inc                 ecx
            //   0f1f4000             | mov                 byte ptr [eax - 2], cl
            //   0fb6840c30010000     | shr                 cx, 8

        $sequence_60 = { ff15???????? 83f803 7405 83f802 751e }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   83f803               | mov                 byte ptr [eax - 3], al
            //   7405                 | inc                 ecx
            //   83f802               | mov                 byte ptr [eax - 2], cl
            //   751e                 | shr                 cx, 8

        $sequence_61 = { 743e 8b5c2430 85db 741d }
            // n = 4, score = 200
            //   743e                 | mov                 dword ptr [eax + 0x20], ecx
            //   8b5c2430             | ret                 
            //   85db                 | sub                 ecx, edx
            //   741d                 | shr                 ecx, 1

        $sequence_62 = { 31c9 89e2 31f6 89720c }
            // n = 4, score = 200
            //   31c9                 | ret                 
            //   89e2                 | sub                 ecx, edx
            //   31f6                 | shr                 ecx, 1
            //   89720c               | add                 ecx, edx

        $sequence_63 = { 33d2 c605????????00 0fb6d8 e8???????? }
            // n = 4, score = 200
            //   33d2                 | inc                 ecx
            //   c605????????00       |                     
            //   0fb6d8               | mov                 edx, eax
            //   e8????????           |                     

        $sequence_64 = { 8bf8 e8???????? eb04 8b7c2430 }
            // n = 4, score = 200
            //   8bf8                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   eb04                 | shl                 eax, cl
            //   8b7c2430             | shr                 ax, 8

        $sequence_65 = { e8???????? 84c0 7519 33c9 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   84c0                 | mov                 ecx, ebx
            //   7519                 | shl                 eax, cl
            //   33c9                 | add                 edx, eax

        $sequence_66 = { 81fecd000000 7740 0fb6b62043e601 ff24b50443e601 884801 80ca04 }
            // n = 6, score = 100
            //   81fecd000000         | dec                 eax
            //   7740                 | mov                 ecx, ebx
            //   0fb6b62043e601       | dec                 eax
            //   ff24b50443e601       | mov                 eax, esp
            //   884801               | dec                 eax
            //   80ca04               | mov                 dword ptr [eax + 8], ecx

        $sequence_67 = { e9???????? 8b84248c000000 f20f10842490000000 31c9 }
            // n = 4, score = 100
            //   e9????????           |                     
            //   8b84248c000000       | mov                 byte ptr [eax], cl
            //   f20f10842490000000     | movzx    eax, cx
            //   31c9                 | shr                 ecx, 0x10

        $sequence_68 = { 89e8 894c247c 8b8c2480000000 01c8 83c1c0 }
            // n = 5, score = 100
            //   89e8                 | dec                 esp
            //   894c247c             | mov                 dword ptr [eax + 0x20], ecx
            //   8b8c2480000000       | ret                 
            //   01c8                 | dec                 eax
            //   83c1c0               | cmp                 ebx, eax

        $sequence_69 = { 744b 488d15583f0000 488bc8 e8???????? 4885c0 742f }
            // n = 6, score = 100
            //   744b                 | jne                 0x1d
            //   488d15583f0000       | xor                 ecx, ecx
            //   488bc8               | nop                 dword ptr [eax]
            //   e8????????           |                     
            //   4885c0               | test                al, al
            //   742f                 | jne                 0x1d

        $sequence_70 = { 488b43f8 4c8d4be0 4889442428 8b03 498d55ff 4c8d05ce3f0000 89442420 }
            // n = 7, score = 100
            //   488b43f8             | xor                 ecx, ecx
            //   4c8d4be0             | nop                 dword ptr [eax]
            //   4889442428           | movzx               eax, byte ptr [esp + ecx + 0x130]
            //   8b03                 | test                al, al
            //   498d55ff             | jne                 0x1d
            //   4c8d05ce3f0000       | xor                 ecx, ecx
            //   89442420             | nop                 dword ptr [eax]

        $sequence_71 = { c744240400000000 8954240c e8???????? 8d0d2231d800 890424 }
            // n = 5, score = 100
            //   c744240400000000     | shr                 ax, 8
            //   8954240c             | shr                 cx, 8
            //   e8????????           |                     
            //   8d0d2231d800         | inc                 ecx
            //   890424               | mov                 byte ptr [eax - 1], cl

        $sequence_72 = { 53 57 56 83ec44 8b442454 8d0d5830d800 }
            // n = 6, score = 100
            //   53                   | jae                 0xd
            //   57                   | dec                 eax
            //   56                   | mov                 ecx, ebx
            //   83ec44               | dec                 eax
            //   8b442454             | mov                 ebx, eax
            //   8d0d5830d800         | inc                 ecx

        $sequence_73 = { dd5c2450 f20f10442450 8b442444 8b4838 }
            // n = 4, score = 100
            //   dd5c2450             | dec                 eax
            //   f20f10442450         | mov                 dword ptr [eax + 0x10], edx
            //   8b442444             | dec                 esp
            //   8b4838               | mov                 dword ptr [eax + 0x18], eax

        $sequence_74 = { 8bcc 8bd0 895c2420 e8???????? 44 8bc3 48 }
            // n = 7, score = 100
            //   8bcc                 | add                 ecx, edx
            //   8bd0                 | shr                 ecx, 6
            //   895c2420             | mov                 dword ptr [esp + 0x30], ecx
            //   e8????????           |                     
            //   44                   | dec                 eax
            //   8bc3                 | cmp                 ebx, eax
            //   48                   | jae                 0xd

    condition:
        7 of them and filesize < 733184
}