rule win_enigma_loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.enigma_loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.enigma_loader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d4da0 e8???????? 90 488d15acf80200 488bc8 e8???????? 0f1000 }
            // n = 7, score = 100
            //   488d4da0             | neg                 al
            //   e8????????           |                     
            //   90                   | dec                 esp
            //   488d15acf80200       | mov                 ecx, ecx
            //   488bc8               | dec                 eax
            //   e8????????           |                     
            //   0f1000               | mov                 dword ptr [esp + 0x60], edx

        $sequence_1 = { 493bc1 0f84d9010000 4c8d4001 4c89442430 488b4910 482b0a 48c1f904 }
            // n = 7, score = 100
            //   493bc1               | movdqa              xmmword ptr [esp + 0x20], xmm0
            //   0f84d9010000         | dec                 ecx
            //   4c8d4001             | cmp                 edx, 0x1f
            //   4c89442430           | jae                 0x1850
            //   488b4910             | dec                 ecx
            //   482b0a               | lea                 ecx, [edx + 1]
            //   48c1f904             | dec                 eax

        $sequence_2 = { 482b01 49b8ffffffffffffff1f 48c1fd03 4c8bfa 48c1f803 488bf9 }
            // n = 6, score = 100
            //   482b01               | lea                 ecx, [ebp + 0x77]
            //   49b8ffffffffffffff1f     | dec    esp
            //   48c1fd03             | lea                 eax, [ebp + 0x6f]
            //   4c8bfa               | mov                 edx, 0x20000013
            //   48c1f803             | inc                 ecx
            //   488bf9               | mov                 ecx, edi

        $sequence_3 = { 488d15fb560300 488d4c2420 e8???????? cc 4053 4883ec20 488bd9 }
            // n = 7, score = 100
            //   488d15fb560300       | lea                 eax, [ecx + 3]
            //   488d4c2420           | cmp                 eax, edi
            //   e8????????           |                     
            //   cc                   | jne                 0x55f
            //   4053                 | dec                 eax
            //   4883ec20             | lea                 edx, [0x24a33]
            //   488bd9               | dec                 eax

        $sequence_4 = { e8???????? 90 c6462801 40387e29 0f85b6050000 bb00100000 488b542448 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | mov                 dword ptr [eax + 0x10], ebp
            //   c6462801             | inc                 ecx
            //   40387e29             | mov                 edi, 0xf
            //   0f85b6050000         | movups              xmm0, xmmword ptr [eax]
            //   bb00100000           | movaps              xmmword ptr [esp + 0x20], xmm0
            //   488b542448           | psrldq              xmm0, 8

        $sequence_5 = { 0f28c6 e8???????? 6685c0 0f8f40080000 498d4e20 488d9508020000 e8???????? }
            // n = 7, score = 100
            //   0f28c6               | mov                 eax, edi
            //   e8????????           |                     
            //   6685c0               | mov                 dword ptr [esp + 0x44], eax
            //   0f8f40080000         | mov                 byte ptr [esp + 0x48], al
            //   498d4e20             | inc                 esp
            //   488d9508020000       | mov                 eax, esi
            //   e8????????           |                     

        $sequence_6 = { 4c8d4dd0 418bc4 41f7e0 c1ea05 0fbec2 6bc83a 418ac0 }
            // n = 7, score = 100
            //   4c8d4dd0             | dec                 esp
            //   418bc4               | lea                 ecx, [esp + 0x38]
            //   41f7e0               | inc                 ebp
            //   c1ea05               | mov                 eax, esi
            //   0fbec2               | dec                 eax
            //   6bc83a               | lea                 edx, [esp + 0x58]
            //   418ac0               | dec                 eax

        $sequence_7 = { 488d8424a8000000 4889442420 48895c2428 488933 48897308 b950000000 e8???????? }
            // n = 7, score = 100
            //   488d8424a8000000     | dec                 eax
            //   4889442420           | cmp                 eax, 0x1f
            //   48895c2428           | ja                  0x16d8
            //   488933               | dec                 eax
            //   48897308             | mov                 edi, ecx
            //   b950000000           | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { 83f901 752f 488bca e8???????? 448be0 eb22 }
            // n = 6, score = 100
            //   83f901               | mov                 ecx, edi
            //   752f                 | add                 esi, 0xfca02400
            //   488bca               | add                 esi, ecx
            //   e8????????           |                     
            //   448be0               | jmp                 0x45f
            //   eb22                 | lea                 eax, [esi - 0xdc00]

        $sequence_9 = { 57 488bec 4883ec40 448ada 488bf1 4883c120 488d55f0 }
            // n = 7, score = 100
            //   57                   | mov                 eax, esi
            //   488bec               | dec                 ebp
            //   4883ec40             | mov                 eax, esi
            //   448ada               | dec                 esp
            //   488bf1               | sub                 eax, ecx
            //   4883c120             | neg                 al
            //   488d55f0             | sbb                 edx, edx

    condition:
        7 of them and filesize < 798720
}