rule win_entryshell_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.entryshell."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.entryshell"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 43 895de4 8b049578512501 8945ec 897df0 8a543828 8855ff }
            // n = 7, score = 100
            //   43                   | inc                 ebx
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx
            //   8b049578512501       | mov                 eax, dword ptr [edx*4 + 0x1255178]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi
            //   8a543828             | mov                 dl, byte ptr [eax + edi + 0x28]
            //   8855ff               | mov                 byte ptr [ebp - 1], dl

        $sequence_1 = { 5d c3 8d4301 57 50 e8???????? 83c404 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8d4301               | lea                 eax, [ebx + 1]
            //   57                   | push                edi
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_2 = { 6800020000 8d85f8fdffff 50 ff36 ffd3 85c0 0f855fffffff }
            // n = 7, score = 100
            //   6800020000           | push                0x200
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   50                   | push                eax
            //   ff36                 | push                dword ptr [esi]
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax
            //   0f855fffffff         | jne                 0xffffff65

        $sequence_3 = { 6a10 e8???????? 6a40 6a00 8d45a4 50 e8???????? }
            // n = 7, score = 100
            //   6a10                 | push                0x10
            //   e8????????           |                     
            //   6a40                 | push                0x40
            //   6a00                 | push                0
            //   8d45a4               | lea                 eax, [ebp - 0x5c]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_4 = { 83c202 6685c0 75f5 8b8df8dfffff 2bd6 83c1fe }
            // n = 6, score = 100
            //   83c202               | add                 edx, 2
            //   6685c0               | test                ax, ax
            //   75f5                 | jne                 0xfffffff7
            //   8b8df8dfffff         | mov                 ecx, dword ptr [ebp - 0x2008]
            //   2bd6                 | sub                 edx, esi
            //   83c1fe               | add                 ecx, -2

        $sequence_5 = { 60 33d2 8b55f4 33c0 8d05e4382501 33c9 8b0c90 }
            // n = 7, score = 100
            //   60                   | pushal              
            //   33d2                 | xor                 edx, edx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   33c0                 | xor                 eax, eax
            //   8d05e4382501         | lea                 eax, [0x12538e4]
            //   33c9                 | xor                 ecx, ecx
            //   8b0c90               | mov                 ecx, dword ptr [eax + edx*4]

        $sequence_6 = { 0101 8d22 0131 8d22 015e8d 2201 8e8d2201558b }
            // n = 7, score = 100
            //   0101                 | add                 dword ptr [ecx], eax
            //   8d22                 | lea                 esp, [edx]
            //   0131                 | add                 dword ptr [ecx], esi
            //   8d22                 | lea                 esp, [edx]
            //   015e8d               | add                 dword ptr [esi - 0x73], ebx
            //   2201                 | and                 al, byte ptr [ecx]
            //   8e8d2201558b         | mov                 cs, word ptr [ebp - 0x74aafede]

        $sequence_7 = { c705????????00400000 33c0 c3 6a08 68???????? e8???????? 833d????????01 }
            // n = 7, score = 100
            //   c705????????00400000     |     
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   6a08                 | push                8
            //   68????????           |                     
            //   e8????????           |                     
            //   833d????????01       |                     

        $sequence_8 = { 8bf2 ff15???????? 85c0 7523 68???????? ff15???????? }
            // n = 6, score = 100
            //   8bf2                 | mov                 esi, edx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7523                 | jne                 0x25
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_9 = { 50 e8???????? 83c414 8d85f8f7ffff 6a00 6a00 6aff }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8d85f8f7ffff         | lea                 eax, [ebp - 0x808]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6aff                 | push                -1

    condition:
        7 of them and filesize < 663552
}