rule win_epsilon_red_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.epsilon_red."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.epsilon_red"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b88dc000000 85c9 745a 83f901 743b 83f902 741b }
            // n = 7, score = 200
            //   8b88dc000000         | mov                 edx, dword ptr [esp + 0x108]
            //   85c9                 | dec                 eax
            //   745a                 | mov                 ebx, dword ptr [edx]
            //   83f901               | nop                 
            //   743b                 | dec                 eax
            //   83f902               | mov                 dword ptr [esp], eax
            //   741b                 | dec                 eax

        $sequence_1 = { 65488b0c2528000000 488b8900000000 483b6110 0f8639020000 4883ec30 48896c2428 488d6c2428 }
            // n = 7, score = 200
            //   65488b0c2528000000     | mov    ecx, dword ptr [esp + 0x10]
            //   488b8900000000       | dec                 eax
            //   483b6110             | mov                 dword ptr [esp + 0x40], eax
            //   0f8639020000         | dec                 eax
            //   4883ec30             | mov                 dword ptr [esp + 0x48], ecx
            //   48896c2428           | dec                 eax
            //   488d6c2428           | mov                 ebp, dword ptr [esp + 0x30]

        $sequence_2 = { e9???????? bb38000000 0f1f00 e9???????? 488d7808 4c8b842470010000 e8???????? }
            // n = 7, score = 200
            //   e9????????           |                     
            //   bb38000000           | mov                 dword ptr [esp + 8], edx
            //   0f1f00               | dec                 eax
            //   e9????????           |                     
            //   488d7808             | mov                 dword ptr [esp + 0x10], 0x2f
            //   4c8b842470010000     | dec                 eax
            //   e8????????           |                     

        $sequence_3 = { c644244000 48c744244803000000 c644245000 c644245101 488b6c2420 4883c428 c3 }
            // n = 7, score = 200
            //   c644244000           | lea                 eax, [0x3c088]
            //   48c744244803000000     | dec    eax
            //   c644245000           | mov                 dword ptr [esp], eax
            //   c644245101           | dec                 eax
            //   488b6c2420           | mov                 ecx, dword ptr [esp + 0x28]
            //   4883c428             | dec                 eax
            //   c3                   | mov                 dword ptr [esp + 8], ecx

        $sequence_4 = { e8???????? 488b542420 488b5c2418 eb8a c644244000 488b6c2428 4883c430 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   488b542420           | dec                 eax
            //   488b5c2418           | mov                 dword ptr [esp + 8], ecx
            //   eb8a                 | dec                 eax
            //   c644244000           | lea                 eax, [esp + 0x50]
            //   488b6c2428           | dec                 eax
            //   4883c430             | mov                 dword ptr [esp + 8], eax

        $sequence_5 = { 8400 8b1488 488b1d???????? 488b35???????? 0f1f4000 4839d9 72d1 }
            // n = 7, score = 200
            //   8400                 | mov                 ecx, dword ptr [ecx]
            //   8b1488               | dec                 eax
            //   488b1d????????       |                     
            //   488b35????????       |                     
            //   0f1f4000             | cmp                 esp, dword ptr [ecx + 0x10]
            //   4839d9               | jbe                 0xaf3
            //   72d1                 | dec                 eax

        $sequence_6 = { 65488b0c2528000000 488b8900000000 483b6110 0f86eb000000 4883ec48 48896c2440 488d6c2440 }
            // n = 7, score = 200
            //   65488b0c2528000000     | mov    ecx, dword ptr [esp + 0x18]
            //   488b8900000000       | dec                 eax
            //   483b6110             | test                eax, eax
            //   0f86eb000000         | jne                 0x11e2
            //   4883ec48             | dec                 eax
            //   48896c2440           | mov                 eax, dword ptr [esp + 0x50]
            //   488d6c2440           | dec                 eax

        $sequence_7 = { 6690 4885c0 0f84b4020000 31c9 31d2 31db 31f6 }
            // n = 7, score = 200
            //   6690                 | mov                 dword ptr [esp + 0x58], edi
            //   4885c0               | dec                 esp
            //   0f84b4020000         | mov                 dword ptr [esp], eax
            //   31c9                 | cmp                 byte ptr [esp + 8], 0
            //   31d2                 | dec                 eax
            //   31db                 | mov                 ecx, dword ptr [esp + 0x48]
            //   31f6                 | dec                 eax

        $sequence_8 = { 0f83860b0000 0fb67c1801 4080ff35 7548 4839f2 0f87670b0000 48895c2430 }
            // n = 7, score = 200
            //   0f83860b0000         | dec                 eax
            //   0fb67c1801           | mov                 dword ptr [esp + 0x28], 0xc
            //   4080ff35             | dec                 eax
            //   7548                 | mov                 dword ptr [esp + 0x30], eax
            //   4839f2               | dec                 eax
            //   0f87670b0000         | mov                 dword ptr [esp + 0x10], 4
            //   48895c2430           | dec                 eax

        $sequence_9 = { 6690 eb98 4885c0 7404 488b4008 48890424 48894c2408 }
            // n = 7, score = 200
            //   6690                 | mov                 ecx, dword ptr [esp + 0x68]
            //   eb98                 | dec                 eax
            //   4885c0               | mov                 dword ptr [esp + 8], ecx
            //   7404                 | dec                 eax
            //   488b4008             | mov                 ecx, eax
            //   48890424             | dec                 eax
            //   48894c2408           | shr                 eax, 0x3f

    condition:
        7 of them and filesize < 5075968
}