rule win_equationdrug_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.equationdrug."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.equationdrug"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 751f 668b5c241c 66395c240c 7420 8d4c240c 46 51 }
            // n = 7, score = 100
            //   751f                 | jne                 0x21
            //   668b5c241c           | mov                 bx, word ptr [esp + 0x1c]
            //   66395c240c           | cmp                 word ptr [esp + 0xc], bx
            //   7420                 | je                  0x22
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   46                   | inc                 esi
            //   51                   | push                ecx

        $sequence_1 = { 8b4604 50 e8???????? 8b542430 8b4c2434 83c404 8d048a }
            // n = 7, score = 100
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b542430             | mov                 edx, dword ptr [esp + 0x30]
            //   8b4c2434             | mov                 ecx, dword ptr [esp + 0x34]
            //   83c404               | add                 esp, 4
            //   8d048a               | lea                 eax, [edx + ecx*4]

        $sequence_2 = { 50 e8???????? 83c404 84c0 7507 b812060000 5e }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   84c0                 | test                al, al
            //   7507                 | jne                 9
            //   b812060000           | mov                 eax, 0x612
            //   5e                   | pop                 esi

        $sequence_3 = { 89742468 e8???????? 6a40 899c24bc030000 e8???????? 83c404 89442440 }
            // n = 7, score = 100
            //   89742468             | mov                 dword ptr [esp + 0x68], esi
            //   e8????????           |                     
            //   6a40                 | push                0x40
            //   899c24bc030000       | mov                 dword ptr [esp + 0x3bc], ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   89442440             | mov                 dword ptr [esp + 0x40], eax

        $sequence_4 = { 8b4618 50 8944240c e8???????? 33ff 897e18 897e1c }
            // n = 7, score = 100
            //   8b4618               | mov                 eax, dword ptr [esi + 0x18]
            //   50                   | push                eax
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   e8????????           |                     
            //   33ff                 | xor                 edi, edi
            //   897e18               | mov                 dword ptr [esi + 0x18], edi
            //   897e1c               | mov                 dword ptr [esi + 0x1c], edi

        $sequence_5 = { 8bc5 5e 5d 5b 81c498000000 c3 5f }
            // n = 7, score = 100
            //   8bc5                 | mov                 eax, ebp
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   81c498000000         | add                 esp, 0x98
            //   c3                   | ret                 
            //   5f                   | pop                 edi

        $sequence_6 = { 0f8578010000 8b9424f8000000 83c9ff 8bfa f2ae f7d1 51 }
            // n = 7, score = 100
            //   0f8578010000         | jne                 0x17e
            //   8b9424f8000000       | mov                 edx, dword ptr [esp + 0xf8]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   8bfa                 | mov                 edi, edx
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   51                   | push                ecx

        $sequence_7 = { 85c0 66a5 7409 50 e8???????? 83c404 8b4c2418 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   7409                 | je                  0xb
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]

        $sequence_8 = { 5f 8930 5e 8919 5d 33c0 5b }
            // n = 7, score = 100
            //   5f                   | pop                 edi
            //   8930                 | mov                 dword ptr [eax], esi
            //   5e                   | pop                 esi
            //   8919                 | mov                 dword ptr [ecx], ebx
            //   5d                   | pop                 ebp
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx

        $sequence_9 = { 8b4c2414 83c408 897e08 897e0c 897e10 5f 5e }
            // n = 7, score = 100
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   83c408               | add                 esp, 8
            //   897e08               | mov                 dword ptr [esi + 8], edi
            //   897e0c               | mov                 dword ptr [esi + 0xc], edi
            //   897e10               | mov                 dword ptr [esi + 0x10], edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 449536
}