rule win_etumbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.etumbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.etumbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8a00 02c2 0fb6c0 8a8405fcfeffff }
            // n = 4, score = 400
            //   8a00                 | mov                 al, byte ptr [eax]
            //   02c2                 | add                 al, dl
            //   0fb6c0               | movzx               eax, al
            //   8a8405fcfeffff       | mov                 al, byte ptr [ebp + eax - 0x104]

        $sequence_1 = { 0fb6c0 8a8405fcfeffff 320437 8806 46 }
            // n = 5, score = 400
            //   0fb6c0               | movzx               eax, al
            //   8a8405fcfeffff       | mov                 al, byte ptr [ebp + eax - 0x104]
            //   320437               | xor                 al, byte ptr [edi + esi]
            //   8806                 | mov                 byte ptr [esi], al
            //   46                   | inc                 esi

        $sequence_2 = { c745b063726f73 c745b46f66745c c745b85c57696e c745bc646f7773 c745c05c5c4375 c745c47272656e }
            // n = 6, score = 300
            //   c745b063726f73       | mov                 dword ptr [ebp - 0x50], 0x736f7263
            //   c745b46f66745c       | mov                 dword ptr [ebp - 0x4c], 0x5c74666f
            //   c745b85c57696e       | mov                 dword ptr [ebp - 0x48], 0x6e69575c
            //   c745bc646f7773       | mov                 dword ptr [ebp - 0x44], 0x73776f64
            //   c745c05c5c4375       | mov                 dword ptr [ebp - 0x40], 0x75435c5c
            //   c745c47272656e       | mov                 dword ptr [ebp - 0x3c], 0x6e657272

        $sequence_3 = { f7d1 23c1 42 4e 75df }
            // n = 5, score = 300
            //   f7d1                 | not                 ecx
            //   23c1                 | and                 eax, ecx
            //   42                   | inc                 edx
            //   4e                   | dec                 esi
            //   75df                 | jne                 0xffffffe1

        $sequence_4 = { 8d45f4 6820a10700 50 68???????? 68???????? }
            // n = 5, score = 300
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   6820a10700           | push                0x7a120
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     

        $sequence_5 = { c745cc73696f6e c745d05c5c496e c745d47465726e c745d865742053 }
            // n = 4, score = 300
            //   c745cc73696f6e       | mov                 dword ptr [ebp - 0x34], 0x6e6f6973
            //   c745d05c5c496e       | mov                 dword ptr [ebp - 0x30], 0x6e495c5c
            //   c745d47465726e       | mov                 dword ptr [ebp - 0x2c], 0x6e726574
            //   c745d865742053       | mov                 dword ptr [ebp - 0x28], 0x53207465

        $sequence_6 = { 03c1 8bc8 81e1000000f0 7407 8bf9 }
            // n = 5, score = 300
            //   03c1                 | add                 eax, ecx
            //   8bc8                 | mov                 ecx, eax
            //   81e1000000f0         | and                 ecx, 0xf0000000
            //   7407                 | je                  9
            //   8bf9                 | mov                 edi, ecx

        $sequence_7 = { 7407 8bf9 c1ef18 33c7 f7d1 23c1 }
            // n = 6, score = 300
            //   7407                 | je                  9
            //   8bf9                 | mov                 edi, ecx
            //   c1ef18               | shr                 edi, 0x18
            //   33c7                 | xor                 eax, edi
            //   f7d1                 | not                 ecx
            //   23c1                 | and                 eax, ecx

        $sequence_8 = { c745d47465726e c745d865742053 c745dc65747469 c745e06e677300 }
            // n = 4, score = 300
            //   c745d47465726e       | mov                 dword ptr [ebp - 0x2c], 0x6e726574
            //   c745d865742053       | mov                 dword ptr [ebp - 0x28], 0x53207465
            //   c745dc65747469       | mov                 dword ptr [ebp - 0x24], 0x69747465
            //   c745e06e677300       | mov                 dword ptr [ebp - 0x20], 0x73676e

        $sequence_9 = { 53 56 57 8b3d???????? ffd7 8b7508 8bd8 }
            // n = 7, score = 300
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   ffd7                 | call                edi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8bd8                 | mov                 ebx, eax

        $sequence_10 = { 57 0fbe38 33f6 33db }
            // n = 4, score = 300
            //   57                   | push                edi
            //   0fbe38               | movsx               edi, byte ptr [eax]
            //   33f6                 | xor                 esi, esi
            //   33db                 | xor                 ebx, ebx

        $sequence_11 = { c745c47272656e c745c874566572 c745cc73696f6e c745d05c5c496e }
            // n = 4, score = 300
            //   c745c47272656e       | mov                 dword ptr [ebp - 0x3c], 0x6e657272
            //   c745c874566572       | mov                 dword ptr [ebp - 0x38], 0x72655674
            //   c745cc73696f6e       | mov                 dword ptr [ebp - 0x34], 0x6e6f6973
            //   c745d05c5c496e       | mov                 dword ptr [ebp - 0x30], 0x6e495c5c

        $sequence_12 = { ffd7 2bc3 3bc6 72ed 5f 5e }
            // n = 6, score = 300
            //   ffd7                 | call                edi
            //   2bc3                 | sub                 eax, ebx
            //   3bc6                 | cmp                 eax, esi
            //   72ed                 | jb                  0xffffffef
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_13 = { 8b45f4 0345f0 8b4d08 034dec 8a11 8810 }
            // n = 6, score = 200
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   0345f0               | add                 eax, dword ptr [ebp - 0x10]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   034dec               | add                 ecx, dword ptr [ebp - 0x14]
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   8810                 | mov                 byte ptr [eax], dl

        $sequence_14 = { c645bf69 c645c062 c645c16c c645c265 c645c33b c645c420 c645c54d }
            // n = 7, score = 200
            //   c645bf69             | mov                 byte ptr [ebp - 0x41], 0x69
            //   c645c062             | mov                 byte ptr [ebp - 0x40], 0x62
            //   c645c16c             | mov                 byte ptr [ebp - 0x3f], 0x6c
            //   c645c265             | mov                 byte ptr [ebp - 0x3e], 0x65
            //   c645c33b             | mov                 byte ptr [ebp - 0x3d], 0x3b
            //   c645c420             | mov                 byte ptr [ebp - 0x3c], 0x20
            //   c645c54d             | mov                 byte ptr [ebp - 0x3b], 0x4d

        $sequence_15 = { 8b4d08 83c101 894d08 8b550c 83ea03 }
            // n = 5, score = 200
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   83c101               | add                 ecx, 1
            //   894d08               | mov                 dword ptr [ebp + 8], ecx
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   83ea03               | sub                 edx, 3

        $sequence_16 = { 83c204 3b5514 7608 83c8ff }
            // n = 4, score = 200
            //   83c204               | add                 edx, 4
            //   3b5514               | cmp                 edx, dword ptr [ebp + 0x14]
            //   7608                 | jbe                 0xa
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_17 = { 80e10f c0e102 c0eb06 02cb }
            // n = 4, score = 200
            //   80e10f               | and                 cl, 0xf
            //   c0e102               | shl                 cl, 2
            //   c0eb06               | shr                 bl, 6
            //   02cb                 | add                 cl, bl

        $sequence_18 = { c644242c45 8854242f 884c2431 c644243273 88542434 }
            // n = 5, score = 200
            //   c644242c45           | mov                 byte ptr [esp + 0x2c], 0x45
            //   8854242f             | mov                 byte ptr [esp + 0x2f], dl
            //   884c2431             | mov                 byte ptr [esp + 0x31], cl
            //   c644243273           | mov                 byte ptr [esp + 0x32], 0x73
            //   88542434             | mov                 byte ptr [esp + 0x34], dl

        $sequence_19 = { 83c404 8bd1 c1e902 f3ab 8bca }
            // n = 5, score = 200
            //   83c404               | add                 esp, 4
            //   8bd1                 | mov                 edx, ecx
            //   c1e902               | shr                 ecx, 2
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8bca                 | mov                 ecx, edx

        $sequence_20 = { 6a00 68???????? 6a00 6a00 6a00 51 68???????? }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   68????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   68????????           |                     

        $sequence_21 = { e8???????? 8d45fc 50 8d85bcfeffff 50 e8???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   8d85bcfeffff         | lea                 eax, [ebp - 0x144]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_22 = { 8b0c8d20cf4000 8a44c104 83e040 c3 56 8b742408 85f6 }
            // n = 7, score = 200
            //   8b0c8d20cf4000       | mov                 ecx, dword ptr [ecx*4 + 0x40cf20]
            //   8a44c104             | mov                 al, byte ptr [ecx + eax*8 + 4]
            //   83e040               | and                 eax, 0x40
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8b742408             | mov                 esi, dword ptr [esp + 8]
            //   85f6                 | test                esi, esi

        $sequence_23 = { b9ff000000 33c0 8dbda6fbffff f3ab }
            // n = 4, score = 200
            //   b9ff000000           | mov                 ecx, 0xff
            //   33c0                 | xor                 eax, eax
            //   8dbda6fbffff         | lea                 edi, [ebp - 0x45a]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_24 = { c645d673 c645d720 c645d84e c645d954 }
            // n = 4, score = 200
            //   c645d673             | mov                 byte ptr [ebp - 0x2a], 0x73
            //   c645d720             | mov                 byte ptr [ebp - 0x29], 0x20
            //   c645d84e             | mov                 byte ptr [ebp - 0x28], 0x4e
            //   c645d954             | mov                 byte ptr [ebp - 0x27], 0x54

        $sequence_25 = { 83c104 3b4d14 7608 83c8ff }
            // n = 4, score = 200
            //   83c104               | add                 ecx, 4
            //   3b4d14               | cmp                 ecx, dword ptr [ebp + 0x14]
            //   7608                 | jbe                 0xa
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_26 = { 50 8d85c4eaffff 50 e8???????? 8d85ecfdffff }
            // n = 5, score = 200
            //   50                   | push                eax
            //   8d85c4eaffff         | lea                 eax, [ebp - 0x153c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85ecfdffff         | lea                 eax, [ebp - 0x214]

        $sequence_27 = { 59 50 8d8504ffffff e9???????? 6a18 }
            // n = 5, score = 200
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   8d8504ffffff         | lea                 eax, [ebp - 0xfc]
            //   e9????????           |                     
            //   6a18                 | push                0x18

        $sequence_28 = { c645c33b c645c420 c645c54d c645c653 c645c749 c645c845 c645c920 }
            // n = 7, score = 200
            //   c645c33b             | mov                 byte ptr [ebp - 0x3d], 0x3b
            //   c645c420             | mov                 byte ptr [ebp - 0x3c], 0x20
            //   c645c54d             | mov                 byte ptr [ebp - 0x3b], 0x4d
            //   c645c653             | mov                 byte ptr [ebp - 0x3a], 0x53
            //   c645c749             | mov                 byte ptr [ebp - 0x39], 0x49
            //   c645c845             | mov                 byte ptr [ebp - 0x38], 0x45
            //   c645c920             | mov                 byte ptr [ebp - 0x37], 0x20

        $sequence_29 = { 8b4508 8365f800 898184110000 8d45f4 6a00 }
            // n = 5, score = 200
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8365f800             | and                 dword ptr [ebp - 8], 0
            //   898184110000         | mov                 dword ptr [ecx + 0x1184], eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   6a00                 | push                0

        $sequence_30 = { 83c404 85c0 7429 8b442454 0fbe38 40 85ff }
            // n = 7, score = 200
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7429                 | je                  0x2b
            //   8b442454             | mov                 eax, dword ptr [esp + 0x54]
            //   0fbe38               | movsx               edi, byte ptr [eax]
            //   40                   | inc                 eax
            //   85ff                 | test                edi, edi

        $sequence_31 = { 89442428 f3ab 88542414 89542444 }
            // n = 4, score = 200
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   88542414             | mov                 byte ptr [esp + 0x14], dl
            //   89542444             | mov                 dword ptr [esp + 0x44], edx

        $sequence_32 = { c645d057 c645d169 c645d26e c645d364 }
            // n = 4, score = 200
            //   c645d057             | mov                 byte ptr [ebp - 0x30], 0x57
            //   c645d169             | mov                 byte ptr [ebp - 0x2f], 0x69
            //   c645d26e             | mov                 byte ptr [ebp - 0x2e], 0x6e
            //   c645d364             | mov                 byte ptr [ebp - 0x2d], 0x64

        $sequence_33 = { c645cd31 c645ce3b c645cf20 c645d057 c645d169 }
            // n = 5, score = 200
            //   c645cd31             | mov                 byte ptr [ebp - 0x33], 0x31
            //   c645ce3b             | mov                 byte ptr [ebp - 0x32], 0x3b
            //   c645cf20             | mov                 byte ptr [ebp - 0x31], 0x20
            //   c645d057             | mov                 byte ptr [ebp - 0x30], 0x57
            //   c645d169             | mov                 byte ptr [ebp - 0x2f], 0x69

        $sequence_34 = { 52 e8???????? 83c404 e9???????? 6a05 }
            // n = 5, score = 200
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   e9????????           |                     
            //   6a05                 | push                5

        $sequence_35 = { c645fa74 c645fb2e c645fc64 c645fd6c }
            // n = 4, score = 200
            //   c645fa74             | mov                 byte ptr [ebp - 6], 0x74
            //   c645fb2e             | mov                 byte ptr [ebp - 5], 0x2e
            //   c645fc64             | mov                 byte ptr [ebp - 4], 0x64
            //   c645fd6c             | mov                 byte ptr [ebp - 3], 0x6c

        $sequence_36 = { c645f569 c645f66e c645f769 c645f86e }
            // n = 4, score = 200
            //   c645f569             | mov                 byte ptr [ebp - 0xb], 0x69
            //   c645f66e             | mov                 byte ptr [ebp - 0xa], 0x6e
            //   c645f769             | mov                 byte ptr [ebp - 9], 0x69
            //   c645f86e             | mov                 byte ptr [ebp - 8], 0x6e

        $sequence_37 = { 8b4df4 034df0 8b5508 0355ec }
            // n = 4, score = 200
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   034df0               | add                 ecx, dword ptr [ebp - 0x10]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   0355ec               | add                 edx, dword ptr [ebp - 0x14]

        $sequence_38 = { 50 8b4dbc 51 8b952ce6ffff 8b4210 ffd0 85c0 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b4dbc               | mov                 ecx, dword ptr [ebp - 0x44]
            //   51                   | push                ecx
            //   8b952ce6ffff         | mov                 edx, dword ptr [ebp - 0x19d4]
            //   8b4210               | mov                 eax, dword ptr [edx + 0x10]
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax

        $sequence_39 = { c685dcefffff45 c685ddefffff20 c685deefffff35 c685dfefffff2e c685e0efffff30 }
            // n = 5, score = 100
            //   c685dcefffff45       | mov                 byte ptr [ebp - 0x1024], 0x45
            //   c685ddefffff20       | mov                 byte ptr [ebp - 0x1023], 0x20
            //   c685deefffff35       | mov                 byte ptr [ebp - 0x1022], 0x35
            //   c685dfefffff2e       | mov                 byte ptr [ebp - 0x1021], 0x2e
            //   c685e0efffff30       | mov                 byte ptr [ebp - 0x1020], 0x30

    condition:
        7 of them and filesize < 450560
}