rule win_expiro_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.expiro."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.expiro"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 e8???????? 83c404 385c2413 0f85ddfdffff b8???????? 8d4c2414 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   385c2413             | cmp                 byte ptr [esp + 0x13], bl
            //   0f85ddfdffff         | jne                 0xfffffde3
            //   b8????????           |                     
            //   8d4c2414             | lea                 ecx, [esp + 0x14]

        $sequence_1 = { 02abd9737373 739b 057d737313 7173 7373 7373 }
            // n = 6, score = 100
            //   02abd9737373         | add                 ch, byte ptr [ebx + 0x737373d9]
            //   739b                 | jae                 0xffffff9d
            //   057d737313           | add                 eax, 0x1373737d
            //   7173                 | jno                 0x75
            //   7373                 | jae                 0x75
            //   7373                 | jae                 0x75

        $sequence_2 = { 8d7558 c684244802000002 33c0 c7461407000000 895e10 668906 }
            // n = 6, score = 100
            //   8d7558               | lea                 esi, [ebp + 0x58]
            //   c684244802000002     | mov                 byte ptr [esp + 0x248], 2
            //   33c0                 | xor                 eax, eax
            //   c7461407000000       | mov                 dword ptr [esi + 0x14], 7
            //   895e10               | mov                 dword ptr [esi + 0x10], ebx
            //   668906               | mov                 word ptr [esi], ax

        $sequence_3 = { 367bf8 337ffa 36871b 49 16 62639b }
            // n = 6, score = 100
            //   367bf8               | jnp                 0xfffffffb
            //   337ffa               | xor                 edi, dword ptr [edi - 6]
            //   36871b               | xchg                dword ptr ss:[ebx], ebx
            //   49                   | dec                 ecx
            //   16                   | push                ss
            //   62639b               | bound               esp, qword ptr [ebx - 0x65]

        $sequence_4 = { 56 6a00 6a00 ff15???????? b932000000 8bc3 33ed }
            // n = 7, score = 100
            //   56                   | push                esi
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   b932000000           | mov                 ecx, 0x32
            //   8bc3                 | mov                 eax, ebx
            //   33ed                 | xor                 ebp, ebp

        $sequence_5 = { 8b06 33d2 5f 668910 8bc6 5b c20800 }
            // n = 7, score = 100
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   33d2                 | xor                 edx, edx
            //   5f                   | pop                 edi
            //   668910               | mov                 word ptr [eax], dx
            //   8bc6                 | mov                 eax, esi
            //   5b                   | pop                 ebx
            //   c20800               | ret                 8

        $sequence_6 = { 668906 57 83c8ff 8bd6 e8???????? 897c2420 }
            // n = 6, score = 100
            //   668906               | mov                 word ptr [esi], ax
            //   57                   | push                edi
            //   83c8ff               | or                  eax, 0xffffffff
            //   8bd6                 | mov                 edx, esi
            //   e8????????           |                     
            //   897c2420             | mov                 dword ptr [esp + 0x20], edi

        $sequence_7 = { 8b4c241c 33cc b001 e8???????? 83c420 c3 6aff }
            // n = 7, score = 100
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   33cc                 | xor                 ecx, esp
            //   b001                 | mov                 al, 1
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20
            //   c3                   | ret                 
            //   6aff                 | push                -1

        $sequence_8 = { 50 8d7c247c c68424f802000003 e8???????? 83c404 c68424f402000002 837c243808 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d7c247c             | lea                 edi, [esp + 0x7c]
            //   c68424f802000003     | mov                 byte ptr [esp + 0x2f8], 3
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c68424f402000002     | mov                 byte ptr [esp + 0x2f4], 2
            //   837c243808           | cmp                 dword ptr [esp + 0x38], 8

        $sequence_9 = { 83c8ff b9???????? 8d542450 89742464 897c2460 e8???????? }
            // n = 6, score = 100
            //   83c8ff               | or                  eax, 0xffffffff
            //   b9????????           |                     
            //   8d542450             | lea                 edx, [esp + 0x50]
            //   89742464             | mov                 dword ptr [esp + 0x64], esi
            //   897c2460             | mov                 dword ptr [esp + 0x60], edi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 3776512
}