rule win_explosive_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.explosive_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.explosive_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 0f84fb000000 68???????? 68???????? ffd6 85c0 0f84e7000000 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f84fb000000         | je                  0x101
            //   68????????           |                     
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   0f84e7000000         | je                  0xed

        $sequence_1 = { 72cc 5d 8b442428 be10000000 3bc6 720d }
            // n = 6, score = 100
            //   72cc                 | jb                  0xffffffce
            //   5d                   | pop                 ebp
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   be10000000           | mov                 esi, 0x10
            //   3bc6                 | cmp                 eax, esi
            //   720d                 | jb                  0xf

        $sequence_2 = { 8d4514 50 8d4d0c e8???????? 84c0 8b7520 }
            // n = 6, score = 100
            //   8d4514               | lea                 eax, [ebp + 0x14]
            //   50                   | push                eax
            //   8d4d0c               | lea                 ecx, [ebp + 0xc]
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   8b7520               | mov                 esi, dword ptr [ebp + 0x20]

        $sequence_3 = { 8902 8908 894104 5b c20400 894208 8908 }
            // n = 7, score = 100
            //   8902                 | mov                 dword ptr [edx], eax
            //   8908                 | mov                 dword ptr [eax], ecx
            //   894104               | mov                 dword ptr [ecx + 4], eax
            //   5b                   | pop                 ebx
            //   c20400               | ret                 4
            //   894208               | mov                 dword ptr [edx + 8], eax
            //   8908                 | mov                 dword ptr [eax], ecx

        $sequence_4 = { 89bdc4010000 89bdc8010000 6689bdd4010000 e8???????? 8bb508040000 83c41c }
            // n = 6, score = 100
            //   89bdc4010000         | mov                 dword ptr [ebp + 0x1c4], edi
            //   89bdc8010000         | mov                 dword ptr [ebp + 0x1c8], edi
            //   6689bdd4010000       | mov                 word ptr [ebp + 0x1d4], di
            //   e8????????           |                     
            //   8bb508040000         | mov                 esi, dword ptr [ebp + 0x408]
            //   83c41c               | add                 esp, 0x1c

        $sequence_5 = { e8???????? 3bfb 745b 395d14 7539 6a34 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   3bfb                 | cmp                 edi, ebx
            //   745b                 | je                  0x5d
            //   395d14               | cmp                 dword ptr [ebp + 0x14], ebx
            //   7539                 | jne                 0x3b
            //   6a34                 | push                0x34
            //   e8????????           |                     

        $sequence_6 = { 8d8d44ffffff e8???????? 8d8d04f5feff e8???????? 8b8558ffffff 8985f801ffff 89853402ffff }
            // n = 7, score = 100
            //   8d8d44ffffff         | lea                 ecx, [ebp - 0xbc]
            //   e8????????           |                     
            //   8d8d04f5feff         | lea                 ecx, [ebp - 0x10afc]
            //   e8????????           |                     
            //   8b8558ffffff         | mov                 eax, dword ptr [ebp - 0xa8]
            //   8985f801ffff         | mov                 dword ptr [ebp - 0xfe08], eax
            //   89853402ffff         | mov                 dword ptr [ebp - 0xfdcc], eax

        $sequence_7 = { 3bfb 745b 395d14 7539 6a18 e8???????? 59 }
            // n = 7, score = 100
            //   3bfb                 | cmp                 edi, ebx
            //   745b                 | je                  0x5d
            //   395d14               | cmp                 dword ptr [ebp + 0x14], ebx
            //   7539                 | jne                 0x3b
            //   6a18                 | push                0x18
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_8 = { 8d8d44ffffff e8???????? 8d8d7cffffff e8???????? 807d2475 0f8537010000 53 }
            // n = 7, score = 100
            //   8d8d44ffffff         | lea                 ecx, [ebp - 0xbc]
            //   e8????????           |                     
            //   8d8d7cffffff         | lea                 ecx, [ebp - 0x84]
            //   e8????????           |                     
            //   807d2475             | cmp                 byte ptr [ebp + 0x24], 0x75
            //   0f8537010000         | jne                 0x13d
            //   53                   | push                ebx

        $sequence_9 = { 663bf2 771d 7220 41 41 40 40 }
            // n = 7, score = 100
            //   663bf2               | cmp                 si, dx
            //   771d                 | ja                  0x1f
            //   7220                 | jb                  0x22
            //   41                   | inc                 ecx
            //   41                   | inc                 ecx
            //   40                   | inc                 eax
            //   40                   | inc                 eax

    condition:
        7 of them and filesize < 855040
}