rule win_fakerean_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fakerean."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fakerean"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7508 898348030000 ff15???????? 5f 5e 5b c9 }
            // n = 7, score = 300
            //   ff7508               | push                dword ptr [ebp + 8]
            //   898348030000         | mov                 dword ptr [ebx + 0x348], eax
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               

        $sequence_1 = { 50 e8???????? 83c40c 8b4640 2b4638 85c0 7f1c }
            // n = 7, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b4640               | mov                 eax, dword ptr [esi + 0x40]
            //   2b4638               | sub                 eax, dword ptr [esi + 0x38]
            //   85c0                 | test                eax, eax
            //   7f1c                 | jg                  0x1e

        $sequence_2 = { ff15???????? a1???????? 8b08 6a01 ff35???????? 50 ff5128 }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   a1????????           |                     
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   6a01                 | push                1
            //   ff35????????         |                     
            //   50                   | push                eax
            //   ff5128               | call                dword ptr [ecx + 0x28]

        $sequence_3 = { 8845f8 84c9 7419 8b4508 0345fc 0fb6d9 }
            // n = 6, score = 300
            //   8845f8               | mov                 byte ptr [ebp - 8], al
            //   84c9                 | test                cl, cl
            //   7419                 | je                  0x1b
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0345fc               | add                 eax, dword ptr [ebp - 4]
            //   0fb6d9               | movzx               ebx, cl

        $sequence_4 = { 8d45f0 50 ff7608 ff15???????? 83f801 743e 83f802 }
            // n = 7, score = 300
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   ff7608               | push                dword ptr [esi + 8]
            //   ff15????????         |                     
            //   83f801               | cmp                 eax, 1
            //   743e                 | je                  0x40
            //   83f802               | cmp                 eax, 2

        $sequence_5 = { e8???????? 83c428 8935???????? 5f 5e c9 c3 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   83c428               | add                 esp, 0x28
            //   8935????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_6 = { 8b45f0 eb03 8b45ec 8945f8 eb1d 8b45fc ebf6 }
            // n = 7, score = 300
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   eb03                 | jmp                 5
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   eb1d                 | jmp                 0x1f
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   ebf6                 | jmp                 0xfffffff8

        $sequence_7 = { 8bc2 ab ab ab ab 6a08 59 }
            // n = 7, score = 300
            //   8bc2                 | mov                 eax, edx
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   6a08                 | push                8
            //   59                   | pop                 ecx

        $sequence_8 = { c6450f30 eb0f 83fe01 0f95c0 fec8 2420 0441 }
            // n = 7, score = 300
            //   c6450f30             | mov                 byte ptr [ebp + 0xf], 0x30
            //   eb0f                 | jmp                 0x11
            //   83fe01               | cmp                 esi, 1
            //   0f95c0               | setne               al
            //   fec8                 | dec                 al
            //   2420                 | and                 al, 0x20
            //   0441                 | add                 al, 0x41

        $sequence_9 = { f7fb 83c230 668911 03cf 397d0c 7512 85c0 }
            // n = 7, score = 300
            //   f7fb                 | idiv                ebx
            //   83c230               | add                 edx, 0x30
            //   668911               | mov                 word ptr [ecx], dx
            //   03cf                 | add                 ecx, edi
            //   397d0c               | cmp                 dword ptr [ebp + 0xc], edi
            //   7512                 | jne                 0x14
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 4071424
}