rule win_faketc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.faketc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.faketc"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? bd01000000 89ac2460010000 84db 7405 c644246c01 097c2470 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   bd01000000           | mov                 ebp, 1
            //   89ac2460010000       | mov                 dword ptr [esp + 0x160], ebp
            //   84db                 | test                bl, bl
            //   7405                 | je                  7
            //   c644246c01           | mov                 byte ptr [esp + 0x6c], 1
            //   097c2470             | or                  dword ptr [esp + 0x70], edi

        $sequence_1 = { c645fc10 e8???????? 83bdd0fdffff08 720f 8b95bcfdffff 52 e8???????? }
            // n = 7, score = 100
            //   c645fc10             | mov                 byte ptr [ebp - 4], 0x10
            //   e8????????           |                     
            //   83bdd0fdffff08       | cmp                 dword ptr [ebp - 0x230], 8
            //   720f                 | jb                  0x11
            //   8b95bcfdffff         | mov                 edx, dword ptr [ebp - 0x244]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_2 = { e8???????? 83c41c c3 8b4c2424 5f 5e 5d }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   c3                   | ret                 
            //   8b4c2424             | mov                 ecx, dword ptr [esp + 0x24]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_3 = { 8b91f0860000 83c201 8b81f4860000 83d000 8b4d08 8991f0860000 8981f4860000 }
            // n = 7, score = 100
            //   8b91f0860000         | mov                 edx, dword ptr [ecx + 0x86f0]
            //   83c201               | add                 edx, 1
            //   8b81f4860000         | mov                 eax, dword ptr [ecx + 0x86f4]
            //   83d000               | adc                 eax, 0
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8991f0860000         | mov                 dword ptr [ecx + 0x86f0], edx
            //   8981f4860000         | mov                 dword ptr [ecx + 0x86f4], eax

        $sequence_4 = { e8???????? 83c40c 85c0 740f 8b45f8 c74048ffffffff e9???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   c74048ffffffff       | mov                 dword ptr [eax + 0x48], 0xffffffff
            //   e9????????           |                     

        $sequence_5 = { e8???????? 50 8d85b8060000 50 c645fc0c e8???????? 83c40c }
            // n = 7, score = 100
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d85b8060000         | lea                 eax, [ebp + 0x6b8]
            //   50                   | push                eax
            //   c645fc0c             | mov                 byte ptr [ebp - 4], 0xc
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_6 = { c1ef10 c1ed18 330cad18d45f00 81e7ff000000 2b0cbd18d85f00 8b7808 33f1 }
            // n = 7, score = 100
            //   c1ef10               | shr                 edi, 0x10
            //   c1ed18               | shr                 ebp, 0x18
            //   330cad18d45f00       | xor                 ecx, dword ptr [ebp*4 + 0x5fd418]
            //   81e7ff000000         | and                 edi, 0xff
            //   2b0cbd18d85f00       | sub                 ecx, dword ptr [edi*4 + 0x5fd818]
            //   8b7808               | mov                 edi, dword ptr [eax + 8]
            //   33f1                 | xor                 esi, ecx

        $sequence_7 = { e8???????? 83c40c c744241401000000 89742418 c744241c00000000 83fe08 0f87c2010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c744241401000000     | mov                 dword ptr [esp + 0x14], 1
            //   89742418             | mov                 dword ptr [esp + 0x18], esi
            //   c744241c00000000     | mov                 dword ptr [esp + 0x1c], 0
            //   83fe08               | cmp                 esi, 8
            //   0f87c2010000         | ja                  0x1c8

        $sequence_8 = { e8???????? a1???????? 33c4 89842450010000 53 55 8bac2460010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   89842450010000       | mov                 dword ptr [esp + 0x150], eax
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   8bac2460010000       | mov                 ebp, dword ptr [esp + 0x160]

        $sequence_9 = { e8???????? 83c408 85c0 7473 8b4df0 8b91a8020000 8b45f0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7473                 | je                  0x75
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   8b91a8020000         | mov                 edx, dword ptr [ecx + 0x2a8]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

    condition:
        7 of them and filesize < 6864896
}