rule win_fakeword_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fakeword."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fakeword"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 750d 381c08 7408 8bd1 8915???????? 8a0408 3ac3 }
            // n = 7, score = 200
            //   750d                 | jne                 0xf
            //   381c08               | cmp                 byte ptr [eax + ecx], bl
            //   7408                 | je                  0xa
            //   8bd1                 | mov                 edx, ecx
            //   8915????????         |                     
            //   8a0408               | mov                 al, byte ptr [eax + ecx]
            //   3ac3                 | cmp                 al, bl

        $sequence_1 = { 89442418 33c0 8a07 50 }
            // n = 4, score = 200
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   33c0                 | xor                 eax, eax
            //   8a07                 | mov                 al, byte ptr [edi]
            //   50                   | push                eax

        $sequence_2 = { 03ce 0fbe540cd8 52 68???????? 50 ff15???????? 83c40c }
            // n = 7, score = 200
            //   03ce                 | add                 ecx, esi
            //   0fbe540cd8           | movsx               edx, byte ptr [esp + ecx - 0x28]
            //   52                   | push                edx
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_3 = { 41 81f900010000 89448afc 7cd4 }
            // n = 4, score = 200
            //   41                   | inc                 ecx
            //   81f900010000         | cmp                 ecx, 0x100
            //   89448afc             | mov                 dword ptr [edx + ecx*4 - 4], eax
            //   7cd4                 | jl                  0xffffffd6

        $sequence_4 = { 83e210 f3ab 80fa10 c684246c02000007 743d 8d442458 }
            // n = 6, score = 200
            //   83e210               | and                 edx, 0x10
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   80fa10               | cmp                 dl, 0x10
            //   c684246c02000007     | mov                 byte ptr [esp + 0x26c], 7
            //   743d                 | je                  0x3f
            //   8d442458             | lea                 eax, [esp + 0x58]

        $sequence_5 = { 83f804 7519 56 6a07 8d442418 }
            // n = 5, score = 200
            //   83f804               | cmp                 eax, 4
            //   7519                 | jne                 0x1b
            //   56                   | push                esi
            //   6a07                 | push                7
            //   8d442418             | lea                 eax, [esp + 0x18]

        $sequence_6 = { 3a5418ff 750b 83f801 7459 3a5418fe 7453 40 }
            // n = 7, score = 200
            //   3a5418ff             | cmp                 dl, byte ptr [eax + ebx - 1]
            //   750b                 | jne                 0xd
            //   83f801               | cmp                 eax, 1
            //   7459                 | je                  0x5b
            //   3a5418fe             | cmp                 dl, byte ptr [eax + ebx - 2]
            //   7453                 | je                  0x55
            //   40                   | inc                 eax

        $sequence_7 = { 8b6c2420 8b4c2430 8b5c2434 41 83c304 83f908 894c2430 }
            // n = 7, score = 200
            //   8b6c2420             | mov                 ebp, dword ptr [esp + 0x20]
            //   8b4c2430             | mov                 ecx, dword ptr [esp + 0x30]
            //   8b5c2434             | mov                 ebx, dword ptr [esp + 0x34]
            //   41                   | inc                 ecx
            //   83c304               | add                 ebx, 4
            //   83f908               | cmp                 ecx, 8
            //   894c2430             | mov                 dword ptr [esp + 0x30], ecx

        $sequence_8 = { c3 8b4c241c 56 51 e8???????? 8b442414 }
            // n = 6, score = 200
            //   c3                   | ret                 
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   56                   | push                esi
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]

        $sequence_9 = { 85ff 7446 8b7010 8b042f 03fd 03f5 }
            // n = 6, score = 200
            //   85ff                 | test                edi, edi
            //   7446                 | je                  0x48
            //   8b7010               | mov                 esi, dword ptr [eax + 0x10]
            //   8b042f               | mov                 eax, dword ptr [edi + ebp]
            //   03fd                 | add                 edi, ebp
            //   03f5                 | add                 esi, ebp

    condition:
        7 of them and filesize < 98304
}