rule win_fast_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fast_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fast_pos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 8b7510 c745fc00000000 57 8bf9 85f6 792b }
            // n = 7, score = 1000
            //   56                   | push                esi
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   85f6                 | test                esi, esi
            //   792b                 | jns                 0x2d

        $sequence_1 = { 50 68???????? 56 c7857cffffff01000000 e8???????? }
            // n = 5, score = 1000
            //   50                   | push                eax
            //   68????????           |                     
            //   56                   | push                esi
            //   c7857cffffff01000000     | mov    dword ptr [ebp - 0x84], 1
            //   e8????????           |                     

        $sequence_2 = { ffb5e8feffff ff15???????? 85c0 7517 }
            // n = 4, score = 1000
            //   ffb5e8feffff         | push                dword ptr [ebp - 0x118]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7517                 | jne                 0x19

        $sequence_3 = { 5d c20c00 81feffffff7f 7ecf eb33 8b49f0 }
            // n = 6, score = 1000
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   81feffffff7f         | cmp                 esi, 0x7fffffff
            //   7ecf                 | jle                 0xffffffd1
            //   eb33                 | jmp                 0x35
            //   8b49f0               | mov                 ecx, dword ptr [ecx - 0x10]

        $sequence_4 = { 8bec 8b4508 53 56 8bd9 8b30 }
            // n = 6, score = 1000
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8bd9                 | mov                 ebx, ecx
            //   8b30                 | mov                 esi, dword ptr [eax]

        $sequence_5 = { e8???????? 6a10 68???????? 68???????? 6a00 ff15???????? 6a00 }
            // n = 7, score = 1000
            //   e8????????           |                     
            //   6a10                 | push                0x10
            //   68????????           |                     
            //   68????????           |                     
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   6a00                 | push                0

        $sequence_6 = { 6a64 8d4580 c745fc00000000 50 89b578ffffff c7857cffffff00000000 ff15???????? }
            // n = 7, score = 1000
            //   6a64                 | push                0x64
            //   8d4580               | lea                 eax, [ebp - 0x80]
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   50                   | push                eax
            //   89b578ffffff         | mov                 dword ptr [ebp - 0x88], esi
            //   c7857cffffff00000000     | mov    dword ptr [ebp - 0x84], 0
            //   ff15????????         |                     

        $sequence_7 = { 0f9485ebfeffff 83c2f0 83cfff 8bc7 8d4a0c f00fc101 48 }
            // n = 7, score = 1000
            //   0f9485ebfeffff       | sete                byte ptr [ebp - 0x115]
            //   83c2f0               | add                 edx, -0x10
            //   83cfff               | or                  edi, 0xffffffff
            //   8bc7                 | mov                 eax, edi
            //   8d4a0c               | lea                 ecx, [edx + 0xc]
            //   f00fc101             | lock xadd           dword ptr [ecx], eax
            //   48                   | dec                 eax

        $sequence_8 = { 56 c785e8feffff01000000 e8???????? 83c40c 8bc6 }
            // n = 5, score = 1000
            //   56                   | push                esi
            //   c785e8feffff01000000     | mov    dword ptr [ebp - 0x118], 1
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8bc6                 | mov                 eax, esi

        $sequence_9 = { e8???????? ff30 ff15???????? 8b95e4feffff 8bcf }
            // n = 5, score = 1000
            //   e8????????           |                     
            //   ff30                 | push                dword ptr [eax]
            //   ff15????????         |                     
            //   8b95e4feffff         | mov                 edx, dword ptr [ebp - 0x11c]
            //   8bcf                 | mov                 ecx, edi

    condition:
        7 of them and filesize < 327680
}