rule win_fatduke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fatduke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fatduke"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c404 c7451c07000000 c7451800000000 33c0 66894508 c745fcffffffff }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c7451c07000000       | mov                 dword ptr [ebp + 0x1c], 7
            //   c7451800000000       | mov                 dword ptr [ebp + 0x18], 0
            //   33c0                 | xor                 eax, eax
            //   66894508             | mov                 word ptr [ebp + 8], ax
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff

        $sequence_1 = { e8???????? c745fc00000000 33c0 8b4d08 c706???????? f6c101 7505 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   33c0                 | xor                 eax, eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   c706????????         |                     
            //   f6c101               | test                cl, 1
            //   7505                 | jne                 7

        $sequence_2 = { 8b4004 8a540840 8855ee 8b4c0838 8b4120 833800 7423 }
            // n = 7, score = 200
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   8a540840             | mov                 dl, byte ptr [eax + ecx + 0x40]
            //   8855ee               | mov                 byte ptr [ebp - 0x12], dl
            //   8b4c0838             | mov                 ecx, dword ptr [eax + ecx + 0x38]
            //   8b4120               | mov                 eax, dword ptr [ecx + 0x20]
            //   833800               | cmp                 dword ptr [eax], 0
            //   7423                 | je                  0x25

        $sequence_3 = { c784248800000000000000 c784248c00000000000000 c784248c0000000f000000 c784248800000000000000 c644247800 803a00 7504 }
            // n = 7, score = 200
            //   c784248800000000000000     | mov    dword ptr [esp + 0x88], 0
            //   c784248c00000000000000     | mov    dword ptr [esp + 0x8c], 0
            //   c784248c0000000f000000     | mov    dword ptr [esp + 0x8c], 0xf
            //   c784248800000000000000     | mov    dword ptr [esp + 0x88], 0
            //   c644247800           | mov                 byte ptr [esp + 0x78], 0
            //   803a00               | cmp                 byte ptr [edx], 0
            //   7504                 | jne                 6

        $sequence_4 = { a1???????? 33c4 50 8d442430 64a300000000 8bf1 ff74240c }
            // n = 7, score = 200
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   50                   | push                eax
            //   8d442430             | lea                 eax, [esp + 0x30]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8bf1                 | mov                 esi, ecx
            //   ff74240c             | push                dword ptr [esp + 0xc]

        $sequence_5 = { 8b450c 8901 8bc1 8b4df4 64890d00000000 59 5f }
            // n = 7, score = 200
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8bc1                 | mov                 eax, ecx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi

        $sequence_6 = { c745e000000000 8d45b4 50 8d45e0 50 6a01 8d45e8 }
            // n = 7, score = 200
            //   c745e000000000       | mov                 dword ptr [ebp - 0x20], 0
            //   8d45b4               | lea                 eax, [ebp - 0x4c]
            //   50                   | push                eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   8d45e8               | lea                 eax, [ebp - 0x18]

        $sequence_7 = { e9???????? 8b4df0 81c104030000 e9???????? 8b4df0 81c11c030000 e9???????? }
            // n = 7, score = 200
            //   e9????????           |                     
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   81c104030000         | add                 ecx, 0x304
            //   e9????????           |                     
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   81c11c030000         | add                 ecx, 0x31c
            //   e9????????           |                     

        $sequence_8 = { c745fc00000000 8b450c 894114 8b4510 894118 8b4514 89411c }
            // n = 7, score = 200
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   894114               | mov                 dword ptr [ecx + 0x14], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   894118               | mov                 dword ptr [ecx + 0x18], eax
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   89411c               | mov                 dword ptr [ecx + 0x1c], eax

        $sequence_9 = { 8d45d8 50 8d5508 8d4dc0 e8???????? 83c404 c645fc02 }
            // n = 7, score = 200
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   8d5508               | lea                 edx, [ebp + 8]
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2

    condition:
        7 of them and filesize < 9012224
}