rule win_felismus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.felismus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.felismus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4514 8b35???????? 50 ff15???????? e9???????? 6804010000 e8???????? }
            // n = 7, score = 100
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   8b35????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   e9????????           |                     
            //   6804010000           | push                0x104
            //   e8????????           |                     

        $sequence_1 = { 03c3 5f 894d04 895508 89450c 5e 5d }
            // n = 7, score = 100
            //   03c3                 | add                 eax, ebx
            //   5f                   | pop                 edi
            //   894d04               | mov                 dword ptr [ebp + 4], ecx
            //   895508               | mov                 dword ptr [ebp + 8], edx
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_2 = { 53 56 57 6804010000 e8???????? 8b7c241c 8bd8 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   6804010000           | push                0x104
            //   e8????????           |                     
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]
            //   8bd8                 | mov                 ebx, eax

        $sequence_3 = { 83c640 83c740 3bf5 7ce6 8b4c2418 33c0 eb02 }
            // n = 7, score = 100
            //   83c640               | add                 esi, 0x40
            //   83c740               | add                 edi, 0x40
            //   3bf5                 | cmp                 esi, ebp
            //   7ce6                 | jl                  0xffffffe8
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   33c0                 | xor                 eax, eax
            //   eb02                 | jmp                 4

        $sequence_4 = { 8d842430010000 50 33f6 ffd7 85c0 7e26 8a843430010000 }
            // n = 7, score = 100
            //   8d842430010000       | lea                 eax, [esp + 0x130]
            //   50                   | push                eax
            //   33f6                 | xor                 esi, esi
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7e26                 | jle                 0x28
            //   8a843430010000       | mov                 al, byte ptr [esp + esi + 0x130]

        $sequence_5 = { 8a46ff 83e03f 41 4f 8a907c520110 8851ff }
            // n = 6, score = 100
            //   8a46ff               | mov                 al, byte ptr [esi - 1]
            //   83e03f               | and                 eax, 0x3f
            //   41                   | inc                 ecx
            //   4f                   | dec                 edi
            //   8a907c520110         | mov                 dl, byte ptr [eax + 0x1001527c]
            //   8851ff               | mov                 byte ptr [ecx - 1], dl

        $sequence_6 = { 55 8b2d???????? 56 57 6804010000 ffd5 8bf0 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8b2d????????         |                     
            //   56                   | push                esi
            //   57                   | push                edi
            //   6804010000           | push                0x104
            //   ffd5                 | call                ebp
            //   8bf0                 | mov                 esi, eax

        $sequence_7 = { 56 ffd7 8d4c241c 6a00 51 6a02 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   6a02                 | push                2

        $sequence_8 = { 740a 3818 7406 ff15???????? b8???????? c3 }
            // n = 6, score = 100
            //   740a                 | je                  0xc
            //   3818                 | cmp                 byte ptr [eax], bl
            //   7406                 | je                  8
            //   ff15????????         |                     
            //   b8????????           |                     
            //   c3                   | ret                 

        $sequence_9 = { 8bd8 b93f000000 33c0 8bfb f3ab 66ab 83c404 }
            // n = 7, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   b93f000000           | mov                 ecx, 0x3f
            //   33c0                 | xor                 eax, eax
            //   8bfb                 | mov                 edi, ebx
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   83c404               | add                 esp, 4

    condition:
        7 of them and filesize < 204800
}