rule win_fengine_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fengine."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fengine"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 85c0 0f84c5020000 68???????? 53 e8???????? }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f84c5020000         | je                  0x2cb
            //   68????????           |                     
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_1 = { 57 ff32 ff15???????? f7d8 1bc0 5e }
            // n = 6, score = 100
            //   57                   | push                edi
            //   ff32                 | push                dword ptr [edx]
            //   ff15????????         |                     
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   5e                   | pop                 esi

        $sequence_2 = { 57 8d8decefffff 51 50 8d85fcf7ffff 50 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   8d8decefffff         | lea                 ecx, [ebp - 0x1014]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   8d85fcf7ffff         | lea                 eax, [ebp - 0x804]
            //   50                   | push                eax

        $sequence_3 = { 50 e8???????? 8d5590 83c40c 8d4a01 8d642400 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d5590               | lea                 edx, [ebp - 0x70]
            //   83c40c               | add                 esp, 0xc
            //   8d4a01               | lea                 ecx, [edx + 1]
            //   8d642400             | lea                 esp, [esp]

        $sequence_4 = { c705????????01000000 e8???????? 48 f7d8 }
            // n = 4, score = 100
            //   c705????????01000000     |     
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   f7d8                 | neg                 eax

        $sequence_5 = { 833d????????00 53 57 8bda 8bf9 7511 }
            // n = 6, score = 100
            //   833d????????00       |                     
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8bda                 | mov                 ebx, edx
            //   8bf9                 | mov                 edi, ecx
            //   7511                 | jne                 0x13

        $sequence_6 = { 8b3e 83c328 0fb74706 8955e0 894ddc 3945f8 0f8c5affffff }
            // n = 7, score = 100
            //   8b3e                 | mov                 edi, dword ptr [esi]
            //   83c328               | add                 ebx, 0x28
            //   0fb74706             | movzx               eax, word ptr [edi + 6]
            //   8955e0               | mov                 dword ptr [ebp - 0x20], edx
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   3945f8               | cmp                 dword ptr [ebp - 8], eax
            //   0f8c5affffff         | jl                  0xffffff60

        $sequence_7 = { 8d85f0efffff 50 53 ff15???????? 85c0 }
            // n = 5, score = 100
            //   8d85f0efffff         | lea                 eax, [ebp - 0x1010]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_8 = { 7410 8b4c3012 03c8 8d4616 }
            // n = 4, score = 100
            //   7410                 | je                  0x12
            //   8b4c3012             | mov                 ecx, dword ptr [eax + esi + 0x12]
            //   03c8                 | add                 ecx, eax
            //   8d4616               | lea                 eax, [esi + 0x16]

        $sequence_9 = { 3b45e4 7740 8d45ec 50 8b45e8 51 }
            // n = 6, score = 100
            //   3b45e4               | cmp                 eax, dword ptr [ebp - 0x1c]
            //   7740                 | ja                  0x42
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 210944
}