rule win_feodo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.feodo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.feodo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 747b 6a00 6800000008 }
            // n = 4, score = 1100
            //   85c0                 | test                eax, eax
            //   747b                 | je                  0x7d
            //   6a00                 | push                0
            //   6800000008           | push                0x8000000

        $sequence_1 = { 85d2 740a 03ca 397144 75f3 8b7904 }
            // n = 6, score = 1100
            //   85d2                 | test                edx, edx
            //   740a                 | je                  0xc
            //   03ca                 | add                 ecx, edx
            //   397144               | cmp                 dword ptr [ecx + 0x44], esi
            //   75f3                 | jne                 0xfffffff5
            //   8b7904               | mov                 edi, dword ptr [ecx + 4]

        $sequence_2 = { 6a00 6a03 57 8d442424 50 ff15???????? }
            // n = 6, score = 1100
            //   6a00                 | push                0
            //   6a03                 | push                3
            //   57                   | push                edi
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_3 = { ff15???????? 85c0 743d 8d4c2404 }
            // n = 4, score = 1100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   743d                 | je                  0x3f
            //   8d4c2404             | lea                 ecx, [esp + 4]

        $sequence_4 = { 56 6808020000 8d442444 50 }
            // n = 4, score = 1100
            //   56                   | push                esi
            //   6808020000           | push                0x208
            //   8d442444             | lea                 eax, [esp + 0x44]
            //   50                   | push                eax

        $sequence_5 = { 83ec0c 56 57 33ff 57 6a02 6a02 }
            // n = 7, score = 1100
            //   83ec0c               | sub                 esp, 0xc
            //   56                   | push                esi
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   57                   | push                edi
            //   6a02                 | push                2
            //   6a02                 | push                2

        $sequence_6 = { 8bf0 85f6 75e0 6a00 57 }
            // n = 5, score = 1100
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   75e0                 | jne                 0xffffffe2
            //   6a00                 | push                0
            //   57                   | push                edi

        $sequence_7 = { 56 57 ff15???????? 8bf0 85f6 75e0 6a00 }
            // n = 7, score = 1100
            //   56                   | push                esi
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   75e0                 | jne                 0xffffffe2
            //   6a00                 | push                0

        $sequence_8 = { 6a20 8d542404 52 ff15???????? 8d0424 50 }
            // n = 6, score = 1100
            //   6a20                 | push                0x20
            //   8d542404             | lea                 edx, [esp + 4]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8d0424               | lea                 eax, [esp]
            //   50                   | push                eax

        $sequence_9 = { 743d 8d4c2404 51 8d542424 52 }
            // n = 5, score = 1100
            //   743d                 | je                  0x3f
            //   8d4c2404             | lea                 ecx, [esp + 4]
            //   51                   | push                ecx
            //   8d542424             | lea                 edx, [esp + 0x24]
            //   52                   | push                edx

    condition:
        7 of them and filesize < 270336
}