rule win_fickle_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fickle."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fickle"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 80f12a 884c241e 0f280424 0f29442470 0f1044240f 0f1144247f 8dbc24a0000000 }
            // n = 7, score = 100
            //   80f12a               | xor                 cl, 0x2a
            //   884c241e             | mov                 byte ptr [esp + 0x1e], cl
            //   0f280424             | movaps              xmm0, xmmword ptr [esp]
            //   0f29442470           | movaps              xmmword ptr [esp + 0x70], xmm0
            //   0f1044240f           | movups              xmm0, xmmword ptr [esp + 0xf]
            //   0f1144247f           | movups              xmmword ptr [esp + 0x7f], xmm0
            //   8dbc24a0000000       | lea                 edi, [esp + 0xa0]

        $sequence_1 = { 660f7f442440 89542450 897c2454 894c2458 8b44240c 8944245c 803e04 }
            // n = 7, score = 100
            //   660f7f442440         | movdqa              xmmword ptr [esp + 0x40], xmm0
            //   89542450             | mov                 dword ptr [esp + 0x50], edx
            //   897c2454             | mov                 dword ptr [esp + 0x54], edi
            //   894c2458             | mov                 dword ptr [esp + 0x58], ecx
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   8944245c             | mov                 dword ptr [esp + 0x5c], eax
            //   803e04               | cmp                 byte ptr [esi], 4

        $sequence_2 = { 8b913b148901 33540804 89540c04 83c104 83f918 72ea 8a401c }
            // n = 7, score = 100
            //   8b913b148901         | mov                 edx, dword ptr [ecx + 0x189143b]
            //   33540804             | xor                 edx, dword ptr [eax + ecx + 4]
            //   89540c04             | mov                 dword ptr [esp + ecx + 4], edx
            //   83c104               | add                 ecx, 4
            //   83f918               | cmp                 ecx, 0x18
            //   72ea                 | jb                  0xffffffec
            //   8a401c               | mov                 al, byte ptr [eax + 0x1c]

        $sequence_3 = { 8d3449 8d0cb2 81c10c010000 8d14f2 8918 c7400400000000 897808 }
            // n = 7, score = 100
            //   8d3449               | lea                 esi, [ecx + ecx*2]
            //   8d0cb2               | lea                 ecx, [edx + esi*4]
            //   81c10c010000         | add                 ecx, 0x10c
            //   8d14f2               | lea                 edx, [edx + esi*8]
            //   8918                 | mov                 dword ptr [eax], ebx
            //   c7400400000000       | mov                 dword ptr [eax + 4], 0
            //   897808               | mov                 dword ptr [eax + 8], edi

        $sequence_4 = { e8???????? 83c40c 8b442418 8944246c 895c2470 8b44240c 89442474 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8944246c             | mov                 dword ptr [esp + 0x6c], eax
            //   895c2470             | mov                 dword ptr [esp + 0x70], ebx
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   89442474             | mov                 dword ptr [esp + 0x74], eax

        $sequence_5 = { 8d742450 89442450 89f1 e8???????? 89d9 e8???????? 85c0 }
            // n = 7, score = 100
            //   8d742450             | lea                 esi, [esp + 0x50]
            //   89442450             | mov                 dword ptr [esp + 0x50], eax
            //   89f1                 | mov                 ecx, esi
            //   e8????????           |                     
            //   89d9                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_6 = { 8d9c24b4000000 89d9 8d942498000000 57 e8???????? 83c404 89d9 }
            // n = 7, score = 100
            //   8d9c24b4000000       | lea                 ebx, [esp + 0xb4]
            //   89d9                 | mov                 ecx, ebx
            //   8d942498000000       | lea                 edx, [esp + 0x98]
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   89d9                 | mov                 ecx, ebx

        $sequence_7 = { e8???????? 8b1e 8b7e04 53 ff17 83c404 837f0400 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b1e                 | mov                 ebx, dword ptr [esi]
            //   8b7e04               | mov                 edi, dword ptr [esi + 4]
            //   53                   | push                ebx
            //   ff17                 | call                dword ptr [edi]
            //   83c404               | add                 esp, 4
            //   837f0400             | cmp                 dword ptr [edi + 4], 0

        $sequence_8 = { 8d0440 8b4c2464 8b7c8104 8b448108 897c240c 31ed 85c0 }
            // n = 7, score = 100
            //   8d0440               | lea                 eax, [eax + eax*2]
            //   8b4c2464             | mov                 ecx, dword ptr [esp + 0x64]
            //   8b7c8104             | mov                 edi, dword ptr [ecx + eax*4 + 4]
            //   8b448108             | mov                 eax, dword ptr [ecx + eax*4 + 8]
            //   897c240c             | mov                 dword ptr [esp + 0xc], edi
            //   31ed                 | xor                 ebp, ebp
            //   85c0                 | test                eax, eax

        $sequence_9 = { 8b54247c 8bbc2480000000 f30f7e442448 660fd6442468 8b442450 89442470 8d8c24d8000000 }
            // n = 7, score = 100
            //   8b54247c             | mov                 edx, dword ptr [esp + 0x7c]
            //   8bbc2480000000       | mov                 edi, dword ptr [esp + 0x80]
            //   f30f7e442448         | movq                xmm0, qword ptr [esp + 0x48]
            //   660fd6442468         | movq                qword ptr [esp + 0x68], xmm0
            //   8b442450             | mov                 eax, dword ptr [esp + 0x50]
            //   89442470             | mov                 dword ptr [esp + 0x70], eax
            //   8d8c24d8000000       | lea                 ecx, [esp + 0xd8]

    condition:
        7 of them and filesize < 1646592
}