rule win_findpos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.findpos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.findpos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb6c0 50 0fb6c1 50 8d85e8e7ffff 50 }
            // n = 6, score = 100
            //   0fb6c0               | movzx               eax, al
            //   50                   | push                eax
            //   0fb6c1               | movzx               eax, cl
            //   50                   | push                eax
            //   8d85e8e7ffff         | lea                 eax, [ebp - 0x1818]
            //   50                   | push                eax

        $sequence_1 = { 42 8a1a 0fb63411 0fb6c3 83ce20 83c820 2bf0 }
            // n = 7, score = 100
            //   42                   | inc                 edx
            //   8a1a                 | mov                 bl, byte ptr [edx]
            //   0fb63411             | movzx               esi, byte ptr [ecx + edx]
            //   0fb6c3               | movzx               eax, bl
            //   83ce20               | or                  esi, 0x20
            //   83c820               | or                  eax, 0x20
            //   2bf0                 | sub                 esi, eax

        $sequence_2 = { 3375f0 337df4 8b4008 8985dcfeffff }
            // n = 4, score = 100
            //   3375f0               | xor                 esi, dword ptr [ebp - 0x10]
            //   337df4               | xor                 edi, dword ptr [ebp - 0xc]
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   8985dcfeffff         | mov                 dword ptr [ebp - 0x124], eax

        $sequence_3 = { 8d4dd8 895dfc e8???????? 837dec10 8d55d8 0f4355d8 33c9 }
            // n = 7, score = 100
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   e8????????           |                     
            //   837dec10             | cmp                 dword ptr [ebp - 0x14], 0x10
            //   8d55d8               | lea                 edx, [ebp - 0x28]
            //   0f4355d8             | cmovae              edx, dword ptr [ebp - 0x28]
            //   33c9                 | xor                 ecx, ecx

        $sequence_4 = { 83791410 7202 8b09 33d2 e8???????? 85c0 7419 }
            // n = 7, score = 100
            //   83791410             | cmp                 dword ptr [ecx + 0x14], 0x10
            //   7202                 | jb                  4
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   33d2                 | xor                 edx, edx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7419                 | je                  0x1b

        $sequence_5 = { 0f84d6000000 48 0f8497000000 83e804 7468 83e803 }
            // n = 6, score = 100
            //   0f84d6000000         | je                  0xdc
            //   48                   | dec                 eax
            //   0f8497000000         | je                  0x9d
            //   83e804               | sub                 eax, 4
            //   7468                 | je                  0x6a
            //   83e803               | sub                 eax, 3

        $sequence_6 = { bf3ce91fe0 0adb e3de a863 125f55 cae845 7d31 }
            // n = 7, score = 100
            //   bf3ce91fe0           | mov                 edi, 0xe01fe93c
            //   0adb                 | or                  bl, bl
            //   e3de                 | jecxz               0xffffffe0
            //   a863                 | test                al, 0x63
            //   125f55               | adc                 bl, byte ptr [edi + 0x55]
            //   cae845               | retf                0x45e8
            //   7d31                 | jge                 0x33

        $sequence_7 = { e8???????? 6a00 6a01 8d8c2408010000 e9???????? 83fb27 0f871b010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   8d8c2408010000       | lea                 ecx, [esp + 0x108]
            //   e9????????           |                     
            //   83fb27               | cmp                 ebx, 0x27
            //   0f871b010000         | ja                  0x121

        $sequence_8 = { 57 8b7d08 3b30 7554 394510 }
            // n = 5, score = 100
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   3b30                 | cmp                 esi, dword ptr [eax]
            //   7554                 | jne                 0x56
            //   394510               | cmp                 dword ptr [ebp + 0x10], eax

        $sequence_9 = { ff15???????? 8bc8 890d???????? 85c9 743b 8b45f8 a3???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bc8                 | mov                 ecx, eax
            //   890d????????         |                     
            //   85c9                 | test                ecx, ecx
            //   743b                 | je                  0x3d
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   a3????????           |                     

    condition:
        7 of them and filesize < 286720
}