rule win_finfisher_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.finfisher."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.finfisher"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 56 8d85ccf9ffff 50 }
            // n = 4, score = 200
            //   57                   | push                edi
            //   56                   | push                esi
            //   8d85ccf9ffff         | lea                 eax, [ebp - 0x634]
            //   50                   | push                eax

        $sequence_1 = { 68???????? 6804010000 8d85ccf9ffff 50 }
            // n = 4, score = 200
            //   68????????           |                     
            //   6804010000           | push                0x104
            //   8d85ccf9ffff         | lea                 eax, [ebp - 0x634]
            //   50                   | push                eax

        $sequence_2 = { 8d85bcf7ffff 50 6a01 56 56 }
            // n = 5, score = 100
            //   8d85bcf7ffff         | lea                 eax, [ebp - 0x844]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   56                   | push                esi
            //   56                   | push                esi

        $sequence_3 = { 0f855b040000 8b85b0f7ffff 8b400c 8b8db8f7ffff 8908 89bda0f7ffff }
            // n = 6, score = 100
            //   0f855b040000         | jne                 0x461
            //   8b85b0f7ffff         | mov                 eax, dword ptr [ebp - 0x850]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   8b8db8f7ffff         | mov                 ecx, dword ptr [ebp - 0x848]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   89bda0f7ffff         | mov                 dword ptr [ebp - 0x860], edi

        $sequence_4 = { 6a04 56 ff15???????? 8bd8 3bdf 7561 }
            // n = 6, score = 100
            //   6a04                 | push                4
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   3bdf                 | cmp                 ebx, edi
            //   7561                 | jne                 0x63

        $sequence_5 = { e8???????? b982000000 8bf7 8dbddcfdffff f3a5 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   b982000000           | mov                 ecx, 0x82
            //   8bf7                 | mov                 esi, edi
            //   8dbddcfdffff         | lea                 edi, [ebp - 0x224]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_6 = { 48 7526 8b4508 8b4028 }
            // n = 4, score = 100
            //   48                   | dec                 eax
            //   7526                 | jne                 0x28
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4028               | mov                 eax, dword ptr [eax + 0x28]

        $sequence_7 = { 56 53 50 ff15???????? eb05 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   53                   | push                ebx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   eb05                 | jmp                 7

        $sequence_8 = { 8d45f4 50 53 897508 e8???????? }
            // n = 5, score = 100
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   897508               | mov                 dword ptr [ebp + 8], esi
            //   e8????????           |                     

        $sequence_9 = { 8bd8 ff15???????? 8845ff 897df8 }
            // n = 4, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   ff15????????         |                     
            //   8845ff               | mov                 byte ptr [ebp - 1], al
            //   897df8               | mov                 dword ptr [ebp - 8], edi

        $sequence_10 = { 8b7508 89b5ccfdffff 85f6 7508 }
            // n = 4, score = 100
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   89b5ccfdffff         | mov                 dword ptr [ebp - 0x234], esi
            //   85f6                 | test                esi, esi
            //   7508                 | jne                 0xa

        $sequence_11 = { 8bd8 3bde 0f8583030000 66c78572f7ffff0401 }
            // n = 4, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   3bde                 | cmp                 ebx, esi
            //   0f8583030000         | jne                 0x389
            //   66c78572f7ffff0401     | mov    word ptr [ebp - 0x88e], 0x104

        $sequence_12 = { 6824020000 68???????? e8???????? 8b7508 }
            // n = 4, score = 100
            //   6824020000           | push                0x224
            //   68????????           |                     
            //   e8????????           |                     
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]

        $sequence_13 = { 897de4 56 e8???????? 50 }
            // n = 4, score = 100
            //   897de4               | mov                 dword ptr [ebp - 0x1c], edi
            //   56                   | push                esi
            //   e8????????           |                     
            //   50                   | push                eax

    condition:
        7 of them and filesize < 262144
}