rule win_fk_undead_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fk_undead."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fk_undead"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 80bbbb02000000 0f44f9 83f807 0f87cb020000 ff2485887a0310 ff4618 }
            // n = 6, score = 100
            //   80bbbb02000000       | cmp                 byte ptr [ebx + 0x2bb], 0
            //   0f44f9               | cmove               edi, ecx
            //   83f807               | cmp                 eax, 7
            //   0f87cb020000         | ja                  0x2d1
            //   ff2485887a0310       | jmp                 dword ptr [eax*4 + 0x10037a88]
            //   ff4618               | inc                 dword ptr [esi + 0x18]

        $sequence_1 = { 8965f0 8b4508 8b750c 8b5510 33c9 898dd8f7ffff 894dfc }
            // n = 7, score = 100
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   33c9                 | xor                 ecx, ecx
            //   898dd8f7ffff         | mov                 dword ptr [ebp - 0x828], ecx
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx

        $sequence_2 = { 83bb2402000000 745a 6a0a ff37 68???????? e8???????? 83c40c }
            // n = 7, score = 100
            //   83bb2402000000       | cmp                 dword ptr [ebx + 0x224], 0
            //   745a                 | je                  0x5c
            //   6a0a                 | push                0xa
            //   ff37                 | push                dword ptr [edi]
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_3 = { 8bf0 6a02 6a02 56 ff15???????? c745fc00000000 56 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   6a02                 | push                2
            //   6a02                 | push                2
            //   56                   | push                esi
            //   ff15????????         |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   56                   | push                esi

        $sequence_4 = { 6a3a ff37 e8???????? 8bf0 83c408 85f6 0f84b7000000 }
            // n = 7, score = 100
            //   6a3a                 | push                0x3a
            //   ff37                 | push                dword ptr [edi]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c408               | add                 esp, 8
            //   85f6                 | test                esi, esi
            //   0f84b7000000         | je                  0xbd

        $sequence_5 = { 742d 8b94241c080000 8b442408 8b8c2420080000 8902 8b1424 8b842424080000 }
            // n = 7, score = 100
            //   742d                 | je                  0x2f
            //   8b94241c080000       | mov                 edx, dword ptr [esp + 0x81c]
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   8b8c2420080000       | mov                 ecx, dword ptr [esp + 0x820]
            //   8902                 | mov                 dword ptr [edx], eax
            //   8b1424               | mov                 edx, dword ptr [esp]
            //   8b842424080000       | mov                 eax, dword ptr [esp + 0x824]

        $sequence_6 = { 8b4c241c 52 8908 e8???????? 8b442418 83c404 5e }
            // n = 7, score = 100
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   52                   | push                edx
            //   8908                 | mov                 dword ptr [eax], ecx
            //   e8????????           |                     
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   83c404               | add                 esp, 4
            //   5e                   | pop                 esi

        $sequence_7 = { 0fb7780c 8b442428 8d5001 8a08 40 84c9 75f9 }
            // n = 7, score = 100
            //   0fb7780c             | movzx               edi, word ptr [eax + 0xc]
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   8d5001               | lea                 edx, [eax + 1]
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb

        $sequence_8 = { 8b6c2414 33c0 33d2 57 89442408 85ed 0f8402010000 }
            // n = 7, score = 100
            //   8b6c2414             | mov                 ebp, dword ptr [esp + 0x14]
            //   33c0                 | xor                 eax, eax
            //   33d2                 | xor                 edx, edx
            //   57                   | push                edi
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   85ed                 | test                ebp, ebp
            //   0f8402010000         | je                  0x108

        $sequence_9 = { 51 e8???????? 83c404 8903 85c0 7516 8b5500 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8903                 | mov                 dword ptr [ebx], eax
            //   85c0                 | test                eax, eax
            //   7516                 | jne                 0x18
            //   8b5500               | mov                 edx, dword ptr [ebp]

    condition:
        7 of them and filesize < 1418240
}