rule win_flagpro_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.flagpro."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flagpro"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4501 50 e8???????? 8bf8 83c420 }
            // n = 5, score = 100
            //   8d4501               | lea                 eax, [ebp + 1]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c420               | add                 esp, 0x20

        $sequence_1 = { 8b03 eb02 8bc3 55 8d2c3f }
            // n = 5, score = 100
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   eb02                 | jmp                 4
            //   8bc3                 | mov                 eax, ebx
            //   55                   | push                ebp
            //   8d2c3f               | lea                 ebp, [edi + edi]

        $sequence_2 = { ffd5 68???????? e8???????? 8b44241c }
            // n = 4, score = 100
            //   ffd5                 | call                ebp
            //   68????????           |                     
            //   e8????????           |                     
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]

        $sequence_3 = { c684249400000002 8b442448 8b08 8d542428 52 50 8b4120 }
            // n = 7, score = 100
            //   c684249400000002     | mov                 byte ptr [esp + 0x94], 2
            //   8b442448             | mov                 eax, dword ptr [esp + 0x48]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8d542428             | lea                 edx, [esp + 0x28]
            //   52                   | push                edx
            //   50                   | push                eax
            //   8b4120               | mov                 eax, dword ptr [ecx + 0x20]

        $sequence_4 = { 8b9180000000 50 ffd2 8b442418 }
            // n = 4, score = 100
            //   8b9180000000         | mov                 edx, dword ptr [ecx + 0x80]
            //   50                   | push                eax
            //   ffd2                 | call                edx
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]

        $sequence_5 = { 8b4e18 53 57 8bf8 8d5e04 83f908 7204 }
            // n = 7, score = 100
            //   8b4e18               | mov                 ecx, dword ptr [esi + 0x18]
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   8d5e04               | lea                 ebx, [esi + 4]
            //   83f908               | cmp                 ecx, 8
            //   7204                 | jb                  6

        $sequence_6 = { ffd2 47 3b7c243c 897c2450 0f8c03feffff e9???????? 8b44241c }
            // n = 7, score = 100
            //   ffd2                 | call                edx
            //   47                   | inc                 edi
            //   3b7c243c             | cmp                 edi, dword ptr [esp + 0x3c]
            //   897c2450             | mov                 dword ptr [esp + 0x50], edi
            //   0f8c03feffff         | jl                  0xfffffe09
            //   e9????????           |                     
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]

        $sequence_7 = { c744244400000000 a1???????? 8b500c b9???????? ffd2 8d7010 8974241c }
            // n = 7, score = 100
            //   c744244400000000     | mov                 dword ptr [esp + 0x44], 0
            //   a1????????           |                     
            //   8b500c               | mov                 edx, dword ptr [eax + 0xc]
            //   b9????????           |                     
            //   ffd2                 | call                edx
            //   8d7010               | lea                 esi, [eax + 0x10]
            //   8974241c             | mov                 dword ptr [esp + 0x1c], esi

        $sequence_8 = { f7e2 8bea c1ed06 45 68e8030000 }
            // n = 5, score = 100
            //   f7e2                 | mul                 edx
            //   8bea                 | mov                 ebp, edx
            //   c1ed06               | shr                 ebp, 6
            //   45                   | inc                 ebp
            //   68e8030000           | push                0x3e8

        $sequence_9 = { e8???????? 33f6 eb06 8b1d???????? b8???????? 8d5002 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   33f6                 | xor                 esi, esi
            //   eb06                 | jmp                 8
            //   8b1d????????         |                     
            //   b8????????           |                     
            //   8d5002               | lea                 edx, [eax + 2]

    condition:
        7 of them and filesize < 1411072
}