rule win_flame_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.flame."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flame"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f901 7415 e8???????? c70016000000 }
            // n = 4, score = 400
            //   83f901               | cmp                 ecx, 1
            //   7415                 | je                  0x17
            //   e8????????           |                     
            //   c70016000000         | mov                 dword ptr [eax], 0x16

        $sequence_1 = { 85c9 741a 83f901 7415 }
            // n = 4, score = 400
            //   85c9                 | test                ecx, ecx
            //   741a                 | je                  0x1c
            //   83f901               | cmp                 ecx, 1
            //   7415                 | je                  0x17

        $sequence_2 = { 7573 895dec 8d45ec 50 }
            // n = 4, score = 200
            //   7573                 | jne                 0x75
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax

        $sequence_3 = { 7428 498b5610 8b4f18 8bc3 }
            // n = 4, score = 200
            //   7428                 | inc                 ecx
            //   498b5610             | shr                 esp, 8
            //   8b4f18               | dec                 eax
            //   8bc3                 | lea                 edx, [ebp - 0x24]

        $sequence_4 = { 7428 448865dc 41c1ec08 488d55dc 448865dd 8b4f18 }
            // n = 6, score = 200
            //   7428                 | je                  0x2a
            //   448865dc             | inc                 esp
            //   41c1ec08             | mov                 byte ptr [ebp - 0x24], ah
            //   488d55dc             | inc                 ecx
            //   448865dd             | shr                 esp, 8
            //   8b4f18               | dec                 eax

        $sequence_5 = { 8d45dc 33f6 6a14 50 8975f4 8975fc }
            // n = 6, score = 200
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   33f6                 | xor                 esi, esi
            //   6a14                 | push                0x14
            //   50                   | push                eax
            //   8975f4               | mov                 dword ptr [ebp - 0xc], esi
            //   8975fc               | mov                 dword ptr [ebp - 4], esi

        $sequence_6 = { ffd7 90 eb00 4883c430 5f 5e }
            // n = 6, score = 200
            //   ffd7                 | je                  0x2b
            //   90                   | dec                 eax
            //   eb00                 | mov                 ecx, dword ptr [esp + 0x28]
            //   4883c430             | dec                 eax
            //   5f                   | lea                 edx, [esp + 0x50]
            //   5e                   | inc                 ecx

        $sequence_7 = { 7429 488b4c2428 488d542450 41b8df010000 }
            // n = 4, score = 200
            //   7429                 | dec                 ecx
            //   488b4c2428           | mov                 edx, dword ptr [esi + 0x10]
            //   488d542450           | mov                 ecx, dword ptr [edi + 0x18]
            //   41b8df010000         | mov                 eax, ebx

        $sequence_8 = { 8bce 89450c e8???????? 8b06 57 }
            // n = 5, score = 200
            //   8bce                 | mov                 ecx, esi
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   e8????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   57                   | push                edi

        $sequence_9 = { 894e10 8d4df0 51 6a40 6a0f 50 }
            // n = 6, score = 200
            //   894e10               | mov                 dword ptr [esi + 0x10], ecx
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   51                   | push                ecx
            //   6a40                 | push                0x40
            //   6a0f                 | push                0xf
            //   50                   | push                eax

        $sequence_10 = { 74ac 68???????? ff35???????? e8???????? 59 59 a3???????? }
            // n = 7, score = 200
            //   74ac                 | je                  0xffffffae
            //   68????????           |                     
            //   ff35????????         |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   a3????????           |                     

        $sequence_11 = { 6a08 59 ff7510 33c0 ff750c 8d7de0 }
            // n = 6, score = 200
            //   6a08                 | push                8
            //   59                   | pop                 ecx
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   33c0                 | xor                 eax, eax
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8d7de0               | lea                 edi, [ebp - 0x20]

        $sequence_12 = { 7428 41b918000000 4533c0 488bd0 }
            // n = 4, score = 200
            //   7428                 | mov                 eax, 0x1df
            //   41b918000000         | je                  0x2b
            //   4533c0               | dec                 eax
            //   488bd0               | mov                 ecx, dword ptr [esp + 0x28]

        $sequence_13 = { 8bbb98000000 440fb7c5 4923c7 488bce 4903c4 }
            // n = 5, score = 200
            //   8bbb98000000         | add                 esp, 0x30
            //   440fb7c5             | pop                 edi
            //   4923c7               | pop                 esi
            //   488bce               | je                  0x2a
            //   4903c4               | inc                 ecx

    condition:
        7 of them and filesize < 1676288
}